/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Category;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.keyvalues.RSAKeyValue;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RSAKeyValueResolver
extends KeyResolverSpi {
    static Category cat;
    private Element _rsaKeyElement;
    static /* synthetic */ Class class$org$apache$xml$security$keys$keyresolver$implementations$RSAKeyValueResolver;

    public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        cat.debug((Object)("Can I resolve " + element.getTagName()));
        if (element == null) {
            return false;
        }
        boolean bl = XMLUtils.elementIsInSignatureSpace(element, "KeyValue");
        boolean bl2 = XMLUtils.elementIsInSignatureSpace(element, "RSAKeyValue");
        if (bl) {
            try {
                Element element2 = XMLUtils.createDSctx(element.getOwnerDocument(), "ds", "http://www.w3.org/2000/09/xmldsig#");
                this._rsaKeyElement = (Element)XPathAPI.selectSingleNode((Node)element, (String)"./ds:RSAKeyValue", (Node)element2);
                if (this._rsaKeyElement != null) {
                    return true;
                }
            }
            catch (TransformerException transformerException) {}
        } else if (bl2) {
            this._rsaKeyElement = element;
            return true;
        }
        return false;
    }

    public PublicKey engineResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        boolean bl;
        if (!(this._rsaKeyElement != null || (bl = this.engineCanResolve(element, string, storageResolver)) && this._rsaKeyElement != null)) {
            return null;
        }
        try {
            RSAKeyValue rSAKeyValue = new RSAKeyValue(this._rsaKeyElement, string);
            return rSAKeyValue.getPublicKey();
        }
        catch (XMLSecurityException xMLSecurityException) {
            cat.debug((Object)"XMLSecurityException", (Throwable)xMLSecurityException);
            return null;
        }
    }

    public X509Certificate engineResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }

    public SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this._rsaKeyElement = null;
    }

    public RSAKeyValueResolver() {
        this.this();
    }

    static {
        Class clazz = class$org$apache$xml$security$keys$keyresolver$implementations$RSAKeyValueResolver;
        if (clazz == null) {
            clazz = class$org$apache$xml$security$keys$keyresolver$implementations$RSAKeyValueResolver = RSAKeyValueResolver.class$("org.apache.xml.security.keys.keyresolver.implementations.RSAKeyValueResolver");
        }
        cat = Category.getInstance((String)clazz.getName());
    }
}

