/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Category;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.x509.XMLX509SKI;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class X509SKIResolver
extends KeyResolverSpi {
    static Category cat;
    private NodeList _x509childNodes;
    private XMLX509SKI[] _x509childObject;
    private int _currentNode;
    static /* synthetic */ Class class$org$apache$xml$security$keys$keyresolver$implementations$X509SKIResolver;

    public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        cat.debug((Object)("Can I resolve " + element.getTagName() + '?'));
        try {
            XMLUtils.guaranteeThatElementInSignatureSpace(element, "X509Data");
        }
        catch (XMLSignatureException xMLSignatureException) {
            cat.debug((Object)"I can't");
            return false;
        }
        try {
            Element element2 = XMLUtils.createDSctx(element.getOwnerDocument(), "ds", "http://www.w3.org/2000/09/xmldsig#");
            this._x509childNodes = XPathAPI.selectNodeList((Node)element, (String)"./ds:X509SKI", (Node)element2);
            if (this._x509childNodes != null && this._x509childNodes.getLength() > 0) {
                cat.debug((Object)"Yes Sir, I can");
                return true;
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        cat.debug((Object)"I can't");
        return false;
    }

    public PublicKey engineResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        X509Certificate x509Certificate = this.engineResolveX509Certificate(element, string, storageResolver);
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        try {
            int n;
            if (this._x509childNodes == null && ((n = this.engineCanResolve(element, string, storageResolver)) == 0 || this._x509childNodes == null)) {
                return null;
            }
            if (storageResolver == null) {
                Object[] objectArray = new Object[]{"X509SKI"};
                KeyResolverException keyResolverException = new KeyResolverException("KeyResolver.needStorageResolver", objectArray);
                cat.info((Object)"", (Throwable)keyResolverException);
                throw keyResolverException;
            }
            this._x509childObject = new XMLX509SKI[this._x509childNodes.getLength()];
            n = 0;
            while (n < this._x509childNodes.getLength()) {
                this._x509childObject[n] = new XMLX509SKI((Element)this._x509childNodes.item(n), string);
                ++n;
            }
            while (storageResolver.hasNext()) {
                X509Certificate x509Certificate = storageResolver.next();
                XMLX509SKI xMLX509SKI = new XMLX509SKI(element.getOwnerDocument(), x509Certificate);
                int n2 = 0;
                while (n2 < this._x509childObject.length) {
                    if (xMLX509SKI.equals(this._x509childObject[n2])) {
                        cat.debug((Object)("Return PublicKey from " + x509Certificate.getSubjectDN().getName()));
                        return x509Certificate;
                    }
                    ++n2;
                }
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new KeyResolverException("empty", xMLSecurityException);
        }
        return null;
    }

    public SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this._x509childNodes = null;
        this._x509childObject = null;
        this._currentNode = 0;
    }

    public X509SKIResolver() {
        this.this();
    }

    static {
        Class clazz = class$org$apache$xml$security$keys$keyresolver$implementations$X509SKIResolver;
        if (clazz == null) {
            clazz = class$org$apache$xml$security$keys$keyresolver$implementations$X509SKIResolver = X509SKIResolver.class$("org.apache.xml.security.keys.keyresolver.implementations.X509SKIResolver");
        }
        cat = Category.getInstance((String)clazz.getName());
    }
}

