/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Category;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.AlgorithmAlreadyRegisteredException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.InvalidTransformException;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.HelperNodeList;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Transform
extends SignatureElementProxy {
    static Category cat;
    static boolean _alreadyInitialized;
    static HashMap _transformHash;
    protected TransformSpi transformSpi;
    static /* synthetic */ Class class$org$apache$xml$security$transforms$Transform;

    public static final Transform getInstance(Document document, String string) throws InvalidTransformException {
        return Transform.getInstance(document, string, null);
    }

    public static final Transform getInstance(Document document, String string, Element element) throws InvalidTransformException {
        HelperNodeList helperNodeList = new HelperNodeList();
        helperNodeList.appendChild(document.createTextNode("\n"));
        helperNodeList.appendChild(element);
        helperNodeList.appendChild(document.createTextNode("\n"));
        return Transform.getInstance(document, string, helperNodeList);
    }

    public static final Transform getInstance(Document document, String string, NodeList nodeList) throws InvalidTransformException {
        return new Transform(document, string, nodeList);
    }

    public static final void init() {
        if (!_alreadyInitialized) {
            _transformHash = new HashMap(10);
            _alreadyInitialized = true;
        }
    }

    public static final void register(String string, String string2) throws AlgorithmAlreadyRegisteredException {
        String string3 = Transform.getImplementingClass(string);
        if (string3 != null && string3.length() != 0) {
            Object[] objectArray = new Object[]{string, string3};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", objectArray);
        }
        _transformHash.put(string, string2);
    }

    public final String getURI() {
        return this._constructionElement.getAttributeNS(null, "Algorithm");
    }

    public final XMLSignatureInput performTransform(XMLSignatureInput xMLSignatureInput) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException {
        XMLSignatureInput xMLSignatureInput2 = null;
        try {
            xMLSignatureInput2 = this.transformSpi.enginePerformTransform(xMLSignatureInput);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Object[] objectArray = new Object[]{this.getURI(), "ParserConfigurationException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", objectArray, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            Object[] objectArray = new Object[]{this.getURI(), "SAXException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", objectArray, sAXException);
        }
        return xMLSignatureInput2;
    }

    private static final String getImplementingClass(String string) {
        try {
            Iterator iterator = _transformHash.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string2.equals(string)) continue;
                return (String)_transformHash.get(string2);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public final String getBaseLocalName() {
        return "Transform";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.transformSpi = null;
    }

    public Transform(Document document, String string, NodeList nodeList) throws InvalidTransformException {
        super(document);
        this.this();
        try {
            this._constructionElement.setAttributeNS(null, "Algorithm", string);
            String string2 = Transform.getImplementingClass(string);
            cat.debug((Object)("Create URI \"" + string + "\" class \"" + string2 + '\"'));
            cat.debug((Object)("The NodeList is " + nodeList));
            this.transformSpi = (TransformSpi)Class.forName(string2).newInstance();
            this.transformSpi.setTransform(this);
            if (nodeList != null) {
                int n = 0;
                while (n < nodeList.getLength()) {
                    this._constructionElement.appendChild(nodeList.item(n).cloneNode(true));
                    ++n;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object[] objectArray = new Object[]{string};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray, classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Object[] objectArray = new Object[]{string};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            Object[] objectArray = new Object[]{string};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray, instantiationException);
        }
    }

    public Transform(Element element, String string) throws InvalidTransformException, TransformationException, XMLSecurityException {
        super(element, string);
        this.this();
        String string2 = element.getAttributeNS(null, "Algorithm");
        if (string2 == null || string2.length() == 0) {
            Object[] objectArray = new Object[]{"Algorithm", "Transform"};
            throw new TransformationException("xml.WrongContent", objectArray);
        }
        try {
            String string3 = (String)_transformHash.get(string2);
            this.transformSpi = (TransformSpi)Class.forName(string3).newInstance();
            this.transformSpi.setTransform(this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object[] objectArray = new Object[]{string2};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            Object[] objectArray = new Object[]{string2};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray);
        }
        catch (InstantiationException instantiationException) {
            Object[] objectArray = new Object[]{string2};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray);
        }
    }

    static {
        Class clazz = class$org$apache$xml$security$transforms$Transform;
        if (clazz == null) {
            clazz = class$org$apache$xml$security$transforms$Transform = Transform.class$("org.apache.xml.security.transforms.Transform");
        }
        cat = Category.getInstance((String)clazz.getName());
        _alreadyInitialized = false;
        _transformHash = null;
    }
}

