/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.c14n.helper.AlwaysAcceptNodeFilter;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.SAXException;

public class TransformBase64Decode
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/2000/09/xmldsig#base64";

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    public boolean wantsOctetStream() {
        return true;
    }

    public boolean wantsNodeSet() {
        return true;
    }

    public boolean returnsOctetStream() {
        return true;
    }

    public boolean returnsNodeSet() {
        return false;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput) throws IOException, CanonicalizationException, TransformationException, InvalidCanonicalizerException {
        if (xMLSignatureInput.isOctetStream()) {
            try {
                byte[] byArray = xMLSignatureInput.getBytes();
                byte[] byArray2 = Base64.decode(byArray);
                return new XMLSignatureInput(new ByteArrayInputStream(byArray2));
            }
            catch (Base64DecodingException base64DecodingException) {
                throw new TransformationException("empty", base64DecodingException);
            }
        }
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xMLSignatureInput.getOctetStream());
            DocumentTraversal documentTraversal = (DocumentTraversal)((Object)document);
            Document document2 = document;
            AlwaysAcceptNodeFilter alwaysAcceptNodeFilter = new AlwaysAcceptNodeFilter();
            TreeWalker treeWalker = documentTraversal.createTreeWalker(document2, -1, alwaysAcceptNodeFilter, true);
            StringBuffer stringBuffer = new StringBuffer();
            this.process(treeWalker, stringBuffer);
            byte[] byArray = Base64.decode(stringBuffer.toString());
            return new XMLSignatureInput(new ByteArrayInputStream(byArray));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new TransformationException("c14n.Canonicalizer.Exception", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new TransformationException("c14n.Canonicalizer.Exception", sAXException);
        }
        catch (Base64DecodingException base64DecodingException) {
            throw new TransformationException("empty", base64DecodingException);
        }
    }

    private final void process(TreeWalker treeWalker, StringBuffer stringBuffer) {
        Node node = treeWalker.getCurrentNode();
        if (node.getNodeType() == 3) {
            stringBuffer.append(((Text)node).getData());
        }
        Node node2 = treeWalker.firstChild();
        while (node2 != null) {
            this.process(treeWalker, stringBuffer);
            node2 = treeWalker.nextSibling();
        }
        treeWalker.setCurrentNode(node);
    }
}

