/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Category;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.I18n;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class Base64 {
    static Category cat;
    public static final String LINE_SEPARATOR = "\n";
    public static final int BASE64DEFAULTLENGTH = 76;
    static int _base64length;
    static /* synthetic */ Class class$org$apache$xml$security$utils$Base64;

    public static void setBase64WrapLength(int n) {
        _base64length = n;
    }

    public static int getBase64WrapLength() {
        return _base64length;
    }

    static byte[] getBytes(BigInteger bigInteger, int n) {
        if ((n = n + 7 >> 3 << 3) < bigInteger.bitLength()) {
            throw new IllegalArgumentException(I18n.translate("utils.Base64.IllegalBitlength"));
        }
        byte[] byArray = bigInteger.toByteArray();
        if (bigInteger.bitLength() % 8 != 0 && bigInteger.bitLength() / 8 + 1 == n / 8) {
            return byArray;
        }
        int n2 = 0;
        int n3 = byArray.length;
        if (bigInteger.bitLength() % 8 == 0) {
            n2 = 1;
            --n3;
        }
        int n4 = n / 8 - n3;
        byte[] byArray2 = new byte[n / 8];
        System.arraycopy(byArray, n2, byArray2, n4, n3);
        return byArray2;
    }

    public static String encode(BigInteger bigInteger) {
        return Base64.encode(Base64.getBytes(bigInteger, bigInteger.bitLength()));
    }

    public static byte[] encode(BigInteger bigInteger, int n) {
        if ((n = n + 7 >> 3 << 3) < bigInteger.bitLength()) {
            throw new IllegalArgumentException(I18n.translate("utils.Base64.IllegalBitlength"));
        }
        byte[] byArray = bigInteger.toByteArray();
        if (bigInteger.bitLength() % 8 != 0 && bigInteger.bitLength() / 8 + 1 == n / 8) {
            return byArray;
        }
        int n2 = 0;
        int n3 = byArray.length;
        if (bigInteger.bitLength() % 8 == 0) {
            n2 = 1;
            --n3;
        }
        int n4 = n / 8 - n3;
        byte[] byArray2 = new byte[n / 8];
        System.arraycopy(byArray, n2, byArray2, n4, n3);
        return byArray2;
    }

    public static BigInteger decodeBigIntegerFromElement(Element element) throws Base64DecodingException {
        return new BigInteger(1, Base64.decode(element));
    }

    public static BigInteger decodeBigIntegerFromText(Text text) throws Base64DecodingException {
        return new BigInteger(1, Base64.decode(text.getData()));
    }

    public static void fillElementWithBigInteger(Element element, BigInteger bigInteger) {
        String string = Base64.encode(bigInteger);
        if (string.length() > 76) {
            string = LINE_SEPARATOR + string + '\n';
        }
        Document document = element.getOwnerDocument();
        Text text = document.createTextNode(string);
        element.appendChild(text);
    }

    public static byte[] decode(Element element) throws Base64DecodingException {
        NodeList nodeList = element.getChildNodes();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeType() == 3) {
                Text text = (Text)nodeList.item(n);
                stringBuffer.append(text.getData());
            }
            ++n;
        }
        return Base64.decode(stringBuffer.toString());
    }

    public static Element encodeToElement(Document document, String string, byte[] byArray) {
        Element element = XMLUtils.createElementInSignatureSpace(document, string);
        Text text = document.createTextNode(Base64.encode(byArray));
        element.appendChild(text);
        return element;
    }

    public static byte[] decode(byte[] byArray) throws Base64DecodingException {
        try {
            return Base64.decode(new String(byArray, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new byte[0];
        }
    }

    public static byte[] decode(String string) throws Base64DecodingException {
        try {
            if (string.length() < 30) {
                cat.debug((Object)("I was asked to decode \"" + string + '\"'));
            } else {
                cat.debug((Object)("I was asked to decode \"" + string.substring(0, 20) + "...\""));
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\r\t", false);
            StringBuffer stringBuffer = new StringBuffer(string.length());
            while (stringTokenizer.hasMoreElements()) {
                stringBuffer.append(stringTokenizer.nextToken());
            }
            string = stringBuffer.toString();
            int n = 0;
            int n2 = string.length() - 1;
            while (n2 > 0 && string.charAt(n2) == '=') {
                ++n;
                --n2;
            }
            n2 = string.length() / 4 * 3 - n;
            byte[] byArray = new byte[n2];
            int n3 = 0;
            int n4 = 0;
            while (n3 < string.length()) {
                int n5 = (Base64.getValue(string.charAt(n3)) << 18) + (Base64.getValue(string.charAt(n3 + 1)) << 12) + (Base64.getValue(string.charAt(n3 + 2)) << 6) + Base64.getValue(string.charAt(n3 + 3));
                int n6 = 2;
                while (n6 >= 0) {
                    if (n4 + n6 < byArray.length) {
                        byArray[n4 + n6] = (byte)(n5 & 0xFF);
                    }
                    n5 >>= 8;
                    --n6;
                }
                n3 += 4;
                n4 += 3;
            }
            return byArray;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new Base64DecodingException("utils.Base64.IllegalBitlength", indexOutOfBoundsException);
        }
    }

    public static String encode(byte[] byArray, int n) {
        int n2 = (byArray.length + 2) / 3 * 4;
        if (n > 3) {
            n -= n % 4;
            n2 += 2 * (n2 / n);
        } else {
            n = Integer.MAX_VALUE;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = byArray.length / 3 * 3;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            if (n4 + 4 > n) {
                stringBuffer.append(LINE_SEPARATOR);
                n4 = 0;
            }
            stringBuffer.append(Base64.encodeFullBlock(byArray, n5));
            n5 += 3;
            n4 += 4;
        }
        if (n4 >= n) {
            stringBuffer.append(LINE_SEPARATOR);
        }
        if (n3 < byArray.length) {
            stringBuffer.append(Base64.encodeBlock(byArray, n3));
        }
        return stringBuffer.toString();
    }

    public static String encode(byte[] byArray) {
        return Base64.encode(byArray, Base64.getBase64WrapLength());
    }

    public static byte[] decode(BufferedReader bufferedReader) throws IOException, Base64DecodingException {
        String string;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((string = bufferedReader.readLine()) != null) {
            byte[] byArray = Base64.decode(string);
            byteArrayOutputStream.write(byArray);
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected static char[] encodeBlock(byte[] byArray, int n) {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = byArray.length - n - 1;
        int n6 = n5 >= 2 ? 2 : n5;
        int n7 = 0;
        while (n7 < 3) {
            n3 = n + n7 < byArray.length ? byArray[n + n7] : 0;
            n2 = n3 < 0 ? n3 + 256 : n3;
            n4 <<= 8;
            n4 += n2;
            ++n7;
        }
        char[] cArray = new char[4];
        n3 = 3;
        while (n3 >= 0) {
            n2 = n4 & 0x3F;
            cArray[n3] = Base64.getChar(n2);
            n4 >>= 6;
            --n3;
        }
        if (n5 < 1) {
            cArray[2] = 61;
        }
        if (n5 < 2) {
            cArray[3] = 61;
        }
        return cArray;
    }

    protected static char[] encodeFullBlock(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 3) {
            n2 <<= 8;
            n2 += 0xFF & byArray[n + n3];
            ++n3;
        }
        n2 = ((byArray[n] & 0xFF) << 16) + ((byArray[n + 1] & 0xFF) << 8) + (byArray[n + 2] & 0xFF);
        char[] cArray = new char[4];
        int n4 = 3;
        while (n4 >= 0) {
            int n5 = n2 & 0x3F;
            cArray[n4] = Base64.getChar(n5);
            n2 >>= 6;
            --n4;
        }
        return cArray;
    }

    protected static char getChar(int n) {
        if (n >= 0 && n < 26) {
            return (char)(65 + n);
        }
        if (n >= 26 && n < 52) {
            return (char)(97 + (n - 26));
        }
        if (n >= 52 && n < 62) {
            return (char)(48 + (n - 52));
        }
        if (n == 62) {
            return '+';
        }
        if (n == 63) {
            return '/';
        }
        return '?';
    }

    protected static int getValue(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        if (c == '=') {
            return 0;
        }
        return -1;
    }

    public static void main(String[] stringArray) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        String string = "<container><base64 value=\"Should be 'Hallo'\">SGFsbG8=</base64></container>";
        InputSource inputSource = new InputSource(new StringReader(string));
        Document document = documentBuilder.parse(inputSource);
        Element element = (Element)document.getDocumentElement().getChildNodes().item(0);
        System.out.println(new String(Base64.decode(element)));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private Base64() {
    }

    static {
        Class clazz = class$org$apache$xml$security$utils$Base64;
        if (clazz == null) {
            clazz = class$org$apache$xml$security$utils$Base64 = Base64.class$("org.apache.xml.security.utils.Base64");
        }
        cat = Category.getInstance((String)clazz.getName());
        _base64length = 76;
    }
}

