// -*- mode: java; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*-

package antichess.test;

import java.util.*;
import junit.framework.*;
import antichess.*;

/**
 * Tests for the Piece class
 **/
public class PieceTests extends TestCase
{
	PieceType pieceType = new NullPieceType();
	
	public PieceTests(String name) {
		super(name);
	}

	private void tryPiece(Player p, PieceType pt, int r, int c) {
		Piece piece = new Piece(p, pt, r, c);
		tryPiece(piece, p, pt, r, c);
	}

	private void tryPiece(Piece piece, Player p, PieceType pt, int r, int c) {
		assertEquals(piece.getPlayer(), p);
		assertEquals(piece.getType(), pt);
		assertEquals(piece.getRow(), r);
		assertEquals(piece.getColumn(), c);
	}

	public void testConstructor() {
		tryPiece(Player.WHITE, pieceType, 0, 0);
		tryPiece(Player.WHITE, pieceType, -1, -1);
		tryPiece(Player.BLACK, pieceType, -1, -1);
		tryPiece(Player.BLACK, pieceType, 2, 4);
	}

	public void testMove() {
		Piece piece = new Piece(Player.WHITE, pieceType, 0, 0);
		tryPiece(piece.moveTo(4, 4), Player.WHITE, pieceType, 4, 4);

		piece = new Piece(Player.BLACK, pieceType, 5, 5);
		tryPiece(piece.moveTo(-1, -1), Player.BLACK, pieceType, -1, -1);
	}

	public void testImmutable() {
		Piece piece = new Piece(Player.WHITE, pieceType, 0, 0);
		piece.moveTo(4, 4);
		tryPiece(piece, Player.WHITE, pieceType, 0, 0);

		piece = new Piece(Player.BLACK, pieceType, 5, 5);
		piece.moveTo(-1, -1);
		tryPiece(piece, Player.BLACK, pieceType, 5, 5);
	}

	public void testEquals() {
		Piece p = new Piece(Player.WHITE, pieceType, 0, 0);
		assertEquals(p, new Piece(Player.WHITE, pieceType, 0, 0));
		assertEquals(p, p);
		assertFalse(p.equals(null));
		assertFalse(p.equals(new Piece(Player.BLACK, pieceType, 0, 0)));
		assertFalse(p.equals(new Piece(Player.WHITE, pieceType, 1, 0)));
		assertFalse(p.equals(new Piece(Player.WHITE, pieceType, 0, 1)));
		assertFalse(p.equals(new Piece(Player.WHITE, new NullPieceType(), 0, 1)));
	}
}
