#
#  $Id: Debug.py,v 1.3 1999/08/10 09:50:37 rob Exp $
#
#  Copyright 1999 Rob Tillotson <robt@debian.org>
#  All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee or royalty is
#  hereby granted, provided that the above copyright notice appear in
#  all copies and that both the copyright notice and this permission
#  notice appear in supporting documentation or portions thereof,
#  including modifications, that you you make.
#
#  THE AUTHOR ROB TILLOTSON DISCLAIMS ALL WARRANTIES WITH REGARD TO
#  THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
#  AND FITNESS.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
#  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
#  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
#  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE!
#
"""Debugging filter.
"""

__version__ = '$Id: Debug.py,v 1.3 1999/08/10 09:50:37 rob Exp $'

__copyright__ = 'Copyright 1999 Rob Tillotson <robt@debian.org>'


from Pyrite import _

import Filter

import sys

class DebugFilter(Filter.BaseFilter):
    def __init__(self, plugin, role, f=sys.stdout):
	Filter.BaseFilter.__init__(self, plugin, role)
	self.f = f
	
    def __call__(self, records):
	for r in records:
	    r.dump(f)
	if role == 'filter':
	    return records
	
    
class Plugin(Filter.Filter):
    name = 'Debug'
    author = 'Rob Tillotson <robt@debian.org>'
    version = '0.7.2'
    description = _("Debugging filter.")
    properties = ['target']

    filter_class = DebugFilter
