#include "color.h"

mix(type)
int type;
{
	extern int list[8], mixpot;
	int more, x, y, col, curx, cury;
	int edge, lightness, col2;
	int cenx, ceny, radius, xy[2];
	char read_pixel(), read_cursor(), *dfcn();
	char next_cmd(), c;

	if(type == MIX_SAME) {
		col = -1;
		switch(c = next_cmd("number?")) {
		case NUM_PALETTE:
		case NUM_PICTURE:
		case NUM_NUM:
			col = pick(c);
			break;
		}
		if(betw(0, col, 255) && Colors[col].known > 0) {
			hcopy(Colors[col].HLS, cur_mix);
			dmix(cur_mix);
		}
		return;
	}
	if(type == MIX_CIRCLE) {
		if(!circle_drawn && dcircle())
			return;
		cenx = CX; ceny = CY; radius = CRADIUS;
		origin(cenx-radius-2, ceny+radius+1);
		zoom(16,16);
		move(cenx+1, ceny);
		set_cur_col(mixpot);
		fill();
		if(Colors[cur_color].known > 0) {
			h_to_rect(Colors[cur_color].HLS, xy, radius);
			curx = cenx + xy[X];
			cury = ceny + xy[Y];
			move(curx, cury);
			read_pixel(&col, NO);
			write_pixel(list[7]);
			edge = cenx + radius + 2;
			lightness = ceny - radius + ((2*radius+1) * Colors[cur_color].HLS[L] + 50) / 100;
			move(edge, lightness);
			read_pixel(&col2, NO);
			write_pixel(list[7]);
		}
	} else {
		dfcn("virtual", NO);
		cenx = VX; ceny = VY; radius = VRADIUS;
	}
	if(Colors[cur_color].known > 0) {
		set_table(cur_color, cur_mix);
		changed++;
	}
	more = 1;
	do {
		switch(cmd_buf = read_cursor(&x, &y, YES)) {
		case SHOW_COLOR:
			xy[X] = x - cenx;
			xy[Y] = y - ceny;
			rect_to_h(xy, cur_mix, radius);
			break;
		case LIGHTNESS:
			cur_mix[L] = 100 * (y - (ceny - radius)) / (2 * radius);
			cur_mix[L] = min(100, max(0, cur_mix[L]));
			break;
		case QUIT:
			cmd_buf = 0;
		default:
			more = 0;
			break;
		}
		set_table(cur_color, cur_mix);
		dmix(cur_mix);
	} while(more);
	if(type == MIX_CIRCLE) {
		if(Colors[cur_color].known > 0) {
			move(curx, cury);
			write_pixel(col);
			move(edge, lightness);
			write_pixel(col2);
		}
		origin(0,482);
		zoom(1,1);
	}
}
