FUNCTION barplot(
	height		/MATRIX/
	width		/REAL,1,1./
	names		/CHAR,OPTIONAL/
	space		/REAL,1,.2/
	inside		/LGL,1,TRUE/
	beside		/LGL,1,FALSE/
	horiz		/LGL,1,FALSE/
	legend		/CHAR,OPTIONAL/
	angle		/REAL,1,45./
	density		/REAL,1,5./
	col		/REAL,1/
	blocks		/LGL,1,TRUE/
	histo=		/LGL,1,FALSE/
	axes=		/LGL,1,TRUE/
	PAR
	&
	)
STATIC( logical fill; real xx(2),yy(2) )
if(histo){
	if(MISSING(space)) space[1]=0.
	else FATAL(Argument space is not allowed for histograms)
	xbeg=width[1]
	for(i=1;i<LENGTH(width);i=i+1) width[i]=width[i+1]-width[i]
	LENGTH(width)=LENGTH(width)-1
	}
else xbeg=0.

if(NCOL(height)==1){ NCOL(height)=NROW(height); NROW(height)=1 }	# row vector
if(beside){ nbar=LENGTH(height); ndiv=1; npset=NROW(height) }
else { nbar=NCOL(height); ndiv=NROW(height); npset=1 }
if(!MISSING(names) & LENGTH(names)!=nbar) FATAL(Wrong number of bar names)
STRUCTURE(
	sp	/REAL,nbar/
	w	/REAL,nbar/
	center	/REAL,nbar/
	x/REAL,2/,y/REAL,2/
	)
# compute spaces and widths, find mins,maxs, average width
call barset(height,ndiv,nbar,npset,space,LENGTH(space),width,
	LENGTH(width),sp,w,bmn,bmx,amn,amx,avw,xbeg,center,blocks)
if(horiz) { x[1]=bmn; x[2]=bmx; y[1]=amn; y[2]=amx }
else      { x[1]=amn; x[2]=amx; y[1]=bmn; y[2]=bmx }
NO_TS
SETUP
call beginz
fill = MISSING(angle) & MISSING(density) & !MISSING(col)
if(!fill) call bardrw(height,ndiv,nbar,sp,w,amn,amx,avw,inside,horiz)
if(!MISSING(angle) | !MISSING(density) | !MISSING(col) ){	# shade or fill
	if(fill) density=0.
	nbx=nbar*ndiv
	STRUCTURE(
		ang	/REAL,nbx/
		den	/REAL,nbx/
		clr	/REAL,nbx/
		omit	/INT,nbx/
		)
	if(MISSING(col)) QUERY( `col'(col) )
	call repf(angle,LENGTH(angle),ang,LENGTH(ang))
	call repf(density,LENGTH(density),den,LENGTH(den))
	call repf(col,LENGTH(col),clr,LENGTH(clr))
	call bhtchz(height,ndiv,nbar,center,w,horiz,nbx,clr,ang,den)
	if(!MISSING(legend)){
		QUERY( usr(amn,amx,ttt,bmx) )
		if(LENGTH(legend)>nbx) FATAL(More legends than bar components)
		call ifill(-1,omit,nbx)
		xx(1)=amx-.3*(amx-amn); yy(1)=bmx # upper left corner
		call legndz(LENGTH(legend),ang,den,clr,clr,omit,omit,TSTRING(),
			legend,xx,yy,1,1,-999999)
		}
	}

if(!MISSING(names)) call bnamez(height,ndiv,nbar,horiz,center,bmn,names)

if(axes){
	QUERY( tck(tck) ); SPECIFY( tck(-abs(tck)) )	# ticks backward
	if(histo)	# put on x-axis
		if(horiz) call saxisz(LEFT,TRUE,TRUE)
		else call saxisz(BOTTOM,TRUE,TRUE)
		
	if(horiz) call saxisz(BOTTOM,TRUE,TRUE)
	else call saxisz(LEFT,TRUE,TRUE)
	SPECIFY( tck(tck) )
	}

CHAIN(title,center,PAR,FILTER)
END
