ROUTINE(chull,		find convex hull)
subroutine chull(x,y,n,theta,order,Nextt,prev,onbdy,tol,nhull,fail)
real x(n),y(n),theta(n),tol; integer n,order(n),Nextt(n),prev(n),nhull
logical onbdy,fail

real px,py,r1,r2,dx1,dy1,dx2,dy2
integer i,j,k,k1,k2,nxt,n2,limit,iter; logical inside

# Step 1: Find point in interior
for(i=1; i<=n; i=i+1){	# find non-colinear triple
	j=mod(i,n)+1; k=mod(j,n)+1
	dx1=x(j)-x(i); dy1=y(j)-y(i)
	if(dx1==0. & dy1==0.) next	#identical
	dx2=x(k)-x(i); dy2=y(k)-y(i)
	if(dx2==0. & dy2==0.) next	# pts i and k identical
	if(dx1==0. & dx2==0.) next	# both vertical
	if(dx1*dx2==0.) break	# one vertical
	if(dy1/dx1 != dy2/dx2) break
	}
if(i>n) { fail=TRUE; return } else fail=FALSE
px=(x(i)+x(j)+x(k))/3.
py=(y(i)+y(j)+y(k))/3.

# Step 2: find angles
for(i=1; i<=n; i=i+1){
	dx=x(i)-px; dy=y(i)-py
	if(dx==0. & dy==0.) theta(i)=100.
	else theta(i)=atan2(dx,dy)
	}

# Step 3: sort on angle
call sortl(theta,n,order)

# Step 4: delete obvious losers, build lists
for(n2=n; n2>0; n2=n2-1) if(theta(n2)!=100.) break
for(i=1; i<=n2; i=i+1){ Nextt(i)=i+1; prev(i)=i-1 }
Nextt(n2)=1; prev(1)=n2

now=1; limit=n2
for(i=1; i<=limit; i=i+1){	# throw out inner points with same angle
	nxt=Nextt(now)
	if(theta(nxt)!=theta(now)) { now=nxt; next }
	j=order(now); k=order(nxt)
	r1=(x(j)-px)**2+(y(j)-py)**2; r2=(x(k)-px)**2+(y(k)-py)**2
	if(r1<r2) { call delete(now,Nextt,prev); now=nxt }
	else call delete(nxt,Nextt,prev)	# delete next pt if equal
	n2=n2-1
	}

# Step 5: Look for convexity in triples
limit=n2*2
for(iter=1; iter<=limit; iter=iter+1){
	i=order(now)
	nxt=Nextt(now); j=order(nxt)
	k=order(Nextt(nxt))
	if(inside(x,y,i,j,k,px,py,tol,onbdy)){
		call delete(nxt,Nextt,prev); n2=n2-1
		now=prev(now)
		}
	else now=nxt
	}

j=0	# produce result in prev vector
for(i=1; i<=n2; i=i+1){	j=j+1; prev(j)=order(now)
	if(onbdy){	# look for duplicate points thrown out in step 4
		k1=order(now)
		r1=(x(k1)-px)**2+(y(k1)-py)**2
		for(k=now+1; k<=n; k=k+1){
			k2=order(k); r2=(x(k2)-px)**2+(y(k2)-py)**2
			if(r1!=r2) break
			j=j+1
			prev(j)=k2
			}
		}
	now=Nextt(now)
	}
nhull=j
return
end


subroutine delete(i,Nextt,prev)
integer i,Nextt(1),prev(1)
integer prv,nxt

prv=prev(i); nxt=Nextt(i)
Nextt(prv)=nxt
prev(nxt)=prv
return
end


logical function inside(x,y,i,j,k,px,py,tol,onbdy)
real x(1),y(1),px,py,tol; integer i,j,k; logical onbdy

a=x(k)-x(i); b=px-x(j); c=px-x(i)
d=y(k)-y(i); e=py-y(j); f=py-y(i)
t=1.-((d*c-a*f)/(d*b-a*e))
if(abs(t)<tol) return(!onbdy)
else return(t<0.)
end
