ROUTINE(zparmz, initialize for hp2648a)
# V 1.12 of 81/11/19
subroutine zparmz(par,n)
real par(1); integer n
INCLUDE(graphics,device)
include(hp2648.m)

integer nolbl(4)

# to increase number of devices supported, change MAX_DEV and enter
# the appropriate information in the tables below
define(`MAX_DEV',2)

real xsize(MAX_DEV), ysize(MAX_DEV), xrast(MAX_DEV), yrast(MAX_DEV)
integer devtyp(MAX_DEV), device, devndx

data devtyp/	HP2648, HP2623	/
#				screen sizes in rasters
data xrast/	719.,	511.	/
data yrast/	359.,	389.	/
#				screen widths and heights
data xsize/	10.,	8.	/
data ysize/	5.,	6.	/

data nolbl/ _
	ESC,AMPER, LETJ, ATSIGN / #zap hp2623 labels

if(n>0) device=par(1); else device=devtyp(MAX_DEV)	#arbitrary decision if no device given
if(n>1) iask=par(2); else iask=1

do i = 1,39
	am(i) = 0.0

devndx=0		#look for device in list
do i = 1, MAX_DEV {
	if( device == devtyp(i) ) { devndx = i; break }
	}
if( devndx == 0 ) { devndx = MAX_DEV; device=devtyp(MAX_DEV) }

if(device == HP2623) call zoutrz(nolbl,4)

am(1) = 2.		#device can change char size
am(20) = 7.		#char width in rasters
am(21) = 10.		#char height in rasters
am(22) = 0.			#min x raster
am(23) = xrast(devndx)		#max x raster
am(24) = 0.			#min y raster
am(25) = yrast(devndx)		#max y raster
am(26) = 0.		#char addressed at lower left
am(27) = 0.
am(28) = xsize(devndx)/(am(23)-am(22))	#raster width inches
am(29) = ysize(devndx)/(am(25)-am(24))	#raster height inches
am(30) = device		#device code number
am(31) = 1.		#can rotate char
angle = BIG
size = BIG		#from tek14 driver
olty = BIG		#from tek14 driver
ixold = IMPOSX		# set position far away
iyold = IMPOSY
SPECIFY( new(FALSE) )	# force eject when next beginz encountered
return
end
