/*
 * imagen: imagen printer S graphics driver
 *	(c) 1985 Ross Ihaka
 *	debugged, adapted to different resolutions and orientations
 *		by Geoff Collyer, utstat!geoff, April 1987
 */

#include <stdio.h>
INCLUDE(device)

/* imagen dimensions */
#define DPI 300			/* dots per inch */

/* tunable characteristics */
/* #define SQUARE			/* for debugging of landscape only */
/* #define PORTRAIT yes		/* else landscape */

#ifdef SQUARE
#define HORINCH 8.5
#define VERTINCH 8.5
#else				/* SQUARE */
#ifdef PORTRAIT
#define HORINCH 8.5		/* narrow */
#define VERTINCH 11		/* tall */
#else				/* PORTRAIT */
#define HORINCH 11		/* wide */
#define VERTINCH 8.5		/* short */
#endif				/* PORTRAIT */
#endif				/* SQUARE */

/* sleazy co-ordinate mapping: S to physical */
#ifdef PORTRAIT
#define imagenx(x,y) (x)
#define VBITS (VERTINCH*DPI)
#define swapy(y) (VBITS - 1 - (y))
#define imageny(x,y) (swapy(y) < 0? 0: (swapy(y) > VBITS-1? VBITS-1: swapy(y)))
#else				/* PORTRAIT */
#define imagenx(x,y) (y)	/* landscape */
#define imageny(x,y) (x)
#endif				/* PORTRAIT */

/* impress commands */
#define SET_FAMILY		207
#define CREATE_FAMILY_TABLE	221
#define SET_HV_SYSTEM		205
#define SET_ABS_H		135
#define SET_ABS_V		137
#define CREATE_PATH		230
#define DRAW_PATH		234
#define END_PAGE		219

FILE *fp;

/* graphical parameters */
define(`am',`F77_COM(bgrp)[$1-1]')
extern float F77_COM(bgrp)[];

/* linestyle key */
int ltypes[][4] = {			/* 1 = solid */
		{  2,  5,  2,  5 },	/* 2 = dot */
		{  5,  5,  5,  5 },	/* 3 = short-dash */
		{ 10,  5, 10,  5 },	/* 4 = dash */
		{ 20,  5, 20,  5 },	/* 5 = long-dash */
		{  2,  5,  5,  5 },	/* 6 = dot-short-dash */
		{  2,  5, 10,  5 },	/* 7 = dot-dash */
		{  2,  5, 20,  5 },	/* 8 = dot-long-dash */
	};
int nltypes = 8;

/* state variables for broken linestyles */
int newline;
int olty;
int nlty, seglen, count, pendown;
int xstart, xnow, xend;
int ystart, ynow, yend;

FILE *fopen();

F77_SUB(zparmz,real=par,int=n)
{
	r_zparmz(F_REALP(par),F_INTP(n));
}

static r_zparmz(par,n)
float par[];
int *n;
{
	static char *outfile = "imagen.out"; char *getlogin();
	int i;

	for (i = 1; i <= 39; i++)
		am(i) = 0.0;

	am(20) = DPI/10;		/* character width in rasters */
	am(21) = DPI/7;			/* character height in rasters */

	am(22) = DPI/2;			/* lower x limit in rasters */
	am(23) = HORINCH*DPI - DPI/2;	/* upper x limit in rasters */

	am(24) = DPI/2;			/* lower y limit in rasters */
	am(25) = VERTINCH*DPI - DPI/2;	/* upper y limit in rasters */

	am(26) = 0.;			/* horizontal character offset */
	am(27) = 0.;			/* vertical character offset */

	am(28) = 1./DPI;		/* inches/raster (horizontal) */
	am(29) = 1./DPI;		/* inches/raster (vertical) */

	am(30) = IMAGEN;		/* to identify driver */

	am(31) = 1.;			/* characters can be rotated (1) */
	am(1) = 0.;			/* characters are fixed size (0) */

	fp = fopen(outfile, "w");
	if (fp == NULL) {
		fprintf(stderr, "can't open %s\n", outfile);
		fp = stdout;
	}
	(void) fprintf(fp, "@document(language imPRESS, pagereversal on, jobheader on, jamresistance on, owner \"%s\")\n",getlogin());
	outbyte(SET_FAMILY);
	outbyte(2);
	outbyte(CREATE_FAMILY_TABLE);
	outbyte(2);
	outbyte(1);
	outbyte(0);
	(void) fputs("cour12", fp);
	outbyte(0);
	newline = 1;			/* start of new path */
}

int xpos, ypos;

F77_SUB(zseekz,int=ix,int=iy)
{
	r_zseekz(F_INTP(ix),F_INTP(iy));
}

static r_zseekz(ix,iy)
int *ix, *iy;
{
	outbyte(SET_ABS_H);
	outword(imagenx(*ix,*iy));
	outbyte(SET_ABS_V);
	outword(imageny(*ix,*iy));
	xpos = *ix;
	ypos = *iy;
	newline = 1;
}

F77_SUB(zlinez,int=ix,int=iy)
{
	r_zlinez(F_INTP(ix),F_INTP(iy));
}

static r_zlinez(ix,iy)
int *ix, *iy;
{
	int lty;

	lty = am(8);
	if( lty < 1 || lty > nltypes )
		lty = 1;

	if( lty == 1 ) {		/* solid line type */
		draw(xpos,ypos,*ix,*iy);
		olty = 1;
	} else {
		if( lty != olty)
			newline = 1;
		dash(xpos,ypos,*ix,*iy,lty);
		olty = lty;
	}
	xpos = *ix;
	ypos = *iy;
}

F77_SUB(zptchz,char=ich,real=crot)
{
	r_zptchz(F_CHARP(ich),F_REALP(crot));
}

static r_zptchz(ich,crot)
char *ich;
float *crot;
{
	/* switch to crot orientation */
	if(*ich == ' ') return;
	outbyte(SET_HV_SYSTEM);
	switch ((int)(*crot+45)/90) {	/* degrees -> rotation code */
#ifdef PORTRAIT
	case 0:
		outbyte('\104');	/* 0 degrees from physical x */
		break;
	case 1:
		outbyte('\107');	/* 270 degrees from physical x */
		break;
	case 2:
		outbyte('\106');	/* 180 degrees from physical x */
		break;
	case 3:
		outbyte('\105');	/* 90 degrees from physical x */
		break;
#else
	/* landscape */
	case 0:
		outbyte('\105');	/* 90 degrees from physical x */
		break;
	case 1:
		outbyte('\104');	/* 0 degrees from physical x */
		break;
	case 2:
		outbyte('\106');	/* 180 degrees from physical x */
		break;
	case 3:
		outbyte('\107');	/* 270 degrees from physical x */
		break;
#endif					/* PORTRAIT */
	}

	/* emit the (rotated) character */
	(void) putc(*ich, fp);

	/* restore normal orientation */
	outbyte(SET_HV_SYSTEM);
	outbyte('\104');		/* 0 degrees from physical x */

	newline = 1;
}

nplot = 0;

F77_SUB(zejecz)
{
	if(nplot)
		outbyte(END_PAGE);
	nplot++;
	newline = 1;
}

F77_SUB(zflshz)
{
	(void) fflush(fp);
	newline = 1;
}

F77_SUB(zwrapz)
{
	(void) fclose(fp);
	newline = 1;
}

outbyte(c)
unsigned char c;
{
	(void) putc(c, fp);
}

outword(w)
unsigned w;
{
	/* TODO: 8 is BYTEWIDTH */
	(void) putc((unsigned char)(w>>8), fp);
	(void) putc((unsigned char)w, fp);
}

draw(x1,y1,x2,y2)
int x1, y1, x2, y2;
{
	outbyte(CREATE_PATH);
	outword(2);
	outword(imagenx(x1,y1));
	outword(imageny(x1,y1));
	outword(imagenx(x2,y2));
	outword(imageny(x2,y2));
	outbyte(DRAW_PATH);
	outbyte(15);		/* What's this? */
}

dash(x1,y1,x2,y2,lty)
int x1, y1, x2, y2, lty;
{
	int i, error;
	int xd, yd;
	int dx, dy;
	long dotmod();

	xd = x2-x1;
	yd = y2-y1;

	if (xd > 0)
		dx = 1;
	else {
		dx = -1;
		xd = -xd;
	}

	if (yd > 0)
		dy = 1;
	else {
		dy = -1;
		yd = -yd;
	}

	/* initial point */
	xnow = xstart = xend = x1;
	ynow = ystart = yend = y1;

	if (newline) {
		nlty = 0;
		pendown = 1;
		count = 1;
		seglen = dotmod(lty);
	}

	if (xd > yd) {		/* more horizontal */
		error = xd/2;
		for (i = 1; i < xd; i++) {
			xnow += dx;
			error -= yd;
			if (error < 0) {
				ynow += dy;
				error += xd;
			}
			count++;
			if (count > seglen) {
				if (pendown)
					draw(xstart,ystart,xend,yend);
				pendown = !pendown;
				xstart = xnow;
				ystart = ynow;
				seglen = dotmod(lty);
				count = 1;
			}
			xend = xnow;
			yend = ynow;
		}
	} else {		/* more vertical */
		error = yd/2;
		for (i = 1; i < yd; i++) {
			ynow += dy;
			error -= xd;
			if (error < 0) {
				xnow += dx;
				error += yd;
			}
			count++;
			if (count > seglen) {
				if (pendown)
					draw(xstart,ystart,xend,yend);
				pendown = !pendown;
				xstart = xnow;
				ystart = ynow;
				seglen = dotmod(lty);
				count = 1;
			}
			xend = xnow;
			yend = ynow;
		}
	}
	if (pendown)
		draw(xstart,ystart,xnow,ynow);
	newline = 0;
}

long
dotmod(lty)
int lty;
{
	if (lty < 2)			/* let's be safe */
		return 1000000;
	nlty %= 4;
	return ltypes[lty-2][nlty++];
}
