FUNCTION l1fit(
	x	/MATRIX/
	y	/REAL/
	int	/LGL,1,TRUE/
	)

STATIC( integer obs,vars,code,rank )

vars=NCOL(x)
if(int)vars=vars+1
obs=NROW(x)

CHECK(obs==LENGTH(y),FATAL(X and Y have different numbers of observations))
CHECK(obs>vars,FATAL(More variables than observations))

STRUCTURE(
	resid	/LIKE(y)/
	coef	/REAL,vars/
	)

call l1fit(x,obs,obs,NCOL(x),y,coef,resid,int,sar,rank,code)

switch(code){
	case 0:	WARNING(Non-unique solution possible)
	case 1:	;	#all ok
	default: FATAL(Premature termination)
	}
CHECK(rank==vars,WARNING(Matrix not of full rank))

RETURN(coef,resid)
END
