#leaps		furnival & wilson algorithm
FUNCTION leaps(
	x	/MATRIX/
	y	/REAL/
	wt	/REAL,OPTIONAL/
	int	/LGL,1,TRUE/
	method	/CHAR,1,STRING(Cp)/
	nbest	/INT,1,10/
	names	/CHAR,NCOL(x)/
	df	/INT,1,NROW(x)/
	)
INITIAL( tol/1e-4/ )
nobs=NROW(x); kx=NCOL(x); nv=kx+1
if(kx<3) FATAL(Too few independent variables)
if(LENGTH(y)!=nobs) FATAL(Lengths of x and y do not match)
if(nv>=8*NCPW) FATAL(Problem too large)	# regression IDs stored as bit strings
if(nv>=nobs) FATAL(More variables than observations)
if(MISSING(names))	#default names are 1-9A-Z ...
	for(i=1;i<=kx;i=i+1)
		names[i]=istrn2("123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ",i,1)
else if(LENGTH(names)<kx) FATAL(Too few names)
CTABLE(meths,r2,R2,adjr2,ADJR2,cp,Cp)
imeth=(match(method,meths)+1)/2	# map into 1, 2, 3
if(imeth<=0)FATAL(Invalid method)
ne=(kx+1)*(kx+2)/2; nl=ne*(kx+3)/3; nv2=nv*nv; ns=nbest+1
maxreg=nbest*kx
nreal=(ns+3)*nv+2*nl+ne; nint=4*nv2+8*nv+ns*nv
STRUCTURE(
	rr	/MATRIX,nv,nv/
	rscr	/REAL,nreal/
	iscr	/INT,nint/
	regid	/INT,maxreg/
	Cp	/REAL,maxreg/
	size	/INT,maxreg/
	)
if(!MISSING(wt)){
	if(LENGTH(wt)!=nobs) FATAL(Length of wt must match lengths of x & y)
	for(i=1;i<=nobs;i=i+1){
		if(wt[i]<0.)FATAL(Negative weight)
		wt[i]=sqrt(wt[i])
		}
	wnorm=snrm2(nobs,wt,1)
	for(i=1;i<=nobs;i=i+1){
		wt[i]=wt[i]/wnorm; y[i]=y[i]*wt[i]
		for(j=1;j<=kx;j=j+1) x[i,j]=x[i,j]*wt[i]
		}
	if(int) call devw(x,nobs,kx,y,1,rscr,scr2,wt)
	}
else if(int){
	call dev(x,nobs,nobs,kx,x,rscr)
	call dev(y,nobs,nobs,1,y,rscr)
	}
call matpt(x,nobs,nobs,kx,x,nobs,kx,rr,nv)
call matpt(x,nobs,nobs,kx,y,nobs,1,rr[1,nv],nv)
rr[nv,nv]=dotv(y,nobs,y)
if(int)df=df-1	# should we decrease df if user-supplied?
call leaps(rr,kx,nv,df,imeth,nbest,tol,regid,Cp,size,nreg,rscr,iscr)
STRUCTURE( label /CHAR,nreg/,  which /LGL,MATRIX,nreg,kx/)
call leaplb(regid,nreg,kx,names,label,which,iscr,iscr[kx+1])
LENGTH(Cp)=nreg; LENGTH(size)=nreg
if(int) for(i=1;i<=nreg;i=i+1) size[i]=size[i]+1
switch(imeth){
	case 1: RETURN(r2=Cp,&)
	case 2: RETURN(adjr2=Cp,&)
	case 3: RETURN(Cp,&)
	}
RETURN(size,label,which)
END
