FUNCTION matrix (
	data		/ANY,NAOK/
	nrow		/INT,1,1/
	ncol		/INT,1,1/
	byrow		/LGL,1,FALSE/
	)
STATIC( integer dlen,m )
m=LENGTH(data)
if(MISSING(nrow))nrow=m/ncol
if(MISSING(ncol))ncol=m/nrow
dlen=nrow*ncol
CHECK(mod(dlen,m)==0,WARNING(Length of data is not even multiple of nrow*ncol))
STRUCTURE(
	x		/MATRIX,MODECALC(MODE(data)),nrow,ncol/
	)
for(i=0 ; i<dlen ; i=i+m)
	call pcopy(VALUE(data),VALUE(x)+i,min0(dlen-i,m),MODE(x))

if(byrow)call transv(VALUE(x),MODE(x),ncol,nrow) #transpose the data values
RETURN(x)
END
