FUNCTION pie(
	x	/REAL/
	names	/CHAR,OPTIONAL/
	size	/REAL,1,.75/
	inner	/REAL,1,.3/
	outer	/REAL,1,1.1/
	explode	/ANY,OPTIONAL/
	angle	/REAL,1,45./
	density	/REAL,1/
	col	/REAL,1/
	rotate	/LGL,1,TRUE/
	PAR
	&
	)
STRUCTURE(
	expl	/LGL,LENGTH(x)/ 
	ang	/REAL,LENGTH(x)/
	den	/REAL,LENGTH(x)/
	clr	/REAL,LENGTH(x)/
	)
if(!MISSING(names))
	if(LENGTH(x)!=LENGTH(names)) FATAL(There must be as many names as data values)
call lfill(FALSE,expl,LENGTH(expl))
if(!MISSING(explode)) {
	SWITCH MODE(explode) {
		CASE LGL:
			for (i=1; i<=LENGTH(expl); i=i+1) 
				expl[i]=explode[mod(i-1,LENGTH(explode))+1]
		CASE INT:
			for (i=1; i<=LENGTH(explode); i=i+1) 
				if(explode[i]<=LENGTH(x))expl[explode[i]]=TRUE
				else FATAL(explode value out of bounds)
		DEFAULT: FATAL(explode must be integer or logical)
		}
	}
if(MISSING(density)){	# default density values
	if( MISSING(angle) & MISSING(col) ) density=-1	#no fill
	if( MISSING(angle) & !MISSING(col) ) density=0	#solid fill
	if( !MISSING(angle) ) density=5	#shaded
	}
if(MISSING(col)) QUERY(`col'(col))

call repf(angle,LENGTH(angle),ang,LENGTH(ang))
call repf(density,LENGTH(density),den,LENGTH(den))
call repf(col,LENGTH(col),clr,LENGTH(clr))

call beginz
if(MISSING(names))
	call piez(x,LENGTH(x),NULL,size,inner,outer,expl,ang,den,clr,rotate)
else
	call piez(x,LENGTH(x),names,size,inner,outer,expl,ang,den,clr,rotate)
CHAIN(title,PAR,FILTER)
END
