FUNCTION read(
	file/CHAR,1,SNULL/
	length/INT,1,2000/
	mode/INT,1/
	skip/INT,1,0/
	print/LGL,1,TRUE/
	debug/LGL,1,FALSE/
	)
STRUCTURE( data/REAL,length/ )
STATIC(logical eof; integer sattac,ierr,inunit)
STATIC(common/binptd/nnn,icopy; logical icopy)
icopy=debug
if(MISSING(length)) nmax=LARGEINT; else nmax=length	# when to stop reading
if(MISSING(mode))mode=ANY
switch(mode) {
case REAL, INT, CHAR, ANY: #ok
default: FATAL(invalid mode: must be numeric or character)
	}
call rdopen(TEXT(file))
call inputs(P(data),mode,skip,eof,nmax)
call rdclos
if(!eof & MISSING(length) )WARNING(End of file not reached)
if(print) { #report no. of items read
	if(!MISSING(length) & LENGTH(data)<length) EPRINT("Requested",I(length)," items; read only",I(LENGTH(data)))
	else EPRINT("Read",I(LENGTH(data))," items")
	}
RETURN(data)
END
