FUNCTION spline(&)
STRUCTURE(x,y)
PLOTARGS
if(LENGTH(x)!=LENGTH(y)) FATAL(Lengths of x and y do not match)
if(LENGTH(x)<3) FATAL(Cannot fit spline to fewer than 3 points)
call sortpr(x,LENGTH(x),y)
for(i=1; i<LENGTH(x); i=i+1)
	if(x[i]==x[i+1]) FATAL(Duplicate x points not allowed)
ARG(
	n		/INT,1,3*LENGTH(x)/
	periodic	/LGL,1,FALSE/
	boundary	/REAL,1,0./
	xmin		/REAL,1,x[1]/
	xmax		/REAL,1,x[LENGTH(x)]/
	)
if(periodic){
	if(y[1]==0.) rel=1; else rel=y[1]
	if(abs((y[1]-y[LENGTH(y)])/rel) > .0001)
		FATAL(First y value must match last y value for periodic data)
	}
nout = max(LENGTH(x),n)*2	# there may be more returned values than asked for
STRUCTURE(
	r	/REAL,LENGTH(x)+1/
	diag	/REAL,LENGTH(x)+1/
	xout	/REAL,nout/
	yout	/REAL,nout/
	)
call spline(x,y,LENGTH(x),diag,r,boundary,periodic,xmin,xmax,n,xout,yout,nout)
LENGTH(xout)=nout
LENGTH(yout)=nout
call rever(xout,nout)
call rever(yout,nout)
RETURN(x=xout,y=yout)
END
