ROUTINE(tbprt,		print table given format)
subroutine tbprt(file,modes,values,names,nvar,dim,varwid,p2,p3,width,across,
	labdir,ncatgy,margin, margn2,field,nspace,lineln,countr)
integer file,modes(nvar),nvar,dim(ncatgy),varwid(nvar),p2(nvar),p3(nvar),
	width(ncatgy),across,ncatgy,margin,margn2,field,nspace,lineln,countr(ncatgy)
POINTER values(nvar),names(nvar),labdir

INCLUDE(stack,struct,print)

integer flag,ntop,j,i,jj,wlab,left,right,delta,start,wlab2,ntimes,maxacr,otimes
POINTER pname,plabel

delta=1 #spacing for subtables
do i=1,across
	delta=delta*dim(i)
start=0
flag=0 #for indexing categories
ntop = ncatgy-across
if(nvar==1){FPRINT(file,C(TEXT(names(1)))); SKIP(file)}
repeat {
	if(ntop>0){ #print the levels at the top
		call aincr(countr,dim(across+1),ntop,flag)
		if(flag<=0)break #done
		plabel=LASTENT(labdir)
		for(j=ntop; j>0; j=j-1) {
			pname=is(VALUE(plabel)+countr(j)-1)
			FPRINT(file,C(TEXT(NAME(plabel))),": ", C(TEXT(pname)))
			plabel = plabel-LENTRY
			}
		}
	maxacr=0	# number of times across variable printed
	otimes = 0
	repeat{	# split across'th category if needed
		plabel=ENTRY(labdir,across); ntimes=1
		if(maxacr>=LENGTH(plabel)) break
		for(j=across; j>=2; j=j-1) { # plot names across
			pname=NAME(plabel)
			wlab=min0(islenz(TEXT(pname)),margin-1)
			ENCODE(C(TEXT(pname),wlab),":",T(margin))
			if(margn2>0)ENCODE(SP(nspace+margn2+nspace))
			else ENCODE(SP(nspace))
			pname=VALUE(plabel); nlevs=LENGTH(plabel)
			if(j==across){ pname=pname+maxacr; nlevs=nlevs-maxacr }
			for(i=0; i<ntimes; i=i+1) { #over repetitions of subtables
				for(jj=0; jj<nlevs; jj=jj+1) { #over levels of catgy j
					if(BUFPOS+width(j-1)>lineln) break 2
					wlab=min0(islenz(TEXT(is(pname+jj))),width(j-1))
					left=(width(j-1)-wlab)/2
					right=width(j-1)-wlab-left
					ENCODE(SP(left),C(TEXT(is(pname+jj)),wlab),SP(right))
					}
				if(j==2)ENCODE(SP(nspace))	# between replications
				}
			FPRINT(file)
			ntimes=ntimes*jj	# jj will be nlevs unless break occurred
			if(j==across) maxacr=maxacr+jj
			plabel=plabel-LENTRY
			}
	# now, print a 2-way subtable of data
		plabel=FIRSTENT(labdir)
		nl=LENGTH(plabel); pname=NAME(plabel)
		FPRINT(file,C(TEXT(pname)),":")
		plabel=VALUE(plabel)
		for(ilev=0; ilev<nl; ilev=ilev+1) { #over levels of 1st catgy
			pname=is(plabel+ilev) #pointer to name of current level
			wlab=min0(islenz(TEXT(pname)),margin-nspace)
			for(i=1; i<=nvar; i=i+1) { #over variables
				if(i==1)ENCODE(SP(nspace),C(TEXT(pname),wlab))
				ENCODE(T(margin))
				if(nvar>1) { #names for variables, if more than one
					wlab2=min0(islenz(TEXT(names(i))),margn2)
					ENCODE( SP(nspace), C(TEXT(names(i)),wlab2),SP(margn2-wlab2))
					}
				j=start+ilev+otimes*dim(1)
				for(jj=0; jj<ntimes; jj=jj+1) {
					left=(width(1)-nspace-varwid(i))/2
					right=width(1)-nspace-varwid(i)-left
					ENCODE(SP(nspace+left),V(modes(i),values(i)+j,varwid(i),p2(i),p3(i)),SP(right))
					if(mod(jj+1,nlevs)==0) ENCODE(SP(nspace))
					j=j+dim(1)
					}
				FPRINT(file)
				}
			if(nvar>1)SKIP(file)
			}
		SKIP(file)
		otimes = otimes+ntimes
		}
	start=start+delta #next subtable
	if(ntop>0) SKIP(file)
	} until(flag<=0)
return
end
