FUNCTION ts (
	data		/ANY,NAOK/
	start		/REAL,1/
	nper		/REAL,1,1./
	end		/REAL,OPTIONAL/
	tsp		/REAL,OPTIONAL/
	)

if(!MISSING(tsp)){
	if(LENGTH(tsp)!=3)FATAL(tsp must have 3 values)
	st=tsp[1]; ed=tsp[2]; pe=tsp[3]
	}
else{
	pe=nper
	if(MISSING(start)) {
		if(MISSING(end)) start=1.
		else { ed=end[1]
			if(LENGTH(end)>1) ed=ed+(end[2]-1.)/pe
			start=ed-float(LENGTH(data)-1)/pe
			}
		}
	if(LENGTH(start)>1) st=start[1]+(start[2]-1.)/pe
	else                st=start
	if(MISSING(end))       ed=st+float(LENGTH(data)-1)/pe
	else if(LENGTH(end)>1) ed=end[1]+(end[2]-1.)/pe
	else                   ed=end
	}

npts=(ed-st)*pe+1.5
m=LENGTH(data)
CHECK(npts==m|m==1,WARNING(Length of data not consistent with start end and nper))
STRUCTURE(ts/TS,st,ed,pe,MODECALC(MODE(data))/)
for(i=0 ; i<npts ; i=i+m)
	call pcopy(VALUE(data),VALUE(ts)+i,min0(npts-i,m),MODE(ts))
RETURN(ts)
END
