SUPPORT(brdpnz,		read pen position)
subroutine brdpnz(x,y,n,nmax)
real x(1),y(1)
common/bgrp/am(200)
for(i=1; i<=nmax; i=i+1){
	call zquxyz(ix,iy,indic)
	if (indic<0) break
	x(i) = (float(ix)-am(36))/am(37)
	y(i) = (float(iy)-am(38))/am(39)
	}
n = i-1
call zflshz
return
end

SUPPORT(bhookz,		general hook)
subroutine bhookz(type, x, n, y, m)
integer type, n, m
real x(n), y(m)
m = 0
return
end

SUPPORT(blengz,		determine string length in inches)
subroutine blengz(text,inches)
CHARACTER(text,*); real inches
INCLUDE(graphics)
QUERY( cin(cx) )
inches = cx*islenz(text)
return
end

SUPPORT(blinsz,		process lines)
subroutine blinsz(x1,y1,n)
real x1(n),y1(n)
common/bgrp/am(200)
real rx(2),ry(2),rrx(2),rry(2)
if(n<2){
	call zflshz
	call zerrpz("zlinsz",TSTRING(Needs at least 2 points))
	return
	}
rx(2) = x1(1)*am(37)+am(36)
ry(2) = y1(1)*am(39)+am(38)
do i = 2,n {
	rx(1) = rx(2)
	ry(1) = ry(2)
	rx(2) = x1(i)*am(37)+am(36)
	ry(2) = y1(i)*am(39)+am(38)
	call lclipz(rx,ry,am(32),am(34),rrx,rry,jint)
	if (i<=2&&jint==0) {
		irx = rrx(1)+.5
		iry = rry(1)+.5
		call zseekz(irx,iry)
		}
	if (jint!=0) {
		call zflshz
		call zobdsz(TSTRING(Lines),x1(i),y1(i))
		if (jint<0) next 	# skip if entirely out of bounds
		irx = rrx(1)+.5
		iry = rry(1)+.5
		call zseekz(irx,iry)
		}
	irx = rrx(2)+.5
	iry = rry(2)+.5
	call zlinez(irx,iry)
	}
am(6) = x1(n)
am(7) = y1(n)
call zflshz
return
end

SUPPORT(bpntsz,		process points)
subroutine bpntsz(x1,y1,n)
real x1(n),y1(n)
INCLUDE(graphics)
logical ok,dot
CHARACTER(ich,1)
ok(iarg,jarg1,jarg2) = iarg>=jarg1&&iarg<=jarg2
if (n<1) {
	call zflshz
	call zerrpz("zpntsz",TSTRING(Number of points not positive))
	return
	}
if(am(15)<32) {	#	draw marks if point is non-printing ascii
	call dmarkz(x1,y1,n,ifix(am(15)))
	return
	}
QUERY( pch(ich), lty(olty) )
dot = ich=="."
crot = am(48)
if (dot) {
	dxc = 0; dyc = 0
	rx1 = am(36)
	ry1 = am(38)
	SPECIFY( lty(1) )	#solid line for plotting dots
	}
else {
	dpar = am(20)*am(18)*(.5-am(26))*am(28)
	dperp = am(21)*am(18)*(.5-am(27))*am(29)
	dyc = (dpar*sin(am(48)*DEG2RD)+dperp*cos(am(48)*DEG2RD))/am(29)
	dxc = (dpar*cos(am(48)*DEG2RD)-dperp*sin(am(48)*DEG2RD))/am(28)
	rx1 = am(36)-dxc
	ry1 = am(38)-dyc
	}

ix1 = amax1(am(32)-dxc,am(22))+.5	# clipping limits
ix2 = amin1(am(33)-dxc,am(23))+.5
iy1 = amax1(am(34)-dyc,am(24))+.5
iy2 = amin1(am(35)-dyc,am(25))+.5

do i = 1,n {
	irx = x1(i)*am(37)+rx1+.5
	iry = y1(i)*am(39)+ry1+.5
	if (!ok(irx,ix1,ix2)||!ok(iry,iy1,iy2)) {
		call zflshz
		call zobdsz(TSTRING(Points),x1(i),y1(i))
		}
	else {
		call zseekz(irx,iry)
		if (!dot) call zptchz(ich,crot)
		else call zlinez(irx,iry)
		}
	}
am(6) = x1(n)
am(7) = y1(n)
if(dot) SPECIFY( lty(olty) )
call zflshz
return
end

SUPPORT(bsegsz,		disconnected lines)
subroutine bsegsz(x1,y1,x2,y2,n)
real x1(n),y1(n),x2(n),y2(n)
common/bgrp/am(200)
real rx(2),ry(2),rrx(2),rry(2)
if (n<1) {
	call zflshz
	call zerrpz("zsegsz",TSTRING(Number of points not positive))
	return
	}
do i = 1,n {
	rx(1) = x1(i)*am(37)+am(36)
	ry(1) = y1(i)*am(39)+am(38)
	rx(2) = x2(i)*am(37)+am(36)
	ry(2) = y2(i)*am(39)+am(38)
	call lclipz(rx,ry,am(32),am(34),rrx,rry,jint)
	if (jint!=0) {
		call zflshz
		call zobdsz(TSTRING(Line segments),x1(i),y1(i))
		if (jint<0)
			next 1
		}
# skip if entirely out of bounds
	irx = rrx(1)+.5
	iry = rry(1)+.5
	call zseekz(irx,iry)
	irx = rrx(2)+.5
	iry = rry(2)+.5
	call zlinez(irx,iry)
	}
am(6) = x2(n)
am(7) = y2(n)
call zflshz
return
end

SUPPORT(bpolyz,		device-independent polygon filling)
subroutine bpolyz(x,y,n)
real x(n),y(n); integer n

call zlinsz(x,y,n)
call zsegsz(x(n),y(n),x(1),y(1),1)
return
end

SUPPORT(btextz,		process text)
subroutine btextz(x1,y1,x2,n,pos)
CHARACTER(x2,*)
CHARACTER(ich,1); CHARACTER(jgetch,1)
common/bgrp/am(200)
logical ok,differ
ok(iarg,jarg1,jarg2) = iarg>=jarg1&&iarg<=jarg2
dxc = (.5-am(26))*am(20)	# allow seeks leeway because of characters
dyc = (.5-am(27))*am(21)	#  not addressed at center
ix1 = amax1(am(32)-dxc,am(22))+.5
ix2 = amin1(am(33)-dxc,am(23))+.5
iy1 = amax1(am(34)-dyc,am(24))+.5
iy2 = amin1(am(35)-dyc,am(25))+.5
if (n<1) {
	call zflshz
	call zerrpz("ztextz",TSTRING(Number of characters not positive))
	return
	}
call zcposz(dx,dy,dc,upix,upiy,differ)
tl = pos*float(n)*dc-.5*dc
xs = x1-tl*upix
ys = y1-tl*upiy
am(86) = xs+float(n)*dx-.5*dx
am(87) = ys+float(n)*dy-.5*dy
dpar = am(20)*am(18)*(.5-am(26))*am(28)
dperp = am(21)*am(18)*(.5-am(27))*am(29)
dyc = (dpar*sin(am(48)*DEG2RD)+dperp*cos(am(48)*DEG2RD))/am(29)
dxc = (dpar*cos(am(48)*DEG2RD)-dperp*sin(am(48)*DEG2RD))/am(28)
rx = xs*am(37)+am(36)-dxc
ry = ys*am(39)+am(38)-dyc
crot = am(48)
dx = dx*am(37)	# get inter-center differences, convert to rasters
dy = dy*am(39)
if (abs(float(n)*dx)<1.0&&am(31)<=0.0) {	# vertical string, no device character rotation
	dy = -sign(am(21)*am(18),upiy)
	tl = (1.-pos)*float(n)*am(75)-.5*am(75)
	ys = y1+tl*upiy
	ry = ys*am(39)+am(38)-am(21)*(.5-am(27))*am(18)
	}
irx = rx+.5
iry = ry+.5
ierr = 0
do i = 1,n
	if (ok(irx,ix1,ix2)&&ok(iry,iy1,iy2)) {
		call zseekz(irx,iry)	# seek position
		ich = jgetch(x2,i)
		call zptchz(ich,crot)
		if (i==n) break
		irx = rx+float(i)*dx+.5
		iry = ry+float(i)*dy+.5
		}
	else if (ierr==0) {	# dont print repetitive error messages
		call zflshz
		call ztobdz(x2,n,xs+float(i-1)*am(67),ys+float(i-1)*am(68))
		ierr = i
		}
call zflshz
return
end
