#include <stdio.h>
#include <ctype.h>
#include "S.h"
#include "y.tab.h"
#include "options.h"
#include "eval.h"

vector *S_deparse(), *deparse(), *S_sh_dp();
char *sgets(), *short_dp(), *do_unlex();
int op_action();
void names_unlex();
long unlex_len();

static void do_deparse(), dolist(), clean_float(), dp_out(), infix_deparse();
static int need_parens(), is_reserve();
static char *name_unlex();

static FILE *f;
static vector *dep_check;
static int which, dp_level, level, line_pos; static char buffer[80];
static int page_width, line_limit, file_open = FALSE, paren_level;
static char Deparsfile[] = "/tmp/SdprsXXXXXX", cprev = '\n';
static char *break_funs[] = {"switch", ".C", ".Fortran", NULL}; /* should
	be settable as an option eventually */

#define TAB_LENGTH 8
/* constants for op_action */
#define REPLACE_CASE 2
#define EXTRACT_CASE 3
#define LPAR_CASE 4
#define SUBSET_CASE 6
#define LIST_REP_CASE 7
#define REPLACE1_CASE 8
/* following cases are ordered in increasing precedence */
/* should be consistent with yacc ordering in lang.y */
#define LARROW_CASE 9
#define DBLEARROW_CASE 10
#define ANDOR_CASE 12
#define NOT_CASE 13
#define LOGOP_CASE 14
#define ADDOP_CASE 15
#define TIMES_CASE 16
#define DIVIDE_CASE 17
#define SPOP_CASE 18
#define COLON_CASE 19
#define UMINUS_CASE 20
#define UARROW_CASE 21
#define DOLLAR_CASE 22

vector *
S_deparse(ent, arglist)
vector *ent, *arglist;
{
	vector *x;
	int Short; char *file; FILE *f;
	vector **args;
	which = sys_index;
	args = arglist->value.tree;
	x = args[0];
	if(which>0) { /* dput */
		file = string_value(args[1]);
		if(file && *file) {
			f = fopen(file,"w");
			if(!f) PROBLEM "Can't open file \"%s\" for writing",
				file RECOVER(ent);
		}
		else f = stdout;
		Short = FALSE;
	} else { /* deparse */
		file=NULL; f = NULL;
		Short = logical_value(args[1],ent);
	}
	ent = Short?S_sh_dp(x):deparse(x,f);
	if(file && *file)fclose(f);
	if(which>0)ent->status |= NO_PRINT_BIT;
	return(ent);
}

vector *
deparse(ent,file)
vector *ent; FILE *file;
{
	if(file == NULL){
		if(!file_open){mktemp(Deparsfile);file_open=TRUE;}
		f = fopen(Deparsfile,"w+");
		fseek(f,0L,0);
		}
	else f = file;
	if(f==stdout || f== stderr) {
		int page_length;
		window_size(&page_width, &page_length);
	} else page_width = S_p_width;
	line_limit = page_width - TAB_LENGTH;
	if(!atomic_type(ent->mode)&& ent->length>0) dep_check=alcvec(LIST,0L);
	dp_level=level=line_pos=paren_level=0;
	do_deparse(ent,NULL_ENTRY);
	if(line_pos)fputc('\n',f);
	fflush(f);
	if(file == NULL){
		long n, nalloc; char **p; char *s, *sgets();
		fclose(f);
		f = fopen(Deparsfile,"r");
		fseek(f,0L,0);
		nalloc = 32; /*start size */
		p = (char **)S_alloc(nalloc,sizeof(char *)); n = 0;
		while( (s=sgets(f,S_p_width)) != NULL ) {
			if(n==nalloc) p = (char **)S_realloc((char *)p, nalloc *= 2, n, sizeof(char *));
			*(p + n++) = s;
		}
		ent = New_vector(); ent->mode = CHAR; ent->length = n;
		ent->value.Char = p; ent->nalloc = nalloc;
		fclose(f);
		unlink(Deparsfile);
	}
	return(ent);
}

static void 
do_deparse(ent, parent)
vector *ent, *parent;
{
	char *p, *fname;
	int list, mode, newline;
	vector **children, **pp, *child; long n;
	float *fval; long *lval; double *dval; char **cval; complex *cxval;
if(check) {
	sanity(ent,"deparse vector");
	n = ent->length; mode = ent->mode;
	if(min_length(mode)>n)
		PROBLEM "Invalid object to deparse -- length too short for mode \"%s\"", token_name(mode) RECOVER(NULL_ENTRY);
	if(!atomic_type(mode)&&n>0) { /* check for loops */
		rec_check(dep_check,ent,REC_ADD);
		pp = ent->value.tree;
		while(n--){
			child = *pp++;
			if((rec_check(dep_check,child,REC_CHECK))!=NULL_ENTRY) {
				dp_out(short_dp(child, (int)S_p_width));
				dp_out("... \n");line_pos=0;
				 PROBLEM "System error: recursive loop in object" RECOVER(NULL_ENTRY);
			}
		}
		rec_check(dep_check,ent,REC_DELETE);
	}
}
	n = ent->length; mode = ent->mode;
	if(level++ && ent->name && *(ent->name) && mode!=COMMENT_EXPR)
		{dp_out(name_unlex(ent->name));dp_out(" = ");}
	list = n>1 ;
	switch(mode) {
	case MISSING: dp_out(""); break;
	case NEXT: dp_out("next"); break;
	case BREAK: dp_out("break"); break;
	case REAL:
		fval = ent->value.Float;
		if(n==0)dp_out("single(0)");
		if(list)dp_out("c(");
		while(n--) {
			if(is_na(fval))dp_out("NA");
			else {
				sprintf(buffer,"%g",*fval);
				clean_float(buffer);
				dp_out(buffer);
			}
			fval++;
			if(n)dp_out(",");
		}
		if(list)dp_out(")");
		break;
	case INT:
		lval = ent->value.Long;
		if(n==0)dp_out("integer(0)");
		if(list)dp_out("c(");
		while(n--) {
			if(is_na(lval))dp_out("NA");
			else {
				sprintf(buffer,"%ld",*lval);
				dp_out(buffer);
			}
			lval++;
			if(n)dp_out(",");
		}
		if(list)dp_out(")");
		break;
	case LGL: 
		lval = ent->value.Long;
		if(n==0)dp_out("logical(0)");
		if(list)dp_out("c(");
		while(n--) {
			if(is_na(lval))dp_out("NA");
			else dp_out( (*lval) ? "T" : "F");
			lval++;
			if(n)dp_out(",");
		}
		if(list)dp_out(")");
		break;
	case CHAR:
		cval = ent->value.Char;
		if(n==0)dp_out("character(0)");
		if(list)dp_out("c(");
		while(n--) {
			if(is_na(cval))dp_out("NA");
			else dp_out(do_unlex(*(cval)));
			cval++;
			if(n)dp_out(",");
		}
		if(list)dp_out(")");
		break;
	case DOUBLE:
		dval = ent->value.Double;
		if(n==0)dp_out("numeric(0)");
		if(list)dp_out("c(");
		while(n--) {
			if(is_na(dval))strcpy(buffer,"NA");
			else {
				sprintf(buffer,Double_format,*dval);
				clean_float(buffer);
			}
			dp_out(buffer); dval++;
			if(n)dp_out(",");
		}
		if(list)dp_out(")");
		break;
	case COMPLEX:
		cxval = ent->value.Complex;
		if(n==0)dp_out("complex(0)");
		if(list)dp_out("c(");
		while(n--) {
			if(is_na(cxval)) strcpy(buffer,"NA");
			else if(cxval->re==0.){	/* omit real part */
				sprintf(buffer,Double_format,cxval->im);
				strcat(buffer, "i");
			}
			else if(cxval->im>=0.)
				sprintf(buffer,Complex_format,cxval->re,'+',cxval->im);
			else
				sprintf(buffer,Complex_format,cxval->re,'-',-cxval->im);
			dp_out(buffer); cxval++;
			if(n)dp_out(",");
		}
		if(list)dp_out(")");
		break;
	case NULL: dp_out("NULL"); break;
	case NAME: dp_out(ent->value.name); break;
	case QUESTION: dp_out("\"?\""); break;
	case ARGUMENT: /* should only occur in the evaluation stack */
		fname = ".Argument"; goto recursive;
	case LVALUE:
		fname = ".Destination"; goto recursive;
	case STRUCTURE: fname = "structure"; goto recursive;
	case LIST: fname = "list"; goto recursive;
	case PARSE: fname = "expression"; goto recursive;
	case INTERNAL:
	case S_FUN_CALL:
		dp_out(mode == INTERNAL ? ".Internal(" : ".S(");
		children = ent->value.tree;
		do_deparse(children[0],ent); dp_out(",");
		if( (fname=children[1]->name) && *fname) {
			dp_out("\"");dp_out(fname);dp_out("\"");
		}
		else do_deparse(children[1],ent);
		for(n = 2; n<ent->length; n++){
			dp_out(",");do_deparse(children[n],ent);
		}
		dp_out(")");
		break;
	case S_DATA: dp_out(".Sdata(");
		do_deparse(S_to_QPE(*(ent->value.Long),0L),ent);
		dp_out(")");
		break;
	case COMPILED: if(which==2){ /* print.compiled: put out as compiled */
		fname = "compiled"; goto recursive;}
		/* else do as function */
		do_deparse(*(ent->value.tree+1),ent);
		break;
	case FRAME: if(which==2){ /* print.compiled: put out as bound */
		fname = ".Frame"; goto recursive;}
		/* else do as function */
		do_deparse(*(ent->value.tree+2),ent);
		break;
	recursive:
		dp_out(fname); dp_out("(");
		children = ent->value.tree;
		while(n--){
			do_deparse(*children++,ent);
			if(n)dp_out(",");
		}
		dp_out(")");
		break;
	case FLEX_CALL: /* call with "..." */
		do_deparse(*(ent->value.tree),ent);
		break;
	case LBRACK:
	case DOLLAR:
	case DOUBLE_LBRACK:
	case FUN_CALL: {
		vector *ent2; int operator, funny, needpar;
		children = ent->value.tree; ent2 = *children;
		if(ent2->mode == NAME) {
			fname = ent2->value.name;
			funny = !ISALPHA(*(fname)) || *fname == '.';
		} else {
			fname = NULL_STRING; funny = FALSE;
		}
		if(funny && (operator = op_action(fname))) {
			/* this case asserted to be from parsing an operator in
			 * the grammar; else either 1st char is alpha or the
			 * mode is CHAR */
			switch(operator) { /* special cases */
			case LARROW_CASE:
			case DBLEARROW_CASE:
				if(children[0]->mode == NAME)
					dp_out(name_unlex(children[0]->value.name));
				else
					do_deparse(children[0],ent);
				dp_out(operator == LARROW_CASE?" <- ":" <<- ");
				do_deparse(children[1],ent);
				break;
			case SUBSET_CASE:
				do_deparse(*(children+1),ent);
				dp_out("[");
				dolist(children+2,n-2,",",ent);
				dp_out("]");
				break;
			case DOLLAR_CASE:
				do_deparse(*(children+1),ent);
				dp_out("$");
				child = children[2];
				if(child->mode==CHAR)
					dp_out(name_unlex(child->value.Char[0]));
				else do_deparse(child,ent);
				break;
			case EXTRACT_CASE:
				do_deparse(*(children+1),ent);
				dp_out("[[");
				dolist(children+2,n-2,",",ent);
				dp_out("]]");
				break;
			case REPLACE_CASE: /* [<- */
				do_deparse(*(children+1),ent);
				dp_out("[");
				dolist(children+2,n-3,",",ent);
				dp_out("] ");dp_out(fname+1);dp_out(" ");
				do_deparse(*(children+n-1),ent);
				break;
			case REPLACE1_CASE: /* [[<- */
				do_deparse(*(children+1),ent);
				dp_out("[[");
				dolist(children+2,n-3,",",ent);
				dp_out("]]"); dp_out(fname+2);
				do_deparse(*(children+n-1),ent);
				break;
			case LPAR_CASE:
				dp_out("("); children++; n--;
				while(n-- > 0){
					do_deparse(*children++,ent);
					if(n)dp_out(",");
				}
				dp_out(")");
				break;
			case UMINUS_CASE:
				if(fname[0]=='.')fname = "-"; /* and continue */
			default:
				needpar = need_parens(operator,ent,parent);
				if(needpar)dp_out("(");
				switch((int)n) {
				case 3: /* infix */
					infix_deparse(fname,children[1],children[2],ent);
					break;
				case 2: /* unary */
					dp_out(fname);
					do_deparse(*(children+1),ent);
					break;
				default: /* treat as function call */
					dp_out(name_unlex(fname));
					dp_out("("); n--;
					while(n-- > 0){
						do_deparse(*(++children),ent);
						if(n)dp_out(",");
					}
					dp_out(")");
				}
				if(needpar)dp_out(")");
			}
		} else {
			char *sep = ",", **p;
			if(fname) {
				p = break_funs; /* functions whose args are separated
				/* by new lines for clarity */
				while(*p) if(name_eq(*p++, fname))
					{sep=",\n"; break;}
				dp_out(name_unlex(fname));
			}
			else do_deparse(ent2,ent);
			dp_out("("); n--; if(*(sep+1))dp_level++; /*",\n"*/
			while(n-- > 0){
				do_deparse(*(++children),ent);
				if(n)dp_out(sep);
			}
			dp_out(")"); if(*(sep+1))dp_level--; /*",\n"*/
		}
		}
		break;
	case REPEAT:
		dp_out("repeat ");
		child = ent->value.tree[0];
		if(child->mode != LBRACE)dp_level++;
		do_deparse(child,ent);
		if(child->mode != LBRACE)dp_level--;
		break;
	case WHILE:
		dp_out("while(");
		do_deparse(Child1(ent),ent);
		dp_out(") ");
		child = Child2(ent);
		if(child->mode != LBRACE)dp_level++;
		do_deparse(child,ent);
		if(child->mode != LBRACE)dp_level--;
		break;
	case FOR:
		dp_out("for(");
		dp_out(Child1(ent)->name);
		dp_out(" in ");
		do_deparse(Child2(ent),ent);
		child = Child3(ent);
		if(child->mode != LBRACE) dp_out(")\n");
		else dp_out(") ");
		if(child->mode != LBRACE)dp_level++;
		do_deparse(child,ent);
		if(child->mode != LBRACE)dp_level--;
		break;
	case IF:
		dp_out("if(");
		do_deparse(Child1(ent),ent);
		child = Child2(ent);
		newline = parent &&
		 (parent->mode == LBRACE || (parent->mode == IF && dp_level));
		dp_out(newline && child->mode != LBRACE ? ")\n" : ") ");
		if(child->mode != LBRACE)dp_level++;
		do_deparse(child,ent);
		if(child->mode != LBRACE)dp_level--;
		if(ent->length == 3){
			int indent;
			dp_out(newline && child->mode != LBRACE ?"\nelse ":" else ");
			child = Child3(ent);
			indent = child->mode != LBRACE && child->mode != IF;
			if(indent)dp_level++;
			paren_level++;
			do_deparse(child,ent); /* paren_leve >0
				allows a new line after brace */
			paren_level--;
			if(indent)dp_level--;
		}
		break;
	case ELSE: /* should only be in error messages */
		dp_out("else ");
		do_deparse(Child1(ent),ent);
		break;
	case RETURN:
		dp_out("return(");
		children = ent->value.tree;
		while(n--) {
			child = *children++;
			if(child->mode==NAME &&
			  name_eq(child->name,child->value.name))
				dp_out(child->name);/*undo do_return() */
			else do_deparse(child,ent);
			if(n)dp_out(",");
		}
		dp_out(")");
		break;
	case LARROW:
	case DBLEARROW:
		child = Child1(ent);
		if(child->mode == NAME)
			dp_out(name_unlex(child->value.name));
		else
			do_deparse(Child1(ent),ent);
		if(mode==LARROW)
			dp_out("<-");
		else
			dp_out("<<-");
		do_deparse(Child2(ent),ent);
		break;
	case LBRACE:
		dp_out("{\n"); dp_level++;
		dolist(ent->value.tree,n,"\n",ent);
		dp_level--; dp_out(line_pos?"\n}":"}");
		if(paren_level || (parent &&
		   (parent->mode!=IF || parent->length<3)))
			dp_out("\n"); /* this exempts the case of an
				if{..}else at outer level */
		break;
	case LPAR: /* a list, case n>1 usually done as "(" function */
		children = Args(ent); n = Nargs(ent);
		dp_out("(");
		while(n-- > 0){
			do_deparse(*children++,ent);
			if(n)dp_out(",");
		}
		dp_out(")");
		break;
	case COMMENT:
		{
		vector *p = *ent->value.tree; long nlines = p->length,i;
		char **l;
if(check){
		sanity(p,"Text pointer in comment");
		if(p->mode!=CHAR)PROBLEM "Comment text not mode character" RECOVER(ent);
		if(ent->length!=1)PROBLEM "Comment structure not length 1" RECOVER(ent);
}
		l = p->value.Char; i=dp_level; dp_level=0; /*dont indent comments*/
		if(cprev != '\n')dp_out("\t");
		while(nlines--){
			dp_out(*l++);dp_out("\n");
		}
		dp_level = i;
		break;
		}
	case COMMENT_EXPR:
		n=ent->length; children = ent->value.tree;
		while(n--)
			do_deparse(*children++,ent);
		break;
	case FUN_DEF: 
		{	vector **args, *arg, *body; unsigned n;
			n = ent->length - 1; body = *(ent->value.tree+n);
			if(body->mode==COMMENT_EXPR) {
			/* treat comments for function defn specially */
				args = body->value.tree;
				if(body->length==2 && (*args)->mode==COMMENT){
					do_deparse(*args,ent);
					body = *(args+1);
				}
			}
			dp_out("function(");
			args = ent->value.tree;
			while(n--) {
				arg = *args++;
				if(arg->mode != MISSING) {
					do_deparse(arg,ent);
				}
				else dp_out(arg->name);
				if(n)dp_out(",");
			}
			dp_out(")\n");
			do_deparse(body,ent);
		}
		break;
	case QUIT:
		dp_out("q()\n");
		break;
	default: fname = token_name(ent->mode);
		if(ent->length > 0)goto recursive;
		dp_out("vector("); dp_out(do_unlex(fname)); dp_out(",0)");
		break;
	}
	fflush(f);level--;
}

static void 
dolist(children,n,sep,parent)
vector **children, *parent; long n; char *sep;
{
	while(n--){
		do_deparse(*children++,parent);
		if(n) dp_out(sep);
	}
}

/* get rid of uneeded 0s */
static void 
clean_float(buffer)
char *buffer;
{
	register char c,*p = buffer; int n = 0, isdot = FALSE;
	while((c = *p++) ) {
		if(c=='.' )isdot = TRUE;
		if(c=='e' )break;
	}
	if(!isdot) return;
	p = p-2;
	while(*p-- == '0') n++;
	if(!n)return;
	p = p + 2 +n;
	do { c = *(p-n) = *p; p++;}while(c);
}
	
 
#define INDENT(l) {level=(l);while(level--)putc('\t',f); line_pos=(l)*TAB_LENGTH;}
static void 
dp_out(string)
char *string;
{
	char c,c0 = *string; int level, break_before, break_after, whitespace;
	whitespace = 0; break_after = FALSE; break_before = TRUE;
	switch(c0) { /* check special char's for break, white space */
	case '<': case '*': case '>': case '&': case '|': case '%': case '~':
		whitespace = 1; break_before = FALSE;
		break_after = line_pos > line_limit; break;
	case '-': case '+':
		whitespace = string[1]=='\0'; break_before = !whitespace;
		break_after = line_pos > line_limit; break;
	case '=': 
		whitespace = string[1]==c0; break_before = FALSE;
		break_after = line_pos > line_limit; break;
	case '(': case '[': case ',': case ':': case '/': 
		break_before = FALSE;
		break_after = line_pos > line_limit; break;
	case '"': case '\'': case '#': /* string or comment */
		c0 = '"'; break;
	}
	 /* break before if necessary */
	if(break_before && line_pos + strlen(string) + 2*whitespace >= page_width){
		putc('\n',f); INDENT(dp_level+1); cprev = '\n';
	}
	if(whitespace){putc(' ',f);line_pos++;}
	while( c = *string++){
		if(c0 != '"') switch(c) {
		 /* paren_level, used for top-level if(...) */
		case '(': case '{': case '[': paren_level++; break;
		case ')': case '}': case ']': paren_level--;
		}
		cprev = c;
		if(!line_pos ) if(!isspace(c)) INDENT(dp_level)
			else continue; /* don't print empty lines */
		putc(c,f);
		if( c == '\n')line_pos=0;
		else line_pos++;
	}
	if(break_after){putc('\n',f); INDENT(dp_level+1); cprev='\n';}	
	else if(whitespace || cprev == ','){putc(' ',f);line_pos++;}
}

#define STRING_LEN 32

char *
sgets(f,width)
FILE *f; long width;
{
	register c; long n, ncur;
	char *s; register char *cs;
	ncur = n = width ? width : STRING_LEN;
	s = S_alloc(n+1,sizeof(char)); *s = '\n'; cs = s + 1;
	while ((c = getc(f))>0) {
		if( !(--n)) {
			n = ncur; ncur *= 2;
			s = S_realloc(s, ncur, n, sizeof(char));
			cs = s + n;
		}
		*cs++ = c;
		if (c=='\n'){ *(--cs) = '\0'; break;}
	}
	if(c>0) {}
	else if(cs>s+1) {
		PROBLEM "End of file in reading line" WARNING(NULL_ENTRY);
		*cs = '\0';
	}
	else return(NULL);
	return(s+1);
}

#define isarrow(f) (c=(f),*c=='<' && ((*(c+1)=='-' && *(c+2)=='\0' ) ||\
	(*(c+1)=='<' && *(c+2)=='-' && *(c+3)=='\0')))

int 
op_action(op_name)
char *op_name;
{
	int c1, c2, c3; register char *c;
	c1 = *op_name; c2 = *(op_name+1); c3 = *(op_name+2);
	switch(c1) {
	case '+': case '-':
		return( (c2 == '\0')*ADDOP_CASE );
	case ':':
		return( (c2 == '\0')*COLON_CASE );
	case '/':
		return( (c2 == '\0')*DIVIDE_CASE );
	case '^':
		return( (c2 == '\0')*UARROW_CASE );
	case '[': 
		if(c2=='\0')return(SUBSET_CASE);
		else if(c2=='[' && c3=='\0')return(EXTRACT_CASE);
		else if(isarrow(op_name+1))return(REPLACE_CASE);
		else if(*(op_name+1)=='[' &&
			isarrow(op_name+2))return(REPLACE1_CASE);
		else return(FALSE);
	case '$':
		return((c2 == '\0')*DOLLAR_CASE);
	case '%': 
		return( (*(op_name+strlen(op_name)-1)=='%')*SPOP_CASE );
	case '*':
		switch(c2){
		case '\0':
			return(TIMES_CASE);
		case '*':
			return( (c3 == '\0')*UARROW_CASE );
		default:
			return(FALSE);
		}
	case '=': case  '>': 
		return(( c2 == '\0' || (c2 == '=' && c3 == '\0'))*LOGOP_CASE);
	case '!':
		return( ( c2 == '\0' )?UMINUS_CASE :((c2 == '=' && c3 == '\0')*LOGOP_CASE));
	case '<':
		switch(c2) {
		case '\0':
			return(LOGOP_CASE);
		case '=':
			return((c3 == '\0')*LOGOP_CASE);
		case '-':
			return((c3 == '\0')*LARROW_CASE);
		case '<':
			return((c3=='-' && op_name[3]=='\0')*DBLEARROW_CASE);
		}
	case '~':
		return(c2 == '\0'?LOGOP_CASE:FALSE);
	case '(':
		return(c2 == '\0'?LPAR_CASE:FALSE);
	case '&':
	case '|':
		return(( (c2=='\0')||(c2==c1 && c3 =='\0'))*ANDOR_CASE);
	case ',':
		return(isarrow(op_name+1)?LIST_REP_CASE:FALSE);
	case '.':
		return(name_eq(op_name,".Uminus")?UMINUS_CASE:FALSE);
	}
	return(FALSE);
}

static int 
need_parens(operator,ent,parent)
int operator; vector *ent,*parent;
{
	vector *p, **child; int i, right_assoc;
	if(VOID(parent) || parent->mode != FUN_CALL)return(FALSE);
	if((p = *(parent->value.tree))->mode != NAME)return(TRUE);/*weird*/
	i = op_action(p->value.name);
	if(i == operator){
		child = parent->value.tree;
		right_assoc = operator == UARROW_CASE ||
			operator == LARROW_CASE ||
			operator == DBLEARROW_CASE;
		return((ent==child[1] && right_assoc) ||
			(ent==child[2] && !right_assoc));
	}
	return(i > operator);
}

vector *
S_sh_dp(ent)
vector *ent;
{
	int do_all, n; vector *val, **pp; char **cpp;
	if(ent->length==0 || atomic_type(ent->mode))do_all=FALSE;
	else switch(ent->mode){
	case NAME:
		do_all = FALSE;
		break;
	default:
		do_all = TRUE;
	}
	if(do_all) {
		val = alcvec(CHAR,ent->length);
		cpp = val->value.Char; pp= ent->value.tree; n=ent->length;
		while(n--) *cpp++ = short_dp(*pp++, (int)S_p_width);
	}
	else {
		val = alcvec(CHAR,1L);
		*(val->value.Char) = short_dp(ent, (int)S_p_width);
	}
	return(val);
}

static char fmt_buf[] = "%s .......... %s";

char *
short_dp(ent,length)
vector *ent; int length;
{
	long n; vector *temp;
	char *Short, *fmt, *output, *name;
	int named;
	if(ent==NULL_ENTRY)return("<NULL>");
	output = sanity(ent,NULL_STRING);
	if(output)
		PROBLEM "Invalid  internal object for short_dp: %s",
			output RECOVER(NULL_ENTRY);
	name = ent->name;
	if(named = name!=NULL_STRING && *(name)!='\0') {
		fmt = "%s=%s"; name = name_unlex(name);
	}
	else fmt = "%s";
	switch(ent->mode){
	case LGL:
	case INT:
	case REAL:
	case DOUBLE:
	case COMPLEX:
	case CHAR:
		n=ent->length;
		if(n>1)fmt = named ? "%s=c(%s, ..)" : "c(%s, ..)";
		else fmt = named ? "%s=%s" : "%s";
		if(n==0){
			Short = token_name(ent->mode);
			fmt = named ? "%s=%s(0)" : "%s(0)";
		}
		else if(ent->mode == CHAR) Short = do_unlex(*(ent->value.Char));
		else {
			ent->length = 1;
			temp = enc_data(ent);
			ent->length = n;
			Short = *(temp->value.Char);
		}
		break;
	case LIST:
	case FUN_DEF:
	case STRUCTURE:
	case ARGUMENT:
	case WHILE:
	case FOR:
	case IF:
	case RETURN:
	case FRAME:
		fmt = named ? "%s = %s(..": "%s(..";
		Short = token_name(ent->mode);
		break;
	case NAME:
		Short = name_unlex(ent->value.name);
		break;
	case FUN_CALL: {
		int funny; vector *ent2 = *(ent->value.tree); char *fname;
		if(ent2->mode==NAME) {
			fname = ent2->value.name;
			funny = !ISALPHA(*(fname));
		}
		else {
			fname = "...";
			funny = FALSE;
		}
		if(funny && op_action(fname)){
			Short = fname;
			if(named) {
				fmt = "%s = .. %s ..";
			}
			else {
				fmt = "%s %s ...";
				name = short_dp(Arg1(ent),length/2);
				named = TRUE;
			}
		}
		else {
			fmt = named? "%s= %s( .. )" : "%s( .. )";
			switch(ent2->mode) {
			case NAME: Short=name_unlex(ent2->value.name); break;
			case CHAR: Short= do_unlex(*(ent2->value.Char)); break;
			default: Short = "FUNCTION_CALL";
			}
		  }
		}
		break;
	case LARROW:
		fmt = "%s <- %s";
		name = short_dp(*(ent->value.tree),length/2);
		Short = short_dp(*(ent->value.tree+1),length/2);
		named = TRUE;
		break;
	case LPAR:
		if(ent->length>2)fmt = named ? "%s = ( %s,... ) " :" ( %s,... )";
		else fmt = named ? "%s = ( %s ) " :" ( %s )";
		Short = (ent->length>1) ? short_dp(Arg1(ent),length/2) : "";
		break;
	case LBRACK:
	case DOUBLE_LBRACK:
		Short = token_name(ent->mode); fmt = S_alloc(40L,1);
		sprintf(fmt,"%%s %s %%s ...",Short);
		name = short_dp(Arg1(ent),length/2);
		Short = short_dp(Arg2(ent),length/2);
		named = TRUE;
		break;
	case S_FUN_CALL:		
		fmt = named ? "%s = .S( %s,... ) " :" .S( %s,... )";
		Short = (*(ent->value.tree))->name;
		break;
	case INTERNAL:
		fmt = named ? "%s = .Internal( %s,... ) " :" .Internal( %s,... )";
		Short = short_dp(*(ent->value.tree),length/2);
		break;
	case COMPILED:
		fmt = named ? "%s = %s( ... ) #compiled" :" %s( ... ) #compiled";
		temp = *(ent->value.tree); /* the frame; its 1st el. has fun.name */
if(check){
		if(!temp || temp->mode!=LIST) {
			PROBLEM "Invalid compiled expression" RECOVER(ent);
			return("");
		}
}
		Short = (*(temp->value.tree))->name;
		if(!Short)Short = "<unknown>";
		break;
	case FLEX_CALL:
		fmt = named ? "%s = %s" : "%s";
		Short = short_dp(ent->value.tree[0],length - (named ? ( strlen(name)+3):0));
		break;
	default:
		fmt = named ? "%s = # %s" : "# %s";
		Short = token_name(ent->mode);
	}
	if(named) output = encs2(fmt,name,Short);
	else output = encs1(fmt,Short);
	if(length>0 && strlen(output)>length) *(output+length-1) = '\0';
	return(output);
}

char *
do_unlex(s)
char *s;
{
	char *outstr; char *op; int c; long len;
	len = unlex_len(s)+3;
	op = outstr = S_alloc(len, sizeof(char));
	*op++ = '"';
	/* process per char */
	while(c = (*s++ & 0177))
		switch(c) {
		case '"':
		case '\\':
			*op++ = '\\'; *op++ = c; break;
		case '\n':
			*op++ = '\\'; *op++ = 'n'; break;
		case '\r':
			*op++ = '\\'; *op++ = 'r'; break;
		case '\t':
			*op++ = '\\'; *op++ = 't'; break;
		case '\b':
			*op++ = '\\'; *op++ = 'b'; break;
		default:  if(c < 040) {
			*op++ = '\\';
			*op++ = '0';
			*op++ = '0' + c/8;
			*op++ = '0' + c%8;
			} else *op++ = c;
		}
	*op++ = '"';
	*op = '\0';
	return(outstr);
}

long 
unlex_len(s)
char *s;
{
	long len; char c;
	len=0;
	while(c= (*s++ & 0177)){
		if(c<040) len += 4;
		else switch(c) {
			case '"':
			case '\\':
				len += 2; break;
			default:  len++;
		}
	}
	return(len);
}

static char *
name_unlex(s)
char *s;
{
	char *p=s; register long n = 1;
	if(ISALPHA(*p)) {
		if(is_reserve(s))return(do_unlex(s));
		while(*p){
			if(!(ISALPHA(*p)||isdigit(*p))) return(do_unlex(s));
			p++; n++;
		}
		p = S_alloc(n,sizeof(char)); strcpy(p,s);
		return(p);
	}
	else return(do_unlex(s));
}

void 
names_unlex(names,nn)
char **names; long *nn;
{
	long n = *nn;
	while(n--) { *names = name_unlex(*names); names++; }
}

static int 
is_reserve(s)
char *s;
{
	char c = *s;
	switch(c) {
	case 'f':
		switch(s[1]) {
		case 'o': return(name_eq(s,"for"));
		case 'u': return(name_eq(s,"function"));
		default: return(0);
		}
	case 'w': return(name_eq(s,"while"));
	case 'r': return(name_eq(s,"return")||name_eq(s,"repeat"));
	case 'i': return(name_eq(s,"if")||name_eq(s,"in"));
	case 'b': return(name_eq(s,"break"));
	case 'n': return(name_eq(s,"next"));
	default: return(0);
	}
}

static void
infix_deparse(fname, left, right,parent)
char *fname; vector *left, *right, *parent;
{
	if(data_mode(left)==COMPLEX && data_length(left)==1) {
		dp_out("("); do_deparse(left,parent); dp_out(")");
	}
	else do_deparse(left,parent);
	dp_out(fname);
	if(data_mode(right)==COMPLEX && data_length(right)==1) {
		dp_out("("); do_deparse(right,parent); dp_out(")");
	}
	else do_deparse(right,parent);
	if(name_eq(fname,"["))
		dp_out("]");
}


#include <math.h>

static FILE *file; static char *makestring();
static int flag=0; static void dput_to_file(), put_string();
vector *dget_from_file(); static long n_record;
static char *get_line(), *obj_name;
static long D_level; static int print;
static void D_LREAD(), D_FREAD(), D_DREAD(), D_CREAD();
static void D_LWRITE(), D_FWRITE(), D_DWRITE(), D_CWRITE();

#define SMALL_STRING 16

S_dump(path_arg, names, n_arg)
char **path_arg, **names;  
long *n_arg;
{
	vector *ent; char *path = *path_arg, *name; long n = *n_arg;
	int i_o_error();
	file = fopen(path,"w");
	n_record = 0L;
	if(file == NULL)
		PROBLEM "Cannot create the file \"%s\"", path
		RECOVER(NULL_ENTRY);
	add_error(i_o_error);
	for(; n>0; n--, names++) {
		name = *names;
		ent = get_data(name,ANY);
		if(!ent)
			PROBLEM "Couldn't find \"%s\" to dump", name
			WARNING(NULL_ENTRY);
		else {D_level = 0; put_string(name); dput_to_file(ent);};
	}
	del_error(i_o_error);
	fclose(file);
}

S_restore(path_arg,print_a)
char **path_arg; long *print_a;
{
	vector *ent; char *path = *path_arg, *name, prev; 
	int i_o_error();
	file = fopen(path,"r");
	n_record = 0L;
	if(file == NULL)
		PROBLEM "Cannot open the file \"%s\"", path RECOVER(NULL);
	add_error(i_o_error); flag = 0;
	print = *print_a;
	prev = set_alloc(1L); D_level=0;
	while(name = makestring(1)) {
		obj_name = name;
		ent = dget_from_file();
		assign_obj(name,ent,NULL,1);
		if(D_level!=0)
			PROBLEM "mismatched levels in restoring object \"%s\"", name RECOVER(NULL_ENTRY);
	}
	set_alloc(prev);
	del_error(i_o_error);
	fclose(file);
}

static vector *
dget_from_file()
{
	vector *ent; long mode; char *name, *mode_name; long n;
	if(D_level>0)name = makestring(0);
	mode_name = makestring(0); mode = mode_lookup(mode_name);
	if(mode == UNKNOWN) error("read","invalid mode for",mode_name);
	D_LREAD(&n);
	ent = alcvec(mode,
	  (atomic_type(mode) || !NOT_RECURSIVE(mode)) ?n : 0L);
	ent->length = n; /* this kludge only needed for mode NAME */
	if(D_level>0)ent->name = name;
	if(print && !D_level) {
		fprintf(stderr,"\"%s\": %ld values of mode \"%s\"\n",obj_name
			,n,mode_name); fflush(stderr); 
	}
	D_level++;
	dget_vals(ent);
	D_level--;
	return(ent);
}

static void
dput_to_file(ent)
vector *ent;
{
	char *name, *token_name();
	name = ent->name?ent->name:"";
	if(D_level>0)put_string(name);
	D_level++;
	put_string(token_name(ent->mode));
	D_LWRITE(&(ent->length));
	dput_vals(ent);
	D_level--;
}

dget_vals(ent)
vector *ent;
{
	long  i; char **chptr; vector **children;
	switch(ent->mode) {
	case LGL:
	case INT:
		for(i=0; i<ent->length; i++)
			D_LREAD((ent->value.Long+i));
		break;
	case REAL: 
		for(i=0; i<ent->length; i++)
			D_FREAD((ent->value.Float+i));
		break;
	case DOUBLE: 
		for(i=0; i<ent->length; i++)
			D_DREAD((ent->value.Double+i));
		break;
	case COMPLEX: 
		for(i=0; i<ent->length; i++)
			D_CREAD((ent->value.Complex+i));
		break;
	case CHAR: 
		i=ent->length; chptr = ent->value.Char;
		while(i--)
			*chptr++ = makestring(0);
		break;
	case NAME: 
		ent->value.name= makestring(0);
		break;
	default: 
		if(!(i=ent->length) || NOT_RECURSIVE(ent->mode))break;
		children = ent->value.tree;
		while(i--) *children++ = dget_from_file();
	}
}

dput_vals(ent)
vector *ent;
{
	long *modes, *lengths, *ll, i, stringlen, mode, last_pos, value_pos;
	vector **children, *rec_check(), *Temp; char **chptr;
	char *name, *enci1();
	switch(ent->mode) {
	case LGL:
	case INT:
		for(i=0; i<ent->length; i++)
			D_LWRITE((ent->value.Long+i));
		break;
	case REAL: 
		for(i=0; i<ent->length; i++)
			D_FWRITE((ent->value.Float+i));
		break;
	case DOUBLE: 
		for(i=0; i<ent->length; i++)
			D_DWRITE((ent->value.Double+i));
		break;
	case COMPLEX: 
		for(i=0; i<ent->length; i++)
			D_CWRITE((ent->value.Complex+i));
		break;
	case CHAR: 
		i=ent->length; chptr = ent->value.Char;
		while(i--){
			put_string(*chptr++);
		}
		break;
	case NAME: 
		put_string(ent->value.name);
		break;
	default: 
		if(!(i=ent->length) || NOT_RECURSIVE(ent->mode))break;
		children = ent->value.tree;
		while(i--) dput_to_file(*children++);
	}
}

static i_o_error()
{
	fclose(file);
}

/*makestring -- read a string token */
static char * 
makestring(eof_ok)
int eof_ok;
{
	int c,quote, prompt; long limit,current; char *value;

	limit=SMALL_STRING; current = 0;
	value = S_alloc((long)SMALL_STRING, sizeof(char) );
	while((c=getc(file)) && c != '\n' ) {
		if(c == EOF) 
			if(eof_ok)return(NULL);
			else error("read","character","end of file");
		if(c == '\\')  { /* escaped characters */
			if((c=getc(file)) == 0) break;
			if(isdigit(c)) {
				int i, cc;
				cc  = getc(file); /* 2nd digit */
				if(isdigit(cc)) c = 8*c +cc;
				else error("read","character","Invalid octal constant");
			}
			else switch(c) {
			case 'n': c='\n'; break;
			case 't': c='\t'; break;
			case 'b': c='\b'; break;
			case 'r': c='\r'; break;
			}
		}
		*(value + current++) = c;
		if(current >= limit) {
			value = S_realloc(value, limit * 2,limit ,sizeof(char));
			limit *= 2;
		}
	}
	*(value + current) = '\0';
	return(value);
}

static void
put_string(s)
char *s;
{
	int c; long len;
	/* process per char */
	while(c = (*s++ & 0177))
		switch(c) {
		case '"':
		case '\\':
			putc('\\',file); putc(c,file); break;
		case '\n':
			putc('\\',file); putc('n',file); break;
		case '\r':
			putc('\\',file); putc('r',file); break;
		case '\t':
			putc('\\',file); putc('t',file); break;
		case '\b':
			putc('\\',file); putc('b',file); break;
		default:  if(c < 040) {
			putc('\\',file);
			putc('0',file);
			putc('0' + c/8,file);
			putc('0' + c%8,file);
			} else putc(c,file);
		}
	putc('\n',file);
}

static void
D_LWRITE(x)
long *x;
{
	if(is_na(x))fputs("N\n",file);
	else fprintf(file,"%ld\n",*x);
}

static void
D_FWRITE(x)
float *x;
{
	if(is_na(x))fputs("N\n",file);
	else {fprintf(file,Single_format,*x); putc('\n',file);}
}

static void
D_DWRITE(x)
double *x;
{
	if(is_na(x))fputs("N\n",file);
	else {fprintf(file,Double_format,*x); putc('\n',file);}
}

static void
D_CWRITE(x)
complex *x;
{
	if(is_na(x))fputs("N\n",file);
	else {fprintf(file,Complex_format,x->re,x->im<0?'-':'+',fabs(x->im)); putc('\n',file);}
}

static char *buf; long line_len = 0L;
#define INIT_LEN 80
static char *
get_line()
{
	int i;
	char c = '\0' ;
	int nread = 0 ;
	n_record++;
	while ((i=getc(file))!=EOF && (c=(char)i)!='\n') {
		if (nread >= line_len) {
			if(line_len==0) {
				line_len = INIT_LEN;
				buf = S_calloc(line_len+1,1);
			}
			else {
			buf = S_realloc(buf, line_len*2+1, line_len+1, sizeof(char)) ;
			line_len *= 2 ;
			}
		}
		buf[nread++] = c ;
	}
	buf[nread] = '\0' ;
	/* nread will be one more than number read */
	/* nread will be 1 if nothing was read before EOF */
	/* nread>1 and i=EOF if last line contained data but no \n */
	/* This should mimic fgets's return value */
	return((nread==1 && c!= '\n')?NULL:buf) ;
}

static void
D_LREAD(x)
long *x;
{
	buf = get_line();
	if(buf[0]=='N' && !buf[1])na_set(x);
	else {
		flag = sscanf(buf,"%ld", x);
		if(!flag)error("read","integer", "bad field");
		else if(flag == EOF)error("read","integer", "end of file");
	}
}

static void
D_FREAD(x)
float *x;
{
	buf = get_line();
	if(buf[0]=='N' && !buf[1])na_set(x);
	else {
		flag = sscanf(buf,"%f", x);
		if(!flag)error("read","single", "bad field");
		else if(flag == EOF)error("read","single", "end of file");
	}
}

static void
D_DREAD(x)
double *x;
{
	buf = get_line();
	if(buf[0]=='N' && !buf[1])na_set(x);
	else {
		flag = sscanf(buf,"%lf", x);
		if(!flag)error("read","double", "bad field");
		else if(flag == EOF)error("read","double", "end of file");
	}
}

static void
D_CREAD(x)
complex *x;
{
	buf = get_line();
	if(buf[0]=='N' && !buf[1])na_set(x);
	else {
		flag = sscanf(buf,"%lf %lf", &(x->re), &(x->im));
		if(!flag)error("read","complex", "bad field");
		else if(flag == EOF)error("read","complex", "end of file");
	}
}

static
error(io,type,problem)
char *io, *type, *problem;
{
	PROBLEM "in %sing %s data: %s at line %ld", io, type, problem, n_record
	RECOVER(NULL_ENTRY);
}
