#include <stdio.h>
#include "S.h"

/* set up some easy-to-use system names */
#if defined(sun) && defined(mc68020)
#define sun3 
#endif
#if (defined(sun) && defined(sparc))
#define sun4
#endif
#if defined(sun) && defined(i386)
#define sun386i
#endif
/* I assume IBM RT is running ACIS or AOS (BSD style unix) */
/* I don't know what the symbol is for the op sys (ACIS vs AIX) */
#ifdef ibm032
#define ibmrt_bsd
#endif
/* I also assume vax is running BSD style unix */
#ifdef vax
#define vax_bsd
#endif
/* I don't know the variations possible in irises (ask Fisher) */
#if defined(sgi) && defined(mips)
#define iris4D
#endif
/* hp9000s300 and hp9000s800 are predefined, */
/* i'll just use them and assume hpux.       */


extern vector *dyn_load_ld() ;
static vector *read_code() ;
extern void hash_enter_function() ;
#define round_up(a, d) ( (long)(a)%(d) ? (d)*((long)(a)/(d) + 1) : (long)(a) )

static char ld_tmpfileX[] = "/tmp/Sld.XXXXXX" ;
/* public */ vector*
dyn_load_ld(this_prog, ld_tail, code_size)
char *this_prog ;
char *ld_tail ;
long code_size ;
{
	vector *val ;
	long prev_frame ;
	char *ld_command = (char *)S_alloc((long)(200+strlen(ld_tail)), 1) ;
	char *code_space ;
	char ld_tmpfile[sizeof(ld_tmpfileX)] ;
#define T_ALIGN 4096
	code_size += T_ALIGN ;
	prev_frame = set_alloc(PERM_FRAME) ;
	code_space = (char *)S_alloc(code_size, 1) ;
	(void)set_alloc(prev_frame) ;
	{
		char *t ;
        	t = (char *)round_up(code_space, T_ALIGN) ;
		code_size -= t - code_space ;
		code_space = t ;
	}
	(void)strcpy(ld_tmpfile, ld_tmpfileX) ;
	(void)mktemp(ld_tmpfile) ;
#if defined(hp9000s300) || defined(hp9000s800)
#define LD_TEXT_START_FLAG "-R"
#else
#define LD_TEXT_START_FLAG "-T"
#endif
#if defined(iris4D)
/* on iris 4D, you must compile all programs with -G 0     */
/* and link Sqpe with 'LDFLAGS=-G 0 -T 10000000 -D 12000000' */
/* to get text and data spaces close enough to jump between*/
#define MACHINE_HACK "-G 0"
#else
#define MACHINE_HACK ""
#endif
	(void)sprintf(ld_command, "ld %s -N -A %s %s %x -o %s %s",
		MACHINE_HACK, this_prog,
		LD_TEXT_START_FLAG, code_space,
		ld_tmpfile, ld_tail) ;
#ifdef DEBUG
	(void)printf("dyn_load_ld : will try to execute\n\t%s\n", ld_command) ;
#endif /* DEBUG */
	if (system(ld_command)) {
		perror("ld") ;
		Recover("'ld -A ...' failed", NULL_ENTRY) ;
	}
	val = read_code(code_space, code_size, ld_tmpfile) ;
#ifndef DEBUG
	if (unlink(ld_tmpfile) == -1) {
		perror("unlink") ;
		Warning(encs1("Could not remove temporay file '%s'", ld_tmpfile), NULL_ENTRY) ;
	}
#endif
	return(val) ;
}
/*
 * read_code : read in the code, data, ... sections,
 * zero out the bss section(s).
 * Then add newly added functions to the hash table.
 * There should be an error return, I guess, but I'll just use
 * Recover() to give a message and longjmp away.
 */
#if defined(vax_bsd) || defined(sun3) || defined(sun4) || defined(ibmrt_bsd) || defined(hp9000s300) /* { */
#include <a.out.h>
/* #include <stab.h> */
#ifndef N_DATOFF /* { */
#define N_DATOFF(exec) \
	(N_TXTOFF(exec) + (exec).a_text)
#endif /* } N_DATOFF */
#if defined(hp9000s300) /* { */
#define bzero(buf,n) memset(buf,0,n)
#define N_SYMOFF(header) LESYM_OFFSET(header)
#define N_TXTOFF(header) TEXT_OFFSET(header)
#define internal_nlist nlist_
#else /* } { */
#define internal_nlist nlist
#endif /* } */

static vector *
read_code(code_space, code_size, ld_tmpfile)
char *code_space ;
long code_size ;
char *ld_tmpfile ;
{
	FILE *fileptr ;
	struct exec header ;
#if !defined(hp9000s300)
	int nsyms ;
#endif
	int i ;
	vector *val = alcvec(CHAR, 0L);
	char *vv[1] ;
	long sym_tab_off ;
	struct internal_nlist symbol ;
#ifdef DEBUG
	(void)printf("read_code...\n") ;
#endif /* DEBUG */
	fileptr = fopen(ld_tmpfile, "r") ;
	if (!fileptr) {
		perror("fopen") ;
		Recover("Cannot open temporary file from ld", NULL_ENTRY) ;
	}
        if (fread((char*)&header, sizeof(header), 1, fileptr) < 1) {
		perror("fread") ;
                Recover("could not read a.out header", NULL_ENTRY) ;
        }
#if !defined(hp9000s300)
        nsyms = header.a_syms / sizeof(struct internal_nlist) ;
#ifdef DEBUG
	(void)printf("\tnsyms=%d\n", nsyms) ;
#endif /* DEBUG */
#endif
        if (header.a_text+header.a_data+header.a_bss > code_size) {
                Recover(enci1("Whoops, we didn't ask for enough space (need %ld)\n",
			(long)(header.a_text+header.a_data+header.a_bss)), NULL_ENTRY) ;
        }
        /* seek to start of text area and read it in */
        if (fseek(fileptr, (long)N_TXTOFF(header), 0) == -1) {
		perror("fseek") ;
		Recover("Cannot seek in object file", NULL_ENTRY) ;
	}
        if (fread(code_space, 1, (int)header.a_text, fileptr) < header.a_text) {
		perror("fread") ;
                Recover("could not read entire text segment", NULL_ENTRY) ;
        }
        /* seek to start of data area and read it in */
        if (fseek(fileptr, (long)N_DATOFF(header), 0) == -1) {
		perror("fseek") ;
		Recover("Cannot seek in object file", NULL_ENTRY) ;
	}
        if (fread(code_space+header.a_text, 1, (int)header.a_data, fileptr) < header.a_data) {
                Recover("could not read entire data segment", NULL_ENTRY) ;
        }
        /* zero out bbs (unintialized data space) */
        (void)bzero(code_space+header.a_text+header.a_data, (int)header.a_bss) ;
	/* root around in symbol table looking for new global text symbols */
	/* and adding them to S's function hash table */
#if !defined(hp9000s300) /* { */
	for (i=0, sym_tab_off=0L ; i<nsyms ; i++, sym_tab_off += sizeof(symbol)) {
#else /* } hp9000s300 { */
	for (i=0, sym_tab_off=0L ;
		sym_tab_off < header.a_lesyms ;
		i++, sym_tab_off += sizeof(struct internal_nlist) + symbol.n_length) {
#endif /* } */
		char sym_name[512], *s ;
		int type, global ;
		long sym_val ;
                if (fseek(fileptr, (long)(N_SYMOFF(header)+sym_tab_off), 0) == -1) {
			perror("fseek") ;
			Recover("Cannot seek in object file", NULL_ENTRY) ;
		}
                if (!fread((char *)&symbol, sizeof(symbol), 1, fileptr)) {
                        perror("fread") ;
                        Recover("cannot read symbol table", NULL_ENTRY) ;
                }
		type = symbol.n_type & N_TYPE ;
		global = symbol.n_type & N_EXT ;
		sym_val = symbol.n_value ;
                if (type==N_TEXT && global && sym_val>=(long)code_space) {
#if !defined(hp9000s300) /* { */
                        if (fseek(fileptr, (long)(N_STROFF(header)+symbol.n_un.n_strx), 0) == -1) {
				perror("fseek") ;
				Recover("Cannot seek in object file", NULL_ENTRY) ;
			}
                        s = sym_name ;
                        while (*s++ = getc(fileptr)) ;
#else /* } hp9000s300 { */
			if (symbol.n_length > 0) {
				if(fread(sym_name, 1, symbol.n_length, fileptr)<symbol.n_length) {
					perror("fread(symbol name)") ;
					Recover("Could not read symbol name", NULL_ENTRY) ;
				}
			}
			sym_name[symbol.n_length] = '\0' ;
#endif /* } */
			if (strcmp(sym_name, "_etext") != 0) {
#ifdef ibmrt_bsd /* { */
				if (strncmp(sym_name, "_.")==0) {
					struct nlist nl[2] ;
					/* _.name -> _name */
					sym_name[1] = '_' ; s = &sym_name[1] ;
					nl[0].n_un.n_name = s ;
					nl[1].n_un.n_name = (char *)NULL ;
					if (nlist(ld_tmpfile, nl)==0 && nl[0].n_type==(N_EXT|N_DATA)) {
						sym_val = nl[0].n_value ;
					} else {
						sym_val = 0L ;
						sym_name[1] = '.' ;
						Warning(encs1("Text symbol '%s' has no corresponding data symbol", sym_name), NULL_ENTRY) ;
					}
				}
#else /* } { */
				s = &sym_name[0] ;
#endif /* ibmrt_bsd } */
#ifdef DEBUG
				printf("symbol %s, value=0x%x\n", sym_name, sym_val) ;
#endif
				if (sym_val) {
					hash_enter_function(s, sym_val) ;
					vv[0] = c_s_cpy(s) ;
					append_data(val, val->length, 1L, (char *)vv) ;
				}
			}
                }
        }
	return(val) ;
}
#endif /* } */
#if defined(sun386i) || defined(iris4D) || defined(hp9000s800) /* { */
/* Some macros based on the -lld or -lmld library and <ldfcn.h> */
/* that are usefull on systems using COFF (hp9000s800, sun386i, */
/* iris4D).  The hp9000s800 uses COFF but does not supply the   */
/* ldfcn functions, so I wrote a very simple set to get the job */
/* done.                                                        */
#undef FREAD       /* ldfcn and S both have an FREAD macro, use the former */
#undef FSEEK       /* ditto */
#undef FWRITE      /* ditto */
#include <a.out.h>
#if defined(sun386i) || defined(iris4D) /* { */
#include <ldfcn.h>
extern char *ldgetname() ; /* should be defined in <ldfcn.h>, sigh */
#define N_SECTIONS(ldptr) HEADER(ldptr).f_nscns
#define SCN_IS_BSS(ldptr,section_header) \
	(strcmp(section_header.s_name, ".bss") == 0 \
	|| strcmp(section_header.s_name, ".sbss") == 0)
#define SCN_IS_TEXT(ldptr,section_header) \
	(strcmp(section_header.s_name, ".text") == 0)
#define SCN_ADDR(ldptr,section_header) (section_header).s_vaddr
#define SCN_LENGTH(ldptr,section_header) (section_header).s_size
#define SCN_FILE_LOC(ldptr,section_header) ((section_header).s_scnptr)
#if defined(sun386i) /* { */
#define N_SYMBOLS(ldptr) HEADER(ldptr).f_nsyms
#define SYM_VALUE(symbol) (symbol).n_value
#define SYM_IS_GLOBAL_FUNCTION(ldptr,symbol) \
	((symbol).n_sclass == C_EXT && (symbol).n_scnum == text_section)
#endif /* } sun386i */
#if defined(iris4D) /* { */
#define N_SYMBOLS(ldptr) SYMHEADER(ldptr).isymMax
#define SYMENT SYMR
#define SYM_VALUE(symbol) (symbol).value
#define SYM_IS_GLOBAL_FUNCTION(ldptr,symbol) \
	((symbol).sc == scText && (symbol).st == stProc)
#endif /* } iris4D */
#endif /* } sun386i || iris4D */

#if defined(hp9000s800) /* { */
/* supply a rudimentary ldfcn library and macros */
#define bzero(s,n) (void)memset(s,0,n)

typedef struct {
	FILE *ioptr ;
	FILHDR file_header ;
} LDFILE ;

#define SUCCESS 1
#define FAILURE 0
#define IOPTR(ldptr) ((ldptr)->ioptr)
#define FREAD(p,s,n,ldptr) fread(p,s,n,IOPTR(ldptr))
#define FWRITE(p,s,n,ldptr) fwrite(p,s,n,IOPTR(ldptr))
#define FSEEK(ldptr,offset,whence) fseek(IOPTR(ldptr), offset, whence)
#define HEADER(ldptr) ((ldptr)->file_header)
#define N_SECTIONS(ldptr) ((ldptr)->file_header.subspace_total)
#define N_SYMBOLS(ldptr) ((ldptr)->file_header.symbol_total)
#define SCN_FILE_LOC(ldptr,section_header) ((section_header).file_loc_init_value)
#define SCN_ADDR(ldptr,section_header) ((section_header).subspace_start)
#define SCN_LENGTH(ldptr,section_header) ((section_header).subspace_length)
#define SCN_IS_BSS(ldptr,section_header) ((section_header).file_loc_init_value == 0)
#define SCN_IS_TEXT(ldptr,section_header) \
	(strcmp(section_header.s_name, "$text$") == 0) WRONG AND NOT USED
#define SYM_IS_GLOBAL_FUNCTION(ldptr,symbol) \
		((symbol).symbol_type == ST_ENTRY && (symbol).symbol_scope == SS_UNIVERSAL)
#define SYM_VALUE(symbol) (symbol).symbol_value

/* ARGSUSED */
static LDFILE *
ldopen(name, oldldptr)
char *name ;
LDFILE *oldldptr ;
{
	LDFILE *ret = (LDFILE *)calloc(1, sizeof(LDFILE)) ;
	IOPTR(ret) = fopen(name, "r") ;
	if (!IOPTR(ret)) {
		perror("ldopen -- fopen") ;
		free((char *)ret) ;
		return((LDFILE *)NULL) ;
	}
	if (FREAD((char *)&HEADER(ret), sizeof(HEADER(ret)), 1, ret) < 1) {
		perror("ldopen -- fread(file header)") ;
		free((char *)ret) ;
		return((LDFILE *)NULL) ;
	}
	return(ret) ;
}
static int
ldohseek(ldptr) /* seek to optional (==a.out) header */
LDFILE *ldptr ;
{
	if (FSEEK(ldptr, HEADER(ldptr).aux_header_location, 0) < 0) {
		perror("ldohseek -- fseek") ;
		return(FAILURE) ;
	}
	return(SUCCESS) ;
}

static int
ldshread(ldptr, i, section_header)
LDFILE *ldptr ;
unsigned short i ;
SCNHDR *section_header ;
{
	/* section numbers start at 1 !!! */
	if (FSEEK(ldptr, HEADER(ldptr).subspace_location + (i-1)*sizeof(*section_header), 0) < 0) {
		perror("ldshread -- fseek") ;
		return(FAILURE) ;
	}
	if (FREAD((char*)section_header, sizeof(*section_header), 1, ldptr)<1) {
		perror("ldshread -- fread") ;
		return(FAILURE) ;
	}
	return(SUCCESS) ;
}

static int
ldtbread(ldptr, i, symbol)
LDFILE *ldptr ;
int i ;
SYMENT *symbol ;
{
	if (FSEEK(ldptr, HEADER(ldptr).symbol_location + i*sizeof(*symbol), 0) < 0) {
		perror("ldtbread -- fseek") ;
		return(FAILURE) ;
	}
	if (FREAD((char*)symbol, sizeof(*symbol), 1, ldptr)<1) {
		perror("ldtbread -- fread") ;
		return(FAILURE) ;
	}
	return(SUCCESS) ;
}

static char *
ldgetname(ldptr, symbol)
LDFILE *ldptr ;
SYMENT *symbol ;
{
	static char name[512] ;
	char *s ;
	if (FSEEK(ldptr, HEADER(ldptr).symbol_strings_location + symbol->name.n_strx, 0) < 0) {
		perror("ldgetname -- fseek") ;
		return((char *)NULL) ;
	}
	s = &name[0] ;
	while( (*s++ = getc(IOPTR(ldptr))) &&  s-name < 100 ) ;
	name[100] = '\0' ;
	return(&name[0]) ;
}
#endif /* } hp9000s800 */

static vector *
read_code(code_space, code_size, ld_tmpfile)
char *code_space ;
long code_size ;
char *ld_tmpfile ;
{
        LDFILE *ldptr ;
        AOUTHDR aout_header ;
        SCNHDR section_header ;
        int i ;
	int text_section = -1 ;
	vector *val = alcvec(CHAR, 0L);
	char *vv[1] ;
#ifdef DEBUG
	(void)printf("read_code on 386i or iris4D or hp9000s800 (COFF format)\n") ;
#endif
        ldptr = ldopen(ld_tmpfile, (LDFILE *)NULL) ;
	if (!ldptr) {
		perror("ldopen") ;
		Recover("Could not get file header from object file", NULL_ENTRY) ;
	}
        if (ldohseek(ldptr) == FAILURE) {
                Recover("could not seek to aout_header", NULL_ENTRY) ;
        }
        if (FREAD((char *)&aout_header, sizeof(aout_header), 1, ldptr) < 1) {
                Recover("Could not read aout_header", NULL_ENTRY) ;
        }
	/* read in code and data sections, zero out bss sections */
        /* section numbers begin with one! */
        for (i=1 ; i<=N_SECTIONS(ldptr) ; i++) {
                if (ldshread(ldptr, (unsigned short)i, &section_header)==FAILURE) {
                        perror("ldshread") ;
			Recover(enci1("Cannot read object file section %ld header", (long)i), NULL_ENTRY) ;
                }
		if (SCN_ADDR(ldptr,section_header) + SCN_LENGTH(ldptr,section_header) > (long)(code_space+code_size)) {
			Recover("Didn't allocate enough space to load object file", NULL_ENTRY) ;
		}
		if (SCN_IS_BSS(ldptr, section_header)) {
                        bzero((char *)SCN_ADDR(ldptr,section_header), (int)SCN_LENGTH(ldptr,section_header)) ;
                } else {
			if (FSEEK(ldptr, SCN_FILE_LOC(ldptr,section_header), 0) == -1) {
				perror("seeking to section") ;
				Recover(enci1("Could not seek to object file section %ld", (long)i), NULL_ENTRY) ;
			}
                        if (FREAD((char *)SCN_ADDR(ldptr,section_header), 1,
				(int)SCN_LENGTH(ldptr,section_header), ldptr)
				< SCN_LENGTH(ldptr,section_header)) {
                                perror("FREAD") ;
				Recover(enci1("Could not read object file section %ld", (long)i), NULL_ENTRY) ;
                        }
                }
#ifndef hpux
		if (SCN_IS_TEXT(ldptr,section_header)) {
			text_section = i ; /* this will be 1 on all systems I know of */
		}
#else
		text_section = 1 ;
#endif
        }
	if (text_section == -1)
		Recover("Cannot find text section in object file", NULL_ENTRY) ;
	/* search symbol table for new global text symbols */
	for (i=0 ; i<N_SYMBOLS(ldptr) ; i++) {
		char *sym_name ;
		SYMENT symbol ;
                if (ldtbread(ldptr, i, &symbol) == FAILURE) {
                        perror("ldtbread") ;
			Recover(enci1("Cannot read symbol table entry %ld", (long)i), NULL_ENTRY) ;
                }
		if( SYM_IS_GLOBAL_FUNCTION(ldptr,symbol) &&
			SYM_VALUE(symbol) >= (long)code_space) {
                	/* i.e., if (new global text symbol) */
                        sym_name = ldgetname(ldptr, &symbol) ;
                        if (sym_name) {
#ifdef DEBUG
                                (void)printf("new gloabal function : sym_name=%s, sym_value=0x%x\n", sym_name, SYM_VALUE(symbol)) ;
#endif /* DEBUG */
                                hash_enter_function(sym_name, SYM_VALUE(symbol)) ;
                                vv[0] = c_s_cpy(sym_name) ;
                                append_data(val, val->length, 1L, (char *)vv) ;
                        }
		}
	}
	return(val) ;
}
#endif /* } */
#ifdef NOTDEF /* { */
static vector *
read_code(code_space, code_size, ld_tmpfile)
char *code_space ;
long code_size ;
char *ld_tmpfile ;
{
	Recover("No dyn.load on this system", NULL_ENTRY) ;
}
#endif /* } */
