FUNCTION cmdscale(
	d	/STR/,
	k	/INT,1,2/,
	eig	/LGL,1,FALSE/
	add	/LGL,1,FALSE/
	)

STATIC( real addc,mean,f; integer n,i,j; logical reteig,warned)
STRUCTURE(
	Size/INT,FROM(d),OPTIONAL/,
	x
	)

if(MISSING(Size)) { #full matrix for distance
	P(x)=P(d)
	COERCE(x/MATRIX/)
	n=NROW(x)
	if(n!=NCOL(x))FATAL(Distances must be result of dist or a square matrix)
	}
else { #convert dist result to matrix
	n=Size
	STRUCTURE( x/MATRIX,n,n/ )
	COERCE(d/REAL/)
	j=1
	for(i=1;i<n;i=i+1)
		for(ii=1;ii<=n-i;ii=ii+1){
			x[i+ii,i]=d[j]
			j=j+1
			}
	for(i=1;i<=n;i=i+1)x[i,i]=0.
	for(j=1;j<n;j=j+1)
		for(i=j+1;i<=n;i=i+1)
			x[j,i]=x[i,j]
	}

reteig=eig              #flag if eigenvalues to be returned

STRUCTURE(
	eig	/REAL,k/,
	eiga	/REAL,k/,
	xx	/REAL,n/,
	points	/MATRIX,n,k/,
	evec	/MATRIX,n,k/,
	ac	/REAL,1/
	)

if(add) ac=addc(x,n); else ac=0
call sclpro(x,n,xx,ac)  #transform dissim. to scalar products
call eigen1(x,n,k,eiga,evec,TRUE) #compute k largest eigenvalues, eigenvectors

warned = FALSE
do i1=1,k{
	i=k-i1+1
	if(eiga[i]<=0 && !warned){
		warned = TRUE
		EPRINT("Warning in cmdscale: matrix has only",I(i-1)," positive eigenvalues");
		}
	eig[i1]=eiga[i]
	do j=1,n
		points[j,i1] = evec[j,i]*sqrt(eiga[i])
}

if(reteig)RETURN(eig,&)
if(add)RETURN(ac,&)
RETURN(points)
END
