#mEval - expand args i through j: evaluate builtin or push back defn
subroutine mEval(argstk, i, jarg, evalst)
INCLUDE(macro,cmacro)
integer mIndex, length; external mIndex
integer argno, argstk(ARGSIZE), evalst(1), i, j, jarg, k, m, n, t, narg
integer ii
integer digits(11)

call unpakl(TSTRING(0123456789),digits)
j = jarg; t = argstk(i)

switch(evalst(t)) {
case IFTYPE:  call doif(argstk, i, j, evalst)
case IFDTYPE: call doifd(argstk, i, j, evalst)
case LOOPTYPE:  call doenc(argstk, i, j, evalst)
case PROMPTTYPE:  call doprmt(argstk, i, j, evalst)
case MSGTYPE:  call domsg(argstk, i, j, evalst)
case FATTYPE:  call dofat(argstk, i, j, evalst)
case INCTYPE:  call doincr(argstk, i, j, evalst)
case SUBTYPE:  call dosub(argstk, i, j, evalst)
case DEFTYPE:  call dodef(argstk, i, j, evalst)
case SYSTYPE:  call dosys(argstk, i, j, evalst)
case TMPTYPE:  call dotmp(argstk, i, j, evalst)
default:
	call putbak(END_MACRO)	# signals the end of expansion text from this user macro
	depth = depth+1	# increase user macro depth counter
	call newarg(argstk,i,j,narg,evalst)
	iend = t+length(evalst(t))
	for (k = iend-1; k >= t; k = k - 1)
		if (evalst(k) != ARGFLAG)
			call putbak(evalst(k))
		else {
			kk=min0(k+1,iend-1)
			argno = mIndex(digits, evalst(kk)) - 1
			if(argno < 0){ #char after "$" not numeric
				SWITCH(evalst(kk)) 
				CASE(DOT){ ii=ngetc(ii);  call pbnum(numarg(cp)) } #case: `$.'
				CASE(STAR){ ii=ngetc(ii) #case: `$*'
					#replacement- all unused args
					for(ii=j; ii>=i+2+narg; ii=ii-1){
						call pbstr(evalst(argstk(ii)))
						if(ii != i+2+narg)
						call putbak(COMMA) #comma to separate args
						}
					}
				CASE(LESSTHAN){ ii=ngetc(ii) # shift
					for(ii=i+2+narg; ii<j; ii=ii+1)argstk(ii)=argstk(ii+1)
					j=min0(j-1,i+2+narg)
					}
				DEFAULT{ kk=k #put out "$"
					call putbak(ARGFLAG)
					}
				}
			else {
				for(kk=kk+1; kk<iend; kk=kk+1) {
					id=mIndex(digits,evalst(kk))
					if(id>0)argno=argno*10+id-1
					else break
					}
				do iii=1,kk-k-1 {ii=ngetc(ii)} #cancel pushed chars
				if(argno < j-i){
					n = i + argno + 1
					m = argstk(n)
					call pbstr(evalst(m))
					}
				}
			}
	}
return
end
