#aexpnd		expand array given marginal stats
subroutine aexpnd(pdata,mode,ndim,dim,keep,stats)
POINTER pdata,stats; integer mode,ndim,dim(ndim); logical keep(ndim)

INCLUDE(stack)
POINTER ip1,ip2,ic1,ic2,idel,n1,n2
SAVE(ip1,ip2,ic1,ic2,idel,n1,n2)

# initialize - allocate scratch space
	ip1=jstkgt(7*ndim,INT)
	ip2=ip1+ndim; ic1=ip2+ndim; ic2=ic1+ndim; idel=ic2+ndim
	n1=idel+ndim; n2=n1+ndim
call aexpd2(pdata,mode,ndim,dim,keep,is(idel),
	is(ip1),is(ip2),is(ic1),is(ic2),is(n1),is(n2),stats)
return
end

subroutine aexpd2(pdata,mode,ndim,dim,keep,delta,ptr1,ptr2,ctr1,ctr2,cnt1,cnt2,stats)
POINTER pdata,ptr1(ndim),ptr2(ndim),stats
integer ndim,dim(ndim),delta(ndim),ctr1(ndim),ctr2(ndim),cnt1(ndim),cnt2(ndim)
logical keep(ndim)

INCLUDE(stack)

integer j,n1,n2,jsectn; POINTER ip1,ip2,oldip2,ip2sav,jstkgt,jfrom; integer nxtsub
SAVE(oldip2,ip2sav)

#initialize on 1st call
nj=1; n1=0; n2=0
do j=1,ndim {
	delta(j)=nj; nj=nj*dim(j)
	if(keep(j)){ n1=n1+dim(j); n2=n2+1 }
	else { n1=n1+1; n2=n2+dim(j) }
	}
ip1=jstkgt(n1,INT) # allocate space for indices
ip2=jstkgt(n2,INT); oldip2=ip2; ip2sav=jstkgt(n2,INT)	# an extra copy for use with inner loop
do j=1,ndim { # set ptr1, ptr2 for use with nxtsub
	ptr1(j)=ip1; ptr2(j)=ip2
	if(keep(j)){
		is(ip2)=1; cnt2(j)=1; ip2=ip2+1
		for(i=0; i<dim(j); i=i+1) is(ip1+i)=i+1	# create 1:dim(j)
		cnt1(j)=dim(j); ip1=ip1+dim(j)
		}
	else{
		is(ip1)=1; cnt1(j)=1; ip1=ip1+1
		for(i=0; i<dim(j); i=i+1) is(ip2+i)=i+1	# create 1:dim(j)
		cnt2(j)=dim(j); ip2=ip2+dim(j)
		}
	# ptr1 generates counters for the successive subsections
	# ptr2 will generate the elements of each section
	}
call icopy(is(oldip2),is(ip2sav),n2)
jfrom=stats; jsectn= -1
repeat { #loop over margins (==elements in stats)
	jsectn=nxtsub(ptr1,cnt1,delta,ndim,jsectn,ctr1) #start of next section (ctr1 & is(ptr1) changed)
	if(jsectn<0)break # done all sections
	call icopy(is(ip2sav),is(oldip2),n2)	# refresh pointers
	do j=1, ndim #set up ptr2 to loop over this section
		if(keep(j)) is(ptr2(j))=ctr1(j)+1 #ctr goes from 0 to dim-1
	
	jdata= -1
	repeat { #over items into which the margin element expands
		jdata=nxtsub(ptr2,cnt2,delta,ndim,jdata,ctr2)
		if(jdata<0)break # copied all the section
		switch(mode) {
		case REAL: rs(pdata+jdata)=rs(jfrom)
		case INT,CHAR: is(pdata+jdata)=is(jfrom)
		case LGL: ls(pdata+jdata)=ls(jfrom)
			}
		}
	jfrom=jfrom+1 # next item in stats
	}
return
end
