ROUTINE(scalsy,		find coordinate scale for symbol plot)
subroutine scalsy(u,n,du,size,width,umin,umax,duscal,convrg)
real u(n),du(n),size,width,umin,umax,duscal; integer n; logical convrg

#  u is set of coordinates, du is associated symbol radius
#  size is desired size of largest symbol (inches), width is axis width (inches)
#  umin and umax are required max and min values on axis
#  duscal is factor to turn du into coordinates

# Solves the system of equations
# 1)  (umax-umin)/scale=width      (scale is units per inch)
# 2)  max(u[i]+duinch[i]*scale)=umax
# 3)  min(u[i]-duinch[i]*scale)=umin
# let range=umax-umin; and duinch[i] is du[i] converted to inches
# from 2)-3)   range=max(u[i]+duinch[i]*scale)-min(u[i]-duinch[i]*scale)
# substitute for scale=range/width and solve for range
#    range=max(u[i]+duinch[i]/width*range)-min(u[i]-duinch[i]/width*range)

real a,c,range,newran,umn,umx,eps
integer i,maxitr
data maxitr/40/,eps/1e-4/

call narang(du,n,dumin,dumax)
a=size/(dumax*width)	# converts du into fraction of width
call narang(u,n,umn,umx)	# initial estimates
range=umx-umn
for(iter=1; iter<=maxitr; iter=iter+1){
	c=a*range	# converts du into user coords
	umx=-BIG; umn=BIG
	do i=1,n {
		if(NA(u(i))|NA(du(i))) next
		umx=amax1(u(i)+c*du(i),umx)
		umn=amin1(u(i)-c*du(i),umn)
		}
	newran=umx-umn
	if(abs(newran-range) <= eps*range) break
	range=newran		# new est will always be too small (proof?)
	}
duscal=c; umax=umx; umin=umn
convrg = iter<=maxitr

return
end
