#vudraw		generate vugraphs 
#	V 1.8 of 81/11/20
subroutine vudraw(lines,nline,pwidth,pht,line,indent,csizes,nsizes,font)
POINTER lines(nline),font; integer nline,indent,nsizes
real pwidth,pht,line,csizes(nsizes)
INCLUDE(stack,graphics,read)
# lines - vector of pointers to nline lines of text
# pwidth, pht - page size in inches
# line - line thickness in inches (for bold-face, bullets, etc)
# thick - pen thickness

logical hdfont
real size, width,height,vcsi,hcsi,cex,ocsi,om1,om2,om3,om4,hlite,cx,cy,offsiz
POINTER ptr,gtfont,curfnt,ft; integer offset,symbol,bold,center,nlist,ltype(10); logical streq
CHARACTER(ichar,1); CHARACTER(jgetch,1); CHARACTER(lifld,20)
CHARACTER(opty,1); CHARACTER(cmd,10); real arg,flengz
define(`CASE',`if(streq(cmd,TSTRING($1)))')
INCLUDE(font)

QUERY( mai(om1,om2,om3,om4), pty(opty) ); SPECIFY( mai(0.0,0.0,0.0,0.0) )
call inpltz(pwidth,pht)

# 1st pass - get sizes
curfnt=gtfont(NULL)
if(font!=NULL) curfnt=gtfont(font)
size=1.; width=0.; height=0.; offset=0; nlist=0; hdfont=FALSE
if(curfnt==NULL) hdfont=TRUE
for(i=1; i<=nline; i=i+1) {
	ptr=lines(i)
	ichar=jgetch(TEXT(ptr),1)
	if(ichar==".") {
		FIELD_ERROR=FALSE	# rid of errors from previous decodes
		GETSTRING(TEXT(ptr)); AUTO_CHECK=FALSE
		DECODE(S(cmd,10))
		CASE(.L) {DECODE(R(arg)); if(EOF)size=size*1.25; else size=arg}
		else CASE(.S) {DECODE(R(arg)); if(EOF)size=size*0.80; else size=arg}
		else CASE(.SP) {DECODE(R(arg)); if(EOF) height=height+1; else height=height+arg}
		else CASE(.DL) offset=offset+indent #start lists
		else CASE(.BL) offset=offset+indent #start lists
		else CASE(.GL) offset=offset+indent #start general list
		else CASE(.NL) offset=offset+indent	# numbered list
		else CASE(.LE) offset=offset-indent # end of list
		else CASE(.F) { DECODE(NP(ft)); if(ft==NULL) ft=font
				curfnt=gtfont(ft);
				if(curfnt==NULL) hdfont=TRUE }
		# all other cmds ignored
		}
	else {	# characters to be plotted
		height=height+size
		width=amax1(width,size*(offset+flengz(TEXT(ptr),curfnt)/HERSH_WID))
		}
	}
# determine maximum char. size allowed
if(hdfont) QUERY( cin(cx,cy) )
else {cx=HERSH_WID; cy=HERSH_HT}
height=amax1(height,1.); width=amax1(width,1.)	# avoid divide by zero
vcsi=pht/height
hcsi=(pwidth*cy)/(width*cx)
csi=amin1(vcsi,hcsi) #more subtle strategy would be to use different sizes
		# for long lines, or break lines

QUERY( csi(ocsi), col(ocol) ); SPECIFY( csi(csi) )
SPECIFY( usr(0.,width,0.,height) )

# 2nd pass - plot
if(font!=NULL) curfnt=gtfont(font)	#restore initial font
size=1.; y=height; bold=0; offset=0; center=0; hlite=0.
QUERY( cex(cex) ); SPECIFY( col(1.) )
dx=line*(width/pwidth)	#convert line thickness to x-coords
for(i=1; i<=nline; i=i+1) {
	ptr=lines(i)
	ichar=jgetch(TEXT(ptr),1)
	if(ichar==".") {
		FIELD_ERROR=FALSE
		GETSTRING(TEXT(ptr)); AUTO_CHECK=FALSE
		DECODE(S(cmd,10))
		CASE(.CE) {DECODE(R(arg)); if(EOF) center=1; else center=arg}
		else CASE(.L)  { DECODE(R(arg)); if(EOF) size=size*1.25; else size=arg; call vusetz(cex*size,csizes,nsizes) }
		else CASE(.S)  { DECODE(R(arg)); if(EOF) size=size*0.80; else size=arg; call vusetz(cex*size,csizes,nsizes) }
		else CASE(.B) {DECODE(R(arg)); if(EOF) bold=1; else bold=arg}
		else CASE(.R) bold=0
		else CASE(.H) {DECODE(R(arg)); if(EOF) hlite=0; else hlite=arg}
		else CASE(.SP) {DECODE(R(arg)); if(EOF) y=y-1; else y=y-arg}
		else CASE(.C) {DECODE(R(arg)); if(EOF) SPECIFY( col(1.) ) else SPECIFY( col(arg) )}
		else CASE(.GL){	# general list - use character string arg
			symbol=0; offset=offset+indent
			DECODE(S(lifld,20))
			nlist=nlist+1; ltype(nlist)=symbol
			}
		else CASE(.BL){ symbol=1; offset=offset+indent; nlist=nlist+1; ltype(nlist)=symbol }
		else CASE(.DL){ symbol=2; offset=offset+indent; nlist=nlist+1; ltype(nlist)=symbol }
		else CASE(.NL){ symbol=3; offset=offset+indent; nsymb=0; nlist=nlist+1; ltype(nlist)=symbol }
		else CASE(.LE) { offset=offset-indent; nlist=nlist-1; if(nlist>0)symbol=ltype(nlist) }
		else CASE(.LI) call vusymb(float(offset-indent),y-.5*size,bold,dx,symbol,nsymb,lifld,hlite,curfnt)
		else CASE(.F) { DECODE(NP(ft)); if(ft==NULL) ft=font
				curfnt=gtfont(ft) }
		}
	else { #non-cmd - plot it
		offsiz = offset * size;
		if(center>0) {x=.5*(width-offsiz)+offsiz; adj=.5 }
		else {x=offsiz; adj=0. }
		call vutext(x,y-.5*size,TEXT(ptr),islenz(TEXT(ptr)),dx,adj,bold,hlite,curfnt)
		#adjust y; reset 1-time parameters
		y=y-size
		if(center>0) center=center-1
		}
	}
SPECIFY(pty(opty), col(ocol), mai(om1,om2,om3,om4), csi(ocsi) )
return
end
