ROUTINE(tsaxpz,		plot axis in time format)
subroutine tsaxpz(iside,xllab,xlline,y1,y2,nint,pa,leng,iswa)

logical mnthly,long,years
CHARACTER(month,1,12); CHARACTER(lmnth,3,12); CHARACTER(quart,2,4)
INCLUDE(stack,print)
POINTER jstkgt,iu,iv,istrng
data month/"J","F","M","A","M","J","J","A","S","O","N","D"/
data lmnth/"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"/
data quart/"1Q","2Q","3Q","4Q"/
period = amin1(12.,pa)	# labels, etc at most monthly
isw = iswa
nl = amax0(1,nint)
dy = (y2-y1)/float(nl)
npt = nl+1
nalloc = jstkst(1)
iu = jstkgt(npt,REAL)
j = iu
do i = 1,nl {
	rs(j) = y1+float(i-1)*dy
	j = j+1
	}
rs(j) = y2
if (dy<=0.99&&period>1.0&&isw!=0) {	# if yearly or less frequent, let vaxis make up labels
	npery = amin1(1./dy,period)+.1
	mnthly = period>5.
	long = leng>=5
	years = amin1(y1,y2)>0.		# if year>0 plot years, else only month or quarter
	iv = jstkgt(npt,PTR)
	j = iv
	do i = 1,npt {
		y = y1+float(i-1)*dy
		iy = y+.01
		ip = mod(ifix(y*period+.5),ifix(period))+1	# assumes period is integer
		if(years) ENCODE(I(iy,0),C(NEWLINE,1))
		if(!mnthly) ENCODE(C(quart(ip),2))
		else if(long) ENCODE(C(lmnth(ip),3))
		else ENCODE(C(month(ip),1))
		is(j)=istrng(BUFFER,BUFPOS)
		CLEAR
		j=j+1
		}
	isw = isign(3,isw)
	}
call vaxisz(iside,xllab,xlline,rs(iu),rs(iu),is(iv),npt,leng,isw)
call jstkrl(jstkst(1)-nalloc)	# get rid of allocations
return
end
