ROUTINE(backsu,solves R.Y=W for R upper-triangular)
subroutine backsu(r,p,pdim,w,q,y)
integer p,pdim,q,k,j
real r(pdim,p),w(pdim,q),y(pdim,q),dot
for(k=p; k>0; k=k-1) {
	do j = 1,q {
		if(p>k) y(k,j) = -dot(-w(k,j),y(k+1,j),1,p-k,r(k,k+1),pdim)
		else y(k,j) = w(k,j)
		if(abs(r(k,k)) > abs(y(k,j))*SMALL) y(k,j)=y(k,j)/r(k,k)
		else y(k,j) = sign(BIG, y(k,j)) # avoid overflow
		}
	}
return
end
