#include <stdio.h>
#include <signal.h>
#include "S.h"
#include "options.h"
#include "y.tab.h"

vector *S_put();
void put_data();
char char_header[] = "\0S data\001";
char c_d_header[] = "\0S dict\001";
double *data_header = (double *)char_header;
double *dict_header = (double *)c_d_header;

static void put_to_file(), badwrite(), write_error(), new_temp(), dict_close();
static long put_values(), dict_names();
static char *this_name, Tmpfile[20];
static FILE *file;
static vector *put_check;
static int made_temp = 0;

void 
put_data(name, database, ent)
char *name; 
char *database;  
vector *ent;
{
	char *path, *path1, *from, *to, *path_tail;
	long n, prev;
	vector *class_frame;
	if(ent->mode == STRUCTURE  && 
	  xact_comp(ent,"class")!=NULL_ENTRY ) { /* look for a "<-" method */
		vector *arglist, **args, *p;
		arglist = alcvec(LIST,2); args = arglist->value.tree;
		args[0] = p = alc_name(name); p->name = "x";
		p = New_vector(); *p = *ent; p->name = "value";
		args[1] = p;
	  	class_frame = class_fun(NULL_STRING, "<<-", S_void, arglist);
		if(class_frame!=NULL_ENTRY) {
			class_frame = eval(class_frame); n = data_mode(class_frame);
			if(NOT_RECURSIVE(n)) return; /* cancel the assignemnt*/
			if(p = xact_comp(class_frame, "name")) name = string_value(p);
			if(p = xact_comp(class_frame, "value")) ent = p;
		}
	}
	this_name = name;
	if((n=strlen(name))>MAX_FILE_NAME_LEN) {
		path = S_alloc(MAX_FILE_NAME_LEN+1L,sizeof(char));
		strncpy(path,name,MAX_FILE_NAME_LEN);
		name = path;
		n = MAX_FILE_NAME_LEN;
	}
	if(bad_name(name,n)){
		Recover(encs1("\"%s\" is not a legal object name",name),NULL_ENTRY);
		return;
	}
	if(data_mode(ent) == FUN_DEF) { /* check for masking system function */
		path = encs2("%s/s/.Functions/%s",shome,name);
		if(access(path,4)==0) Warning(encs1("assigning \"%s\" has masked the system function of the same name",name),NULL_ENTRY);
	}
	prev = set_alloc(1L);
	path = S_alloc(2+strlen(database)+n,sizeof(char));
	if(!made_temp)new_temp();
	path1 = S_alloc(2+strlen(database)+10L,sizeof(char));
	to=path1; from=database; while(*from)*to++ = *from++;
	*to++ = '/'; path_tail = to;
	strcpy(path_tail,Tmpfile); /* write to an illegal name until commit time */
	file = fopen(path1,"w");
	if(file == NULL){
		Recover(encs2( "Cannot create the file in \"%s\" to assign datset \"%s\"",
			database, name),ent);
		return;
	}
	add_error((fun_ptr)write_error);
	put_to_file(ent);
	fclose(file);
	del_error((fun_ptr)write_error);
	set_alloc(prev);
	/* now commit the revised version */
	to=path; from=database; while(*from)*to++ = *from++;
	*to++ = '/'; path_tail = to;
	strcpy(path_tail,name);
	if(!access(path,0) && access(path,2))
		Recover(encs1("Assignment error: \"%s\" exists without write permission",name),NULL_ENTRY);
	unlink(path);
	if(link(path1,path)){
		new_temp();
		Recover(encs2("Could not commit assignment of \"%s\" - Data is on file \"%s\"",name,path1),NULL_ENTRY);
	}
	else {
		unlink(path1);
		if(audit_file){
			int mode = ent->mode;
			char *m = mode==ANY?"any":(mode==FUN_DEF?"function":token_name(mode));
			fprintf(audit_file,"#~put \"%s\" %ld \"%s\"\n",path,file_mtime(path),m);
		}
	}
}

vector *
S_put(ent,arglist)
vector *ent, *arglist;
{
	vector **args = arglist->value.tree; char *name, *dbase;
	vector *value, *where; long n; extern vector *Search_list;
	name = string_value(args[0]);
	if(IS_NULL_STRING(name)) Recover("Empty object name",ent);
	value = args[1]; where = args[2];
	if(where->mode == CHAR) {dbase = string_value(where); n=0;}
	else {
		n = long_value(where,ent);
		if(n<1 || n > Search_list->length)
			Recover(enci1("Argument	where (%ld) not in the range of elements of search list",n),NULL_ENTRY);
		dbase = Search_list->value.Char[n-1];
	}
	if(n==1 || (n==0 && name_eq(dbase,Search_list->value.Char[0])))
	/* equivalent to ordinary assign */
		assign_obj(name,value,NULL_ENTRY,TRUE);
	else put_data(name,dbase,value);
	return(S_void);
}

static void 
put_to_file(ent)
vector *ent;
{
	if(FWRITE(data_header,1,file) != 1)badwrite("data_header");
	if(FWRITE(&ent->mode,1,file) != 1)badwrite("mode");
	if(FWRITE(&ent->length,1,file) != 1)badwrite("length");
if(check){
	if(!atomic_type(ent->mode))put_check = rec_check(NULL_ENTRY,NULL_ENTRY,REC_INIT);
}
	put_values(ent);
}

static long 
put_values(ent)
vector *ent;
{
	long *modes, *lengths, *ll, i, stringlen, file_pos=ftell(file),
		last_pos, value_pos;
	vector **children; char **chptr;
	char *name;
if(check){
	sanity(ent,"put_values vector");
}
	switch(ent->mode) {
	case LGL:
	case INT:
		if(FWRITE(ent->value.Long,ent->length,file) != ent->length)badwrite("integer data");
		break;
	case REAL: 
		if(FWRITE(ent->value.Float,ent->length,file) != ent->length)badwrite("single data");
		break;
	case DOUBLE: 
		if(FWRITE(ent->value.Double,ent->length,file) != ent->length)badwrite("double precision data");
		break;
	case COMPLEX: 
		if(FWRITE(ent->value.Complex,ent->length,file) != ent->length)badwrite("complex data");
		break;
	case CHAR: 
		stringlen=0; i=ent->length; chptr = ent->value.Char;
		ll = lengths = (long *)S_alloc(i,sizeof(long));
		while(i--){ *lengths = strlen(*chptr++)+1; stringlen += *lengths++;}
		if(FWRITE(&stringlen,1,file) != 1)badwrite("lengths");
		i=ent->length; chptr = ent->value.Char; lengths = ll;
		while(i--){
			if(FWRITE(*chptr,*lengths,file) != *lengths)badwrite("char. data");
			chptr++; lengths++;
		}
		break;
	case NAME: 
		stringlen = strlen(ent->value.name)+1;
		if(FWRITE(&stringlen,1,file) != 1)badwrite("lengths");
		if(FWRITE(ent->value.name,stringlen,file) != stringlen)badwrite("name data");
		break;
	default: 
		if(!(i=ent->length))break;
		children = ent->value.tree;
if(check){
		if(children==NULL)Recover("null children ptr in put_values",ent);
}
		stringlen=0; ll = lengths = (long *)S_alloc(2*i,sizeof(long));
		while(i--){ /*compute all comp. name lengths */
if(check){
			sanity(*children,"put_values child");
}
			name = (*children++)->name;
			if(!name)(*(children-1))->name = name =  "";
			*lengths = strlen(name)+1; stringlen += *lengths++;
		}
		if(FWRITE(&stringlen,1,file) != 1)badwrite("lengths");
		i=ent->length; children = ent->value.tree; lengths = ll;
		while(i--){ /* write component names */
			if(FWRITE((*children)->name,*lengths,file) != *lengths)badwrite("component names");
			children++; lengths++;
		}
		i=ent->length; children = ent->value.tree; modes=ll; lengths = ll+i;
if(check) {
		rec_check(put_check,ent,REC_ADD);
}
		while(i--){
if(check) {
			if(rec_check(put_check,*children,REC_CHECK)!=NULL_ENTRY)
				Recover("Can't write out data with a loop in it",NULL_ENTRY);
}
			*modes++ = (*children)->mode;
			*lengths++ = (*children++)->length;
		}
		i = 2*ent->length;
		if(FWRITE(ll,i,file) != i)badwrite("modes & lengths");
		i=ent->length; children = ent->value.tree; lengths = ll;
		value_pos=ftell(file); fseek(file,i*sizeof(long),1);
		while(i--) *lengths++ = put_values(*children++);
if(check) {
		rec_check(put_check,ent,REC_DELETE);
}
		last_pos=ftell(file); fseek(file,value_pos,0); i = ent->length;
		if(FWRITE(ll,i,file) != i)badwrite("value ptrs");
		fseek(file,last_pos,0);
	}
	return(file_pos);
}

static void 
badwrite(what)
char *what;
{	
	fprintf(stderr,"Error in writing datset: %s\n",this_name);
	Recover(encs1("Error in writing out %s",what),NULL_ENTRY);	
}

static void 
write_error()
{
	fclose(file);
}

static void 
new_temp()
{
	char c;
	c = '0'+ (made_temp++)%78;
	sprintf(Tmpfile,".tmp%x%c",mainpid,c);
}

static long o_hash;

static void 
dict_close()
{
	fclose(file);
	Data_hash = o_hash;
}


make_dict_file(output,names,locs,pos,nnames,append)
char **output, **names; long *nnames, *locs, *pos, *append;
{
	long n = *nnames,i,lp_pos;
	vector *object, *get_data(); char *encs1();
	unsigned charmash(); extern double *dict_header;
	if(n<=0)return;
	if(pos == (long *)NULL) pos = (long *)S_alloc(n,sizeof(long));
	if(locs == (long *)NULL) locs = (long *)S_alloc(n,sizeof(long));
	if((file = fopen(*output, ((int)*append ? "a" : "w")))==NULL)
		Recover(encs1("Can't open file \"%s\" for dictionary",
			*output),NULL_ENTRY);
	MEANINGFUL(lp_pos);
	if(*append == 0)
		lp_pos = dict_names(n,names);
	o_hash = Data_hash; Data_hash = NULL; /* don't bother to hash */
	add_error((fun_ptr)dict_close);
	for(i=0;i<n;i++) {
		object = get_data(names[i],ANY);
		if(!object)
			Recover(encs1("Can't find object %s for dictionary",names[i]),NULL_ENTRY);
		locs[i] = ftell(file);
		put_to_file(object);
		pos[i] = (long)charmash(names[i]);
	}
	if(!(*append)) { /* write out the initial information */
		fseek(file,lp_pos,0);
		if(FWRITE(locs,n,file)!=n)badwrite("locations");
		if(FWRITE(pos,n,file)!=n)badwrite("hash");
	}
	dict_close();
}

static long 
dict_names(n,names)
long n; char **names;
{
	long i, *ll, *lengths, stringlen; char **chptr;
	fseek(file,0L,0);
	/* write the names -- this is the same discipline as used for */
	/* character data in put_values */
	stringlen=0; i=n; chptr = names;
	if(FWRITE(&i,1,file)!=1)badwrite("initial  length");
	ll = lengths = (long *)S_alloc(i,sizeof(long));
	while(i--){ *lengths = strlen(*chptr++)+1; stringlen += *lengths++;}
	if(FWRITE(&stringlen,1,file) != 1)badwrite("lengths");
	i=n; chptr = names; lengths = ll;
	while(i--){
		if(FWRITE(*chptr,*lengths,file) != *lengths)badwrite("char. data");
		chptr++; lengths++;
	}
	i = ftell(file);
	fseek(file,2*n*sizeof(long),1); /*space foward for locs, pos */
	return(i);
}

void 
save_restart()
{
	char *rfile = ".Restart", **names; vector **p;
	long i,n, no = FALSE;
	int found;
	if(!frame0)frame0 = alcvec(LIST,0L);
	n = frame0->length;
	names = (char **)S_alloc(n,sizeof(char *));
	/* look for active device; delete .Device; close device */
	for(i=0, p= frame0->value.tree, found=FALSE;
	  i<n; i++, p++) {
		if(found){ p[-1] = p[0]; names[i-1] = (*p)->name;}
		else if(name_eq(p[0], ".Device"))found = TRUE;
		else names[i] = (*p)->name;
	}
	if(found) {
		fputs("Closing down graphics device\n",stderr);
		gr_wrap();
	}
	if(runit_pid)kill(runit_pid,SIGKILL);
	make_dict_file(&rfile,names,(long *)NULL,(long *)NULL,&n,&no);
	exit(0);
}
