/* scan a data file, recording which characters occurred
   in each position of each record -- useful for fixed format
   data records, especially those including categorical data
   with one entry per column
*/

#include <stdio.h>
#define MAXLEN 500

main(argc,argv)
int argc; char * argv[];
{
	static long table[MAXLEN][128];
	long nrecs, c, i, j, maxi, flag, count;
	float f;

	for(i=0; i<MAXLEN; i++)
		for(j=0; j<128; j++) table[i][j]=0;

	nrecs=0; i=0;
	for(;;){
		if((c = getchar())==EOF) break;
		table[i++][c&0177]++;	/* count newlines, too */
		if(i>maxi) { maxi = i;
			if(i>=MAXLEN) { fprintf(stderr,"Record %d too long\n",nrecs+1); exit(1); }
			}
		if(c=='\n') { nrecs++; i=0; }
		}
	
	for(i=0; i<maxi; i++){	/* print the tables */
		flag = 0;
		for(j=0; j<128; j++){
			count = table[i][j];
			if(count==0) continue;
			if(flag++ == 0)
				printf("\n\nChar   Count     %%    Column %ld\n\n",i+1);
			f =  100. * (float) count / (float) nrecs;
			if(j<' ') printf("'^%c' %7ld %7.2f\n",j+'@',count,f);
			else      printf("'%c'  %7ld %7.2f\n",j,count,f);
			}
		}
	printf("\n\nLongest Record (including final newline) = %ld\n",maxi);
	printf("Total Records  = %ld\n",nrecs);
}
