/*
 * dino_test.c
 *
 * Main routine for v3.0 test for LV824-E
 *
 * Copyright 1998 WDI R&D, Inc.
 *
 * Author       Date        Comments
 * John Green   15-Jan-95   Written
 * John Green   01-Feb-95   Final tuning for rev 3.0
 *
 * Modified for use by WDI R&D Cambridge by abennett 7/22/98
 *
 */

static char SccsId[] = "@(#)dino_test.c	1.3 22 Jul 1998";

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <signal.h>

#include <sys/sched.h>
#include <sys/types.h>
#include <sys/time.h>

#include "lv3.h"

void setup_lv(void );
void init_timer(void );
void rf_quit(void );
void catcher(void );
int ms_time(double *);

extern int open_lv(bglv *, char *, int );
extern int init_lv(bglv *);
extern int close_lv(bglv *);

extern int w_lv(int, char *);
extern int r_lv(bglv *);

extern int check_rev(bglv *);
extern int check_setup(bglv *);

bglv bgdata;

double start, now;
struct itimerval itv;

int presscount;
/*
 * main()
 *
 * This is where everything happens
 *
 */

main()
{
   int      st;
   long     counter = 0;
   int      i;
   int      j;
   char     inputs = 1;

   presscount = 0;
   setscheduler(0, SCHED_FIFO, 28);

   setup_lv();
#ifndef DEBUG
   init_timer();
#endif

   st = ms_time(&start);

   i = 0;
   while(counter++ < 10000000)
   {
      st = w_lv(bgdata.sp_fd, "o");

      st = ms_time(&now);
#ifdef DEBUG
      //sginap(3);
#else
      sigpause(SIGALRM);
#endif

      st = r_lv(&bgdata);
                  
      /* if ( inputs && counter % 15 == 0) */
      if(inputs)
      {  
         for ( j = 0; j < 8; j++ )
         {
	   if ( bgdata.analog_in & 0x1 << j )
	     printf("%4.0f  ", bgdata.ain[j]*100.0);
         }

         for ( j = 0; j <=2; j++ )
         {
            if ( bgdata.dig_in & 0x10 << j )
            {
               for ( i = 0; i < 8; i++ )
               {
                  if ( (bgdata.din[j]>>i) & 0x1 )
                       { presscount++; printf("1"); }
                  else
                      printf("0"); 
               }
               //printf("  ");
            }
         }

       	 printf("\n"); 
      }
      /*      if ( (counter % 200) == 0 )
         printf("%7ld  Update rate = %5.2f Hz\n",
                  counter, counter/(now-start) );
      */
   }
    
   printf("%ld transfers in %f sec.\n", counter, (now-start) );
   printf("Update rate = %5.2f Hz\n", counter/(now-start) );

   exit(0);
}


void setup_lv()
{
   int st;
   int i;
   
/*
 * Defaults to 4 analog, and 8 discretes
 */
 
   bgdata.analog_in = 0;
   bgdata.analog_in = AIC1 | AIC2 | AIC3;

   bgdata.dig_in = 0;
   bgdata.dig_in = DIC2;

/*
 *  Set the baud rate
 */
   bgdata.baud    = BAUD192;
 
/*
 *  Open the port & drivers
 */
   st = open_lv(&bgdata, "/dev/ser2", FB_NOBLOCK);
   if (st < 0)
   {
      printf("Unable to open port\n");
      exit(-1);
   }
/*
 *  Send the init string
 */
   st = init_lv(&bgdata);
   if ( st < 0 )
   {
      check_setup(&bgdata);
      printf("Invalid setup requested.  Bye\n");
      exit(-1);
   }
}

void catcher()
{
}

int ms_time(double *t)
{
   struct timeval tp;
   struct timezone tzp;
   int st;

   st = gettimeofday(&tp, &tzp);
   *t = tp.tv_sec +  ((float)tp.tv_usec / 1000000.0);

   return(0);
}

void rf_quit()
{
   int st;

   st = close_lv(&bgdata);
   printf("Bye\n");
   printf("PressCount: %d", presscount);
   exit(0);
}


void init_timer()
{
/*
 * Initialize the itimer
 */
   itv.it_interval.tv_sec = 0;
   itv.it_interval.tv_usec = 20000;
   itv.it_value = itv.it_interval;
   setitimer(ITIMER_REAL, &itv, (struct itimerval *)0 );
 
   sigset(SIGALRM,  catcher);
   sigset(SIGQUIT,  rf_quit);
   sigset(SIGKILL,  rf_quit);
   sigset(SIGINT,   rf_quit);
}
