/*
 * Copyright 1994   BG Systems, Inc.
 * check_rev.c
 *
 * routine that checks the EPROM revision
 *
 * Author         Date       Comments
 * John Green     21-Oct-94  Author
 * John Green     01-Feb-95  Rev 3.0 release version.
 * John Green     09-Feb-95  Fixed input checking.
 * John Green     03-Mar-97  Use r_cs and w_lv instead of read/write
 * John Green     20-Oct-97  Update for 3.07 EPROM
 */

static char SccsId[] = "@(#)check_rev.c	1.8 05 Nov 1997";

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include "lv3.h"

static char Cpy[] = "Copyright (c), BG Systems";

extern int r_cs(bglv *, char *);
extern int w_lv(int , char *);

int parse_year(char *);
void no_answer(void);

int check_rev(bglv *bgp)
{
   int st;
   int chars_read = 0;
   char str[64];

/*
 *  Send a "T" and see if the Box responds
 *  Set str_len to 44 for the copyright string.
 */
   st = w_lv(bgp->sp_fd, "T");
   // Give the Cereal Box and opportunity to send back data.
   // sginap suspends the calling process for n clock ticks.
   //sginap(100); 
   sleep(1);
   bgp->str_len = 44;
   chars_read = r_cs(bgp, str);

/*
 *  If chars_read <= 0, looks like we have a Rev 1.x EPROM
 */
   if (chars_read <= 0)
   {
      no_answer();
      return(-1);
   }
   else
   {
/*
 *  Check the string length
 */
      if ( chars_read != 44 )
      {
         printf("Unexpected characters:  %d  %s\n", chars_read, str);
         return(-1);
      }
      else
      {
/*
 *  Check that it is the Copyright string
 */
         if ( strncmp(str, Cpy, strlen(Cpy)) != 0 )
         {
            printf("No match on copyright string:  %d  %s\n", chars_read, str);
            return(-1);
         }
         else
         {
/*
 *  If we go this far, we should have the right string 
 */
            bgp->Rev.year  = parse_year(str);
            bgp->Rev.major = str[38]-48;
            bgp->Rev.minor = str[40]-48;
            bgp->Rev.bug   = str[41]-48;
            bgp->Rev.alpha = str[42];
            printf("%s %d  Revision %d.%d%d%c\n", Cpy, bgp->Rev.year,
                      bgp->Rev.major,  bgp->Rev.minor,
                      bgp->Rev.bug, bgp->Rev.alpha );
         }
      } 
   }
 
   return (bgp->Rev.major);
}

int parse_year(char *s)
{
   int i = 0;
   char yr[12];

   while ( *s != '1' )
      *s++;
   yr[i] = *s;
   while ( *s != ' ' && *s != ',' )
      yr[i++] = *s++;
   yr[i] = '\0';
   return(atoi(yr));
}

int check_setup(bglv *bgp)
{
   int i;
   int st = 0;

/*
 *  This routine checks the EPROM revision against the
 *  requested setup, and attempts to identify inconsistencies !
 */

   if ( bgp->Rev.major == 2 )
   {
      if ( bgp->analog_out != 0x0 )
      {
         printf("  Analog outputs not supported by LV816\n");
         st = -1;
      }
      if ( bgp->dig_out != 0x0 )
      {
         printf("  Digital outputs not supported by LV816\n");
         st = -2;
      }
      if ( bgp->dig_in & 0x40 )
      {
         printf("  Digital inputs 19-24 not supported by LV816\n");
         st = -3;
      }
   }
   else if ( bgp->Rev.major == 3 )
   {
      switch(bgp->Rev.alpha)
      {
       case 'e':
         printf("LV824-E\n");
         if ( bgp->analog_out != 0x0 )
         {
            printf("  Analog outputs not supported\n");
            st = -1;
         }
         if ( bgp->dig_out != 0x0 )
         {
            printf("  Digital outputs not supported\n");
            st = -2;
         }
         break;
       case 'f':
         printf("LV824-F\n");
         if ( bgp->analog_out != 0x0 )
         {
            printf("  Analog outputs not supported\n");
            st = -2;
         }
         break;
       case 'g':
         printf("LV824-G\n");
         if ( bgp->analog_out & AOC4 )
         {
            printf("Only 3 analog outputs on the LV824-G \n");
            st = -2;
         }
         break;
       case 'h':
         printf("LV824-H\n");
         break;
       case 'j':
         printf("LV824-J\n");
         break;
       case 'k':
         printf("LV824-K\n");
         break;
       default:
         st = -3;
         printf("Not an LV824 board\n");
         break;
      }
      if ( st < 0 )
         return(st);
/*
 *  Check also for conflict in the digital channels
 */

      if ( bgp->dig_in && bgp->dig_out )
      {
         for ( i = 0; i < 3; i++ )
         {
            if ( ( (bgp->dig_in >> i) &0x1 ) 
                 && ( (bgp->dig_out >> i) &0x1 ) )
            {

printf("Invalid set-up requested.\n");
printf("  Digital input group %d AND output group %d selected\n",                        i+1, i+1);

printf("\n\n  Digital channels can be set in groups of 8 as\n");
printf("  either inputs or outputs.\n");
printf("  Of course you can (for example) set the bottom 8\n");
printf("  to inputs DIC1 and the top 16 to outputs DOC2 | DOC3\n");

               st = -5;
               return(st);
            }
         }
      }
   }
   return(st);
}

void no_answer()
{
   printf("\nWriting a 'T' to the Box produced no answer.  \n");
   printf("\n");
   printf("The expected string was not returned from the BG box.\n");
   printf("Here are some possible problems:\n");
   printf("   1. Check power to Box\n");
   printf("   2. Check the serial cable\n");
   printf("   3. Check the environment variable FBPORT\n");
   printf("      - does it match the connected serial port ?\n");
   printf("   4. Is the serial port configured as a terminal ? \n");
   printf("      - if so use \"System Manager\" to disconnect the port\n");
   printf("   5. You have an old FlyBox (serial no. less than 60) \n");
   printf("         which has a revision 1.0 EPROM.  Call BG Systems.\n");

   printf("\n\n");
}
