//-----------------------------------------------------------
// t2_struct.h carries structures for various i/o processes,
// and for setting up the run
//
// fsh 4 February 1998
//-----------------------------------------------------------

struct joints_st {
	double hip ;
	double knee ;
	double foot ;
	double toe ; 		// Akhil's appendage
} ;

struct io_st {
	double stop_time ;	// DA channels decay to ~1% in
				// stop_time seconds.
	struct joints_st act_sign ;	 // use to make sure + ==> CCW
	struct joints_st act_offset ;// add these volts to spool positon
	struct joints_st enc_sign ;	 // use to make sure + ==> CCW
	struct joints_st enc_offset ;// add this to the encoder, in +CCW coords.
	int MONITOR ;		// if nonzero, print out I/O stuff in t2.c
} ;

struct ad_st {
	double gain ; 		// gain of board, in Volts/count
	double rate ;		// cycle rate, Hertz 
	int first_chan ; 	// first A/D channel number (probably 0)	
	int num_chan ;		// how many A/D channels to sample	
	double burst_rate ;  	// burst rate, Hertz (maximum value is 500k)
} ;


struct limit_st {
	double max_enc[4] ;	// max and minimum encoder values
	double min_enc[4] ;	
	double max_enc_rate[4] ;// fastest encoder rate
	int emergency_channel ;	// big red panic button channel -->
	double emergency_minV ;	// If voltage is less than this
				// value, shutdown follows.
} ;

struct logger_st {
	int rows ;		// size of storage matrix; make rows small to
	int cols ;		//       limit writing activity
	int write_skip ;	// how many time steps between writing (>0)

	int pressure_chan ;	// first channel of pressure voltages
	int bailuff_chan ;	// first channel of bailuff voltages
	int accel_chan ;	// first channel of accelerometer voltages
} ;

/* h is everything to do with hardware and lowest-level control */

struct h_st {
	struct io_st io ; 
	struct ad_st ad ; 
	struct limit_st limit ;
	struct logger_st logger ;
} ;

//------------------------------------------------------------

#include <sys/proxy.h>
#include <sys/osinfo.h>
#include <sys/seginfo.h>
#include <sys/kernel.h>
#include <sys/irqinfo.h>
#include <errno.h>
#include <sys/trace.h>
#include <sys/tracecod.h>
#include <signal.h>
#include "64bit.h"

#include <stdio.h>
#include <conio.h>
#include <math.h>

#include "/rtd6420_2/drvr6420.h"
#include "/rtd6420_2/dio5812.h"

#define DM6810 928 	// base address for first DM6810 
#define DM6810_2 992 	// base address for second DM6810 
#define DM6420 800 	// base address for first DM6420
#define DM6420_2 896 	// base address for second DM6420

#define PI 3.14159265359

// Randy Martin's timing stuff for t2.c ----------------------
// HIGHEST_PRIORITY was 30.  Reset to 10 for a test by aab

#define RTD_IRQ 11 
#define MYCODE _TRACE_TEMPORARY
#define NORMAL_PRIORITY      10
#define HIGHEST_PRIORITY     28
#define NANOS_PER_SEC    1000000000
#define MICROS_PER_SEC   1000000
#define MILLIS_PER_SEC   1000

double unwrap(double) ;  

