/* 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * (C) Hwang chi-deok 1997, 1998
 *
 */
#include <gtk/gtkcontainer.h>
#include <gtk/gtkmain.h>
#include "anipixmap.h"


static void ani_pixmap_class_init (AniPixmapClass  *klass);
static void ani_pixmap_init       (AniPixmap       *pixmap);
static gint ani_pixmap_expose     (GtkWidget       *widget,
				   GdkEventExpose  *event);


GtkType
ani_pixmap_get_type ()
{
  static GtkType pixmap_type = 0;

  if (!pixmap_type)
    {
      static const GtkTypeInfo pixmap_info =
      {
	"AniPixmap",
	sizeof (AniPixmap),
	sizeof (AniPixmapClass),
	(GtkClassInitFunc) ani_pixmap_class_init,
	(GtkObjectInitFunc) ani_pixmap_init,
	NULL, NULL, NULL
      };

      pixmap_type = gtk_type_unique (gtk_misc_get_type (), &pixmap_info);
    }

  return pixmap_type;
}

static void
ani_pixmap_class_init (AniPixmapClass *class)
{
  GtkWidgetClass *widget_class;

  widget_class = (GtkWidgetClass*) class;

  widget_class->expose_event = ani_pixmap_expose;
}

static void
ani_pixmap_init (AniPixmap *pixmap)
{
  GTK_WIDGET_SET_FLAGS (pixmap, GTK_NO_WINDOW);

  pixmap->running = FALSE;
  pixmap->clear = TRUE;
}

GtkWidget*
ani_pixmap_new (GList *itemlist)
{
  AniPixmap *pixmap;
  GdkPixmap *firstpixmap;
  int width, height;

  g_return_val_if_fail (itemlist != NULL, NULL);

  pixmap = gtk_type_new (ani_pixmap_get_type ());
  pixmap->grim = itemlist;
  pixmap->current = itemlist;
  firstpixmap = ((AniItem *)itemlist->data)->pixmap;
  gdk_window_get_size (firstpixmap, &width, &height);
  GTK_WIDGET (pixmap)->requisition.width = width + GTK_MISC (pixmap)->xpad * 2;
  GTK_WIDGET (pixmap)->requisition.height = height + GTK_MISC (pixmap)->ypad * 2;

  return GTK_WIDGET (pixmap);
}

GList *
ani_pixmap_get (AniPixmap  *pixmap)
{
  g_return_val_if_fail (pixmap != NULL, NULL);
  g_return_val_if_fail (GTK_IS_ANI_PIXMAP (pixmap), NULL);

  return pixmap->grim;
}


static gint
ani_pixmap_expose (GtkWidget      *widget,
		   GdkEventExpose *event)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GtkMisc *misc;
  gint x, y;

  g_return_val_if_fail (widget != NULL, FALSE);
  g_return_val_if_fail (GTK_IS_ANI_PIXMAP (widget), FALSE);
  g_return_val_if_fail (event != NULL, FALSE);

  if (GTK_WIDGET_DRAWABLE (widget))
    {
      pixmap = ((AniItem *)ANI_PIXMAP (widget)->current->data)->pixmap;
      mask = ((AniItem *)ANI_PIXMAP(widget)->current->data)->mask;
      misc = GTK_MISC (widget);

      x = (widget->allocation.x * (1.0 - misc->xalign) +
	   (widget->allocation.x + widget->allocation.width
	   - (widget->requisition.width - misc->xpad * 2)) *
	   misc->xalign) + 0.5;
      y = (widget->allocation.y * (1.0 - misc->yalign) +
	   (widget->allocation.y + widget->allocation.height
	   - (widget->requisition.height - misc->ypad * 2)) *
	   misc->yalign) + 0.5;

      if (mask)
	{
	  gdk_gc_set_clip_mask (widget->style->black_gc, mask);
	  gdk_gc_set_clip_origin (widget->style->black_gc, x, y);
	}

      gdk_draw_pixmap (widget->window,
		       widget->style->black_gc,
		       pixmap,
		       0, 0, x, y, -1, -1);

      if (mask)
	{
	  gdk_gc_set_clip_mask (widget->style->black_gc, NULL);
	  gdk_gc_set_clip_origin (widget->style->black_gc, 0, 0);
	}
    }

  return FALSE;
}

int
ani_run(AniPixmap *pixmap)
{
  AniItem *item;
  GtkWidget *w;
  g_return_val_if_fail (pixmap != NULL, FALSE);
  g_return_val_if_fail (GTK_IS_ANI_PIXMAP (pixmap), FALSE);

  w = GTK_WIDGET(pixmap);
  pixmap->current = pixmap->current->next;
  if(pixmap->current == NULL) pixmap->current = pixmap->grim;
  item = pixmap->current->data;
  if(pixmap->running && item->duration > 0) 
      gtk_timeout_add(item->duration, (GtkFunction)ani_run, pixmap);
  if(pixmap->clear)
    gdk_window_clear_area(w->window, w->allocation.x, w->allocation.y,
						  w->allocation.width, w->allocation.height);
  gtk_widget_draw(GTK_WIDGET(pixmap), NULL);
  return FALSE;
}

void
ani_start(AniPixmap *pixmap)
{
  g_return_if_fail (pixmap != NULL);
  g_return_if_fail (GTK_IS_ANI_PIXMAP (pixmap));

  if(pixmap->running) return;
  pixmap->running = TRUE;
  ani_run(pixmap);
}

void
ani_stop(AniPixmap *pixmap)
{
  g_return_if_fail (pixmap != NULL);
  g_return_if_fail (GTK_IS_ANI_PIXMAP (pixmap));

  pixmap->running = FALSE;
}

void
ani_toggle(AniPixmap *pixmap)
{
  g_return_if_fail (pixmap != NULL);
  g_return_if_fail (GTK_IS_ANI_PIXMAP (pixmap));

  if(pixmap->running)
    {
      pixmap->running = FALSE;
    }
  else
    {
      pixmap->running = TRUE;
      ani_run(pixmap);
    }
}
