/* this file is a part of gau software, (C) Hwang chi-deok 1997, 1998, 1999    */

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "ansiterm.h"
#include "gau.h"


static void scroll_mode_key_press(AnsiTerm *term, GdkEventKey *ev);
int crlf = 0;
static void scroll_mode_page_up(AnsiTerm *);
static void scroll_mode_page_down(AnsiTerm *);

static void
scroll_up(AnsiTerm *term)
{
	scroll_mode_page_up(term);
}

void
keymap_init(AnsiTerm *term)
{
	KeyMap *keymap;
	keymap = g_new(KeyMap, 1);
	keymap->keyval = GDK_Page_Up;
	keymap->state = GDK_SHIFT_MASK;
	keymap->func = (KeyMapFunc)scroll_up;
	keymap->data = term;
	term->keymap_list = g_list_append(term->keymap_list, keymap);
}

/* Structure to hold escape sequences. */
struct escseq {
  int code;
  char *linux_con;
  char *vt100_app;
  char *ansi;
};

/* Escape sequences for different terminal types. */
static struct escseq vt_keys[] = {
  { GDK_F1,      "[[A", "[11~", "OP" },
  { GDK_F2,      "[[B", "[12~", "OQ" },
  { GDK_F3,      "[[C", "[13~", "OR" },
  { GDK_F4,      "[[D", "[14~", "OS" },
  { GDK_F5,      "[[E", "[15~", "OT" },
  { GDK_F6,      "[17~", "[17~", "OU" },
  { GDK_F7,      "[18~", "[18~", "OV" },
  { GDK_F8,      "[19~", "[19~", "OW" },
  { GDK_F9,      "[20~", "[20~", "OX" },
  { GDK_F10,     "[21~", "[21~", "OY" },
  { GDK_F11,     "[23~", "[23~", "OZ" },
  { GDK_F12,     "[24~", "[24~", "OA" },
  { GDK_Up,      "[A",   "OA",   "[A" },
  { GDK_Left,    "[D",   "OD",   "[D" },
  { GDK_Right,   "[C",   "OC",   "[C" },
  { GDK_Down,    "[B",   "OB",   "[B" },
  { GDK_Home,    "[1~",  "[1~",   "[H" },
  { GDK_End,     "[7~",  "[7~",   "[Y" },
  { GDK_Prior,   "[5~",  "[5~",   "[V" },
  { GDK_Next,    "[6~",  "[6~",   "[U" },
  { GDK_Insert,  "[2~",  "[2~",  "[@"  },
  { GDK_Delete,  "[3~", "[3~",  "\177" },
  { 0,            NULL,   NULL,   NULL }
};

gint
ansi_term_key_press(GtkWidget *w, GdkEventKey *ev)
{
	int i;
	char buf[256];
	GList *list;
	KeyMap *keymap;
	int key;

	AnsiTerm *term;

	if (schat && schat->visible) {
	    gtk_widget_event (GTK_WIDGET(schat->chat), (GdkEvent *)ev);
	    gtk_widget_grab_focus (GTK_WIDGET(schat->chat));
	    return TRUE;
	}

	term = ANSI_TERM(w);

	/* check gau is in scroll mode */
	if (term->real_visible_line_begin != term->visible_line_begin) {
		scroll_mode_key_press(term, ev);
		return TRUE;
	}


	list = term->keymap_list;
	key = ev->keyval;
	if (key >= GDK_Shift_L && key <= GDK_Alt_R) return FALSE;
	/* check if this event is mapped */
	while (list) {
		keymap = (KeyMap *)(list->data);
		if (key == keymap->keyval) {
			if (ev->state & keymap->state) {
				(*(keymap->func))(keymap->data);
				return TRUE;
			}
		}
		list = list->next;
	}
	if ((ev->state & (GDK_MOD1_MASK | GDK_MOD4_MASK)) && (ev->length == 1)) {
		buf[0] = ESC;
		buf[1] = ev->string[0];
		term->from_term(buf, 2);
		return TRUE;
	} else if (key == GDK_Return) {
		if (crlf == 0) {
			buf[0] = '\r';
			term->from_term( buf, 1);
		} else if (crlf == 2) {
			buf[0] = '\n';
			term->from_term( buf, 1);
		} else if (crlf == 1) {
			buf[0] = '\r';
			buf[1] = '\n';
			term->from_term (buf, 2);
		}
	} else if (key == GDK_BackSpace) {
		buf[0] = '\b';
		term->from_term(buf, 1);
	} else if (key == GDK_Tab) {
		buf[0] = '\t';
		term->from_term(buf, 1);
	} else if (key == GDK_Escape) {
		buf[0] = ESC;
		term->from_term(buf, 1);
	} else if (ev->length > 0) {
		term->from_term(ev->string, ev->length);
	} else {
		for (i = 0; vt_keys[i].code; i++) {
			if (vt_keys[i].code == key) {
				if(term->mode & CUR_APL) g_snprintf(buf, sizeof(buf), "%c%s", ESC, vt_keys[i].vt100_app);
				else g_snprintf(buf, sizeof(buf), "%c%s", ESC, vt_keys[i].linux_con);
				term->from_term( buf, strlen(buf));
				break;
			}
		}
		if (!vt_keys[i].code) return FALSE;
	}
	return TRUE; /* eat event */
}

static void
scroll_mode_page_up(AnsiTerm *term)
{
    if (((int)term->adjustment->value) == 0) return;
    term->adjustment->value -= term->row;
    if (term->adjustment->value < 0) term->adjustment->value = 0;
    gtk_signal_emit_by_name(GTK_OBJECT(term->adjustment), "value_changed");
}

static void
scroll_mode_end(AnsiTerm *term)
{
	term->adjustment->value = term->adjustment->upper - term->row;
	gtk_signal_emit_by_name(GTK_OBJECT(term->adjustment), "value_changed");
}

static void
scroll_mode_page_down(AnsiTerm *term)
{
    if (term->adjustment->value == (term->adjustment->upper - term->row)) return;
    term->adjustment->value += term->row;
    if (term->adjustment->value > (term->adjustment->upper - term->row)) 
	    term->adjustment->value = term->adjustment->upper - term->row;
    gtk_signal_emit_by_name(GTK_OBJECT(term->adjustment), "value_changed");
}

static void
scroll_mode_line_up(AnsiTerm *term)
{
    if (((int)term->adjustment->value) == 0) return;
    term->adjustment->value--;
    if (term->adjustment->value < 0) term->adjustment->value = 0;
    gtk_signal_emit_by_name(GTK_OBJECT(term->adjustment), "value_changed");
}

static void
scroll_mode_line_down(AnsiTerm *term)
{
    if (term->adjustment->value == (term->adjustment->upper - term->row)) return;
    term->adjustment->value++;
    if (term->adjustment->value > (term->adjustment->upper - term->row)) 
	term->adjustment->value = term->adjustment->upper - term->row;
    gtk_signal_emit_by_name(GTK_OBJECT(term->adjustment), "value_changed");
}

static void
scroll_mode_key_press(AnsiTerm *term, GdkEventKey *ev)
{
    switch(ev->keyval) {
	case GDK_Up: case GDK_KP_Up: scroll_mode_line_up(term); break;
	case GDK_Down: case GDK_KP_Down: scroll_mode_line_down(term); break;
	case GDK_Page_Up: case GDK_KP_Page_Up: scroll_mode_page_up(term); break;
	case GDK_Page_Down: case GDK_KP_Page_Down: scroll_mode_page_down(term); break;
	case GDK_space: case GDK_Return: case GDK_Escape: scroll_mode_end(term); break;
    }
}


