
/* this file is a part of gau software, (C) Hwang chi-deok 1997, 1998         */

#include <string.h>		/* strncmp */
#include <ctype.h>		/* isdigit */

#include "gau.h"
#include "config.h"

enum {
    SIMPLE_STRING, SIMPLE_SCRIPT, COMPLEX_STRING, COMPLEX_SCRIPT
};
typedef struct {
    int type;
    guchar *string;
    int len;
} AutoResponse;

Auto *inouts = NULL;
int n_inout = 0;

static int output_ar(guchar * src, int size, GList * iinfo, GList * rinfo, int type);
static char *transform_string(guchar * s, guchar ** des);

static inline int is_substring(register guchar * h, int size, guchar * str, int msize, int *jm)
{
    register int j;
    guchar *hend;
    if (size < msize)
	return 0;
    hend = h + size;
    h += msize - 1;
    do {
	j = jm[*h];
	if (j == 0) {
	    switch (j = jm[*(h - 1)]) {
	    case 1:
	    case 0:
		if (strncmp(h - msize + 1, str, msize) == 0)
		    return 1;
		h++;
		break;
	    default:
		h += j - 1;
		break;
	    }
	} else {
	    h += j;
	}
    } while (h < hend);
    return 0;
}


void prepare_jm(int msize, guchar * str, int *jm)
{
    int i;
    for (i = 0; i < 256; i++)
	jm[i] = msize;
    for (i = 0; i < msize; i++) {
	jm[str[i]] = msize - i - 1;
    }
}


int auto_response_check(guchar * str, int size)
{
    int i;
    Auto *inout = inouts;
    int result = FALSE;
    //write(1, str, size);
    //write(1, "\n", 1);
    //printf("n_inout = %d\n", n_inout);

    for (i = 0; i < n_inout; i++) {
	if (inout->active && is_substring(str, size, inout->lpattern, inout->llen, inout->jm)) {
	    switch (inout->type) {
	    case COMPLEX_SCRIPT:
	    case COMPLEX_STRING:
		result = output_ar(str, size,
				inout->ilist, inout->olist, inout->type);
		break;
	    case SIMPLE_SCRIPT:
		result = TRUE;
		run_script_from_string((char *) inout->olist);
		break;
	    case SIMPLE_STRING:
		result = TRUE;
		term->from_term((char *) inout->olist, strlen((char *) inout->olist));
		break;
	    }
	    if (result)
		return TRUE;
	}
	inout++;
    }
    return FALSE;
}


int pattern_remain(GList * item)
{
    AutoResponse *p;
    if (item->next == NULL)
	return FALSE;
    item = item->next;
    while (item) {
	p = item->data;
	if (p->type == 0)
	    return TRUE;
	item = item->next;
    }
    return FALSE;
}


static int output_ar(guchar * src, int size, GList * iinfo, GList * rinfo, int type)
{
    char name[5][20];
    char buf[1024];
    char tmpbuf[1024];
    char *s;
    char *old_s;
    char *di;
    AutoResponse *pattern = NULL;
    int index;

    memcpy(buf, src, size);
    buf[size] = 0;

    index = -1;
    while (iinfo) {
	pattern = iinfo->data;
	if (pattern->type == 0)
	    break;
	else
	    index = pattern->type;
	iinfo = iinfo->next;
    }
    if (pattern == NULL) return FALSE;
    s = old_s = buf;
    while (*s && iinfo) {
	s = strstr(s, pattern->string);
	if (s == NULL)
	    return FALSE;
	if (index > 0) {
	    di = name[index - 1];
	    memmove(di, old_s, s - old_s);
	    di[s - old_s] = 0;
	}
	s += strlen(pattern->string);
	old_s = s;

	iinfo = iinfo->next;
	while (iinfo) {
	    pattern = iinfo->data;
	    if (pattern->type == 0)
		break;
	    else
		index = pattern->type;
	    iinfo = iinfo->next;
	}
    }
    s = tmpbuf;
    while (rinfo) {
	pattern = rinfo->data;
	if (pattern->type == 0) {
	    if (type == COMPLEX_STRING)
		term->from_term(pattern->string, strlen(pattern->string));
	    else
		s = strcpy(s, pattern->string) + strlen(pattern->string);
	} else {
	    if (type == COMPLEX_STRING)
		term->from_term(name[pattern->type - 1], strlen(name[pattern->type - 1]));
	    else
		s = strcpy(s, name[pattern->type - 1]) + strlen(name[pattern->type - 1]);
	}
	rinfo = rinfo->next;
    }
    /*g_print("script:%s\n", tmpbuf); */
    if (type)
	run_script_from_string(tmpbuf);
    return TRUE;
}

void auto_response_prepare(void)
{
    char *filename;
    guchar p_buf[100] = {0};
    FILE *fp;
    Auto *inout;
    GList *input_list, *output_list;
    AutoResponse *input;
    //int n;
    guchar *s, *buf, *p;
    filename = g_strconcat (expand_path(gau_path), "/auto-response", NULL);
    fp = fopen(filename, "r");
    g_free (filename);
    if (fp == NULL) {
	//g_warning("can't open auto_response data file");
	return;
    }
    // check # of pattern
    n_inout = 0;
    while ((buf = get_line(fp)) != NULL) {
	n_inout++;
    }
    // check whether file is empty
    if (n_inout == 0)
	return;

    // alloc the neccesary memory for pattern;
    inouts = g_new(Auto, n_inout);

    // reread the file
    rewind(fp);
    //n = 0;
    inout = inouts;
    while ((buf = get_line(fp)) != NULL) {
	if (strncmp(buf, "off", 3) == 0) {
	    inout->active = FALSE;
	    s = eat_space(buf + 3);
	} else if (strncmp(buf, "on", 2) == 0) {
	    inout->active = TRUE;
	    s = eat_space(buf + 2);
	} else {
	    inout->active = TRUE;
	    s = buf;
	}
	inout->raw = g_strdup(s);
	while (*s) {
	    if (*s == '%' && isdigit(*(s + 1))) {
		break;
	    }
	    s++;
	}
	if (*s == '%') {
	    // complex pattern;

	    p = p_buf;
	    *p = 0;
	    input_list = NULL;
	    output_list = NULL;

	    // extract input pattern information

	    s = strchr(buf, '"') + 1;
	    //g_print("inputpattern: %s\n", s);
	    while (1) {
		if (*s == '%' && isdigit(*(s + 1))) {
		    if (p_buf[0] != 0) {
			input = g_new(AutoResponse, 1);
			input->type = 0;
			*p = 0;
			transform_string(p_buf, &input->string);
			input_list =
			    g_list_append(input_list, input);
			//g_print("input: %s\n", input->string);
		    }
		    input = g_new(AutoResponse, 1);
		    input->type = *(s + 1) - '0';
		    s += 2;
		    p = p_buf;
		    *p = 0;
		    input_list =
			g_list_append(input_list, input);
		} else if (*s == '"') {
		    // end of input pattern
		    if (p_buf[0] != 0) {
			input = g_new(AutoResponse, 1);
			input->type = 0;
			*p = 0;
			transform_string(p_buf, &input->string);
			input_list =
			    g_list_append(input_list, input);
			//g_print("input: %s\n", input->string);
		    }
		    s++;
		    break;
		} else if (*s == '\\') {
		    *p++ = *s++;
		    *p++ = *s++;
		} else {
		    *p++ = *s++;
		}
	    }

	    inout->ilist = input_list;

	    {
		GList *list = input_list;
		inout->llen = 0;
		//g_print("starti%d: ", nc);
		while (list) {
		    input = list->data;
		    if (input->type == 0) {
			if (inout->llen < strlen(input->string)) {
			    inout->lpattern = input->string;
			    inout->llen = strlen(input->string);
			}
			//g_print("%s\n", input->string);
			break;
		    }
		    list = list->next;
		}
	    }


	    // extract output pattern information
	    s = eat_space(s);
	    if (*s == '"') {
		s++;
		inout->type = COMPLEX_STRING;
	    } else {
		inout->type = COMPLEX_SCRIPT;
	    }
	    //g_print("%d: %d\n", auto_complex_type[nc], nc);
	    p = p_buf;
	    *p = 0;
	    while (1) {
		if (*s == '%' && isdigit(*(s + 1))) {
		    if (p_buf[0] != 0) {
			input = g_new(AutoResponse, 1);
			input->type = 0;
			*p = 0;
			if (inout->type) {
			    input->string = g_strdup(p_buf);
			} else
			    transform_string(p_buf, &input->string);
			output_list =
			    g_list_append(output_list, input);
			//g_print("output: %s\n", input->string);
		    }
		    input = g_new(AutoResponse, 1);
		    input->type = *(s + 1) - '0';
		    s += 2;
		    p = p_buf;
		    *p = 0;
		    output_list =
			g_list_append(output_list, input);
		} else if (*s == 0 || (inout->type == 0 && *s == '"')) {
		    // end of output pattern
		    if (p_buf[0] != 0) {
			input = g_new(AutoResponse, 1);
			input->type = 0;
			*p = 0;
			if (inout->type) {
			    input->string = g_strdup(p_buf);
			} else
			    transform_string(p_buf, &input->string);
			output_list =
			    g_list_append(output_list, input);
			//g_print("output: %s\n", input->string);
		    }
		    break;
		} else if (*s == '\\') {
		    *p++ = *s++;
		    *p++ = *s++;
		} else {
		    *p++ = *s++;
		}
	    }
	    inout->olist = output_list;
	} else {
	    // input pattern parsing
	    s = strchr(buf, '"') + 1;
	    s = transform_string(s, &inout->lpattern);
	    inout->llen = strlen(inout->lpattern);
	    prepare_jm(inout->llen, (guchar *) inout->lpattern, inout->jm);
	    // output string parsing
	    s = eat_space(s + 1);
	    if (*s == '"') {
		inout->type = SIMPLE_STRING;
		s++;
		transform_string(s, (guchar **) & inout->olist);
	    } else {
		inout->type = SIMPLE_SCRIPT;
		inout->olist = (GList *) g_strdup(s);
	    }
	}
	inout++;
    }
    fclose(fp);
}

static char *
 transform_string(guchar * s, guchar ** des)
{
    GString *str;

    g_return_val_if_fail (s != NULL, NULL);
    g_return_val_if_fail (des != NULL, NULL);

    str = g_string_new (NULL);

    while (*s && *s != '"') {
	if (*s == '\\') {
	    s++;
	    if (*s == 'r') {
		g_string_append_c (str, '\r');
		s++;
	    } else if (*s == 't') {
		g_string_append_c (str, '\t');
		s++;
	    } else if (*s == 'n') {
		g_string_append_c (str, '\n');
		s++;
	    } else
		g_string_append_c (str, *s++);
	} else
	    g_string_append_c (str, *s++);
    }
    *des = str->str;
    g_string_free (str, FALSE);
    return s;
}

static void
all_select_cb (GtkWidget *w, GtkCList *list)
{
    int i;
    for (i = 0; i < n_inout; i++) 
    	gtk_clist_select_row (list, i, -1);
}

static void
all_unselect_cb (GtkWidget *w, GtkCList *list)
{
    int i;
    for (i = 0; i < n_inout; i++) 
    	gtk_clist_unselect_row (list, i, -1);
}

static void
select_row_cb (GtkWidget *w, int row, int col, GdkEventButton *bevent, gpointer data)
{
    if (data)
    	inouts[row].active = TRUE;
    else
    	inouts[row].active = FALSE;
}

void
ar_setup_cb(GtkWidget *w)
{
    static GtkWidget *win = NULL;
    GtkWidget *list;
    GtkWidget *sc;

    GtkWidget *vbox;
    GtkWidget *hbox;
    GtkWidget *close_button;
    GtkWidget *all_select_button;
    GtkWidget *all_unselect_button;
    int i;
    char *titles[3] = { "Է", "  ", ""};

    if (win) {
	gdk_window_raise (win->window);
	return;
    }
    win = gtk_window_new (GTK_WINDOW_DIALOG);
    gtk_window_set_position (GTK_WINDOW (win), GTK_WIN_POS_CENTER);
    gtk_window_set_transient_for(GTK_WINDOW(win), GTK_WINDOW(main_win));
    gtk_window_set_title (GTK_WINDOW (win), "ڵ ");
    gtk_signal_connect (GTK_OBJECT (win), "destroy",
    			GTK_SIGNAL_FUNC (gtk_widget_destroyed), &win);
    gtk_container_set_border_width (GTK_CONTAINER (win), 5);

    vbox = gtk_vbox_new (FALSE, 5);
    gtk_container_add (GTK_CONTAINER (win), vbox);

    sc = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(sc), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    gtk_container_add (GTK_CONTAINER(vbox), sc);

    list = gtk_clist_new_with_titles (3, titles);
    gtk_clist_column_titles_passive (GTK_CLIST (list));
    gtk_clist_set_shadow_type (GTK_CLIST (list), GTK_SHADOW_ETCHED_OUT);
    gtk_widget_set_usize (list, 500, 250);
    gtk_clist_set_column_width (GTK_CLIST (list), 0, 180);
    gtk_clist_set_column_width (GTK_CLIST (list), 1, 40);
    gtk_clist_set_column_justification (GTK_CLIST (list), 0, GTK_JUSTIFY_LEFT);
    gtk_clist_set_column_justification (GTK_CLIST (list), 1, GTK_JUSTIFY_CENTER);
    gtk_clist_set_column_justification (GTK_CLIST (list), 2, GTK_JUSTIFY_LEFT);
    gtk_clist_set_selection_mode (GTK_CLIST (list), GTK_SELECTION_MULTIPLE);
    gtk_signal_connect (GTK_OBJECT (list), "select_row",
    			GTK_SIGNAL_FUNC (select_row_cb), GINT_TO_POINTER(1));
    gtk_signal_connect (GTK_OBJECT (list), "unselect_row",
    			GTK_SIGNAL_FUNC (select_row_cb), GINT_TO_POINTER(0));

    for (i = 0; i < n_inout; i++) {
	char *inout[3];
	char *s, *str;
	str = g_strdup (inouts[i].raw);
	s = strchr (str + 1, '"');
	*s = 0;
	inout[0] = str + 1;
	inout[1] = "=>";
	inout[2] = eat_space (s + 1);
	gtk_clist_append (GTK_CLIST (list), inout);
	g_free (str);
	if (inouts[i].active)
	    gtk_clist_select_row (GTK_CLIST (list), i, -1);
    }

    gtk_container_add (GTK_CONTAINER (sc), list);

    hbox = gtk_hbox_new (TRUE, 5);
    gtk_box_pack_end (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

    all_select_button = gtk_button_new_with_label (" ");
    gtk_container_add (GTK_CONTAINER (hbox), all_select_button);
    gtk_signal_connect (GTK_OBJECT (all_select_button), "clicked",
    			GTK_SIGNAL_FUNC (all_select_cb), list);

    all_unselect_button = gtk_button_new_with_label (" ");
    gtk_container_add (GTK_CONTAINER (hbox), all_unselect_button);
    gtk_signal_connect (GTK_OBJECT (all_unselect_button), "clicked",
    			GTK_SIGNAL_FUNC (all_unselect_cb), list);

    close_button = gtk_button_new_with_label ("ݱ");
    gtk_container_add (GTK_CONTAINER (hbox), close_button);
    gtk_signal_connect (GTK_OBJECT (close_button), "clicked",
    			GTK_SIGNAL_FUNC (destroy_top_level), NULL);

    gtk_widget_show_all (win);
}
