
/* this file is a part of gau software, (C) Hwang chi-deok 1997, 1998         */

#include <gtk/gtk.h>
#include <string.h>
#include <ctype.h>
#include "config.h"
#include "ansiterm.h"
#include "gau.h"


typedef struct _BottomMenuInfo BottomMenuInfo;
struct _BottomMenuInfo {
    char *filename;
    GtkWidget *menu;
};

typedef struct {
    GtkWidget *button;
    GtkWidget *menu;
} BookMark;

BookMark *bookmark_menu_new(FILE * fp);

TelnetInfo *telnetinfo = NULL;
GList *telnetinfo_list = NULL;
GList *bottom_menu_list = NULL;

static void str_button_callback(GtkWidget * w, char *str);
static void main_bottom_callback(GtkWidget * w, char *str);
static void telnet_bottom_callback(GtkWidget * w, TelnetInfo * telnetinfo);
GtkWidget *main_telnet_bottom_menu_create(char *filename);
static gint bookmark_show(GtkWidget * w, GdkEventButton *bevent, BookMark * bookmark);
GtkWidget *read_site_menu_from_file(char *filename);
static void script_button_callback(GtkWidget * w, char *s);

GtkWidget *
main_bottom_menu_create(char *filename)
{
    GtkWidget *hbox;
    GtkWidget *button;
    FILE *fp;
    char *buf;
    char **main_bottom_label;
    int number;

    if (!use_modem) {
	return main_telnet_bottom_menu_create(filename);
    }
    fp = fopen(filename, "r");
    if (fp == NULL) {
	g_warning("ʱ ޴ %s  ϴ.", filename);
	return NULL;
    }
    hbox = gtk_hbox_new(FALSE, 4);
    gtk_widget_show(hbox);
    gtk_widget_ref(hbox);
    number = 0;
    while (get_line(fp) != NULL) {
	number++;
    }
    rewind(fp);
    main_bottom_label = g_new(char *, number);
    number = 0;
    while ((buf = get_line(fp)) != NULL) {
	main_bottom_label[number] = g_strdup(buf);
	button = gtk_button_new_with_label(main_bottom_label[number]);
#ifdef GTK_HAVE_FEATURES_1_1_0
	gtk_button_set_relief (GTK_BUTTON(button), GTK_RELIEF_NONE);
#endif
	GTK_WIDGET_UNSET_FLAGS(button, GTK_CAN_FOCUS);
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 2);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(main_bottom_callback),
			   main_bottom_label[number]);
	number++;
	gtk_widget_show(button);
    }
    return hbox;
}

GtkWidget *
main_telnet_bottom_menu_create(char *filename)
{
    FILE *fp;
    GtkWidget *hbox;
    GtkWidget *button;
    TelnetInfo *telnetinfo;
    char *buf;

    fp = fopen(filename, "r");
    if (fp == NULL)
	return NULL;
    hbox = gtk_hbox_new(FALSE, 4);
    while ((buf = get_line(fp)) != NULL) {
	telnetinfo = g_new(TelnetInfo, 1);
	telnetinfo->name = g_strdup(strtok(buf, "; \t:"));
	telnetinfo->host = g_strdup(strtok(NULL, "; \t:"));
	telnetinfo->port = g_strdup(strtok(NULL, "; \t:"));
	telnetinfo->script_file = g_strdup(strtok(NULL, "; \t:"));
	button = gtk_button_new_with_label(telnetinfo->name);
#ifdef GTK_HAVE_FEATURES_1_1_0
	gtk_button_set_relief (GTK_BUTTON(button), GTK_RELIEF_NONE);
#endif
	GTK_WIDGET_UNSET_FLAGS(button, GTK_CAN_FOCUS);
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 2);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(telnet_bottom_callback),
			   telnetinfo);
	gtk_widget_show(button);
	telnetinfo_list = g_list_append(telnetinfo_list, telnetinfo);
    }
    gtk_widget_show(hbox);
    return hbox;
}

BookMark *
bookmark_menu_new(FILE * fp)
{
    BookMark *bookmark = g_new(BookMark, 1);
    guchar *s, *buf;
    GtkWidget *menu;
    char *name;
    gpointer data;
    menu = gtk_menu_new ();
    while ((buf = get_line(fp)) != NULL) {

	s = buf = eat_space(buf);
	while (!isspace(*s))
	    s++;
	*s = 0;
	name = g_strdup(buf);
	s = eat_space(s + 1);
	if (*s == '"') {
	    buf = s + 1;
	    s = strchr(buf, '"');
	    if (s == NULL) {
		g_warning("parsing error in bookmark");
		continue;
	    }
	} else {
	    buf = s;
	    while (!isspace(*s) && *s != 0)
		s++;
	}
	*s = 0;
	data = g_strconcat ("go ", buf, "\r", NULL);
	add_menu_item(menu, name, str_button_callback, data);
    }
    bookmark->menu = menu;
    {
	GtkWidget *button, *label, *hbox, *arrow;
	button = gtk_button_new();
	hbox = gtk_hbox_new(FALSE, 1);
	arrow = gtk_arrow_new(GTK_ARROW_DOWN, GTK_SHADOW_OUT);
	label = gtk_label_new("ܰ ");
	gtk_box_pack_start(GTK_BOX(hbox), arrow, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 4);
	gtk_widget_show_all(hbox);
	gtk_container_add(GTK_CONTAINER(button), hbox);
	bookmark->button = button;
    }
    GTK_WIDGET_UNSET_FLAGS(bookmark->button, GTK_CAN_FOCUS);
    return bookmark;
}

static gint 
bookmark_show(GtkWidget * w, GdkEventButton *bevent, BookMark * bookmark)
{
    gtk_signal_emit_stop_by_name (GTK_OBJECT (w), "button_press_event");
    gtk_menu_popup(GTK_MENU(bookmark->menu),
		   NULL, NULL, NULL, NULL, bevent->button, bevent->time);
    return TRUE;
}

static void 
str_button_callback(GtkWidget * w, char *str)
{
    char *s;
    int msec = 0;
    s = strchr(str, '\r');
    if (s == NULL) {
	term->from_term(str, strlen(str));
	return;
    } else
	term->from_term(str, s - str + 1);
    str = s + 1;
    while (*str) {
	msec += 2000;
	s = strchr(str, '\r');
	if (s == NULL) {
	    delayed_transmit(str, strlen(str), msec);
	    break;
	}
	delayed_transmit(str, s - str + 1, msec);
	str = s + 1;
    }
}

static void 
script_button_callback(GtkWidget * w, char *s)
{
    run_script_from_string(s);
}

static GtkWidget *
real_read_site_menu_from_file(char *filename)
{
    GtkWidget *hbox, *button;
    FILE *fp;
    guchar *buf, *s, *p, *string;
    int line = 0, type;
    if (filename == NULL || filename[0] == 0)
	return NULL;
    fp = fopen(filename, "r");
    if (fp == NULL) {
	g_warning("޴ %s  ϴ.", filename);
	return NULL;
    }
    hbox = gtk_hbox_new(FALSE, 4);

    while ((buf = get_line(fp)) != NULL) {
	if (strncmp(buf, "[[ܰ°]]", 14) == 0)
	    break;
	line++;
	if (strncmp(buf, "string", 6) == 0)
	    type = 0;
	else if (strncmp(buf, "pixmap", 6) == 0)
	    type = 1;
	else {
	    continue;
	}
	s = strchr(buf + 6, '"');
	if (s == NULL) {
	    g_warning("parsing error in %d line of %s", line, filename);
	    continue;
	}
	s++;
	p = strchr(s, '"');
	if (p == NULL) {
	    g_warning("parsing error in %d line of %s", line, filename);
	    continue;
	}
	*p = 0;
	if (type == 0) {
	    button = gtk_button_new_with_label(s);
#ifdef GTK_HAVE_FEATURES_1_1_0
	    gtk_button_set_relief (GTK_BUTTON(button), GTK_RELIEF_NONE);
#endif
	    gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 2);
	    gtk_widget_show(button);
	} else {
	    GtkWidget *pixmapwid;
	    GtkStyle *style;
	    GdkPixmap *pixmap;
	    GdkBitmap *mask;
	    button = gtk_button_new();
#ifdef GTK_HAVE_FEATURES_1_1_0
	    gtk_button_set_relief (GTK_BUTTON(button), GTK_RELIEF_NONE);
#endif
	    gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 2);
	    gtk_widget_show(button);
	    style = gtk_widget_get_style(button);
	    pixmap = gdk_pixmap_create_from_xpm(button->window, 
	    					&mask, 
						&style->bg[GTK_STATE_NORMAL], 
						s);
	    pixmapwid = gtk_pixmap_new(pixmap, mask);
	    gtk_container_add(GTK_CONTAINER(button), pixmapwid);
	    gtk_widget_show(pixmapwid);
	}
	GTK_WIDGET_UNSET_FLAGS(button, GTK_CAN_FOCUS);

	s = eat_space(p + 1);
	if (*s == '"') {
	    s++;
	    string = replace_ctl_char (s);
	    gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(str_button_callback), string);
	} else {
	    string = g_strdup(s);
	    gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(script_button_callback), string);
	}
    }
    if (buf != NULL) {
	BookMark *bookmark = bookmark_menu_new(fp);
	if (bookmark != NULL) {
	    gtk_box_pack_end(GTK_BOX(hbox), bookmark->button, FALSE, FALSE, 2);
	    gtk_signal_connect(GTK_OBJECT(bookmark->button), "button_press_event",
			       GTK_SIGNAL_FUNC(bookmark_show), bookmark);
	    gtk_widget_show(bookmark->button);
	}
    }
    fclose(fp);
    return hbox;
}

static void 
telnet_bottom_callback(GtkWidget * w, TelnetInfo * ti)
{
    telnetinfo = ti;
    telnet_connect(telnetinfo->host, telnetinfo->port, telnetinfo->script_file);
}

static void 
main_bottom_callback(GtkWidget * w, char *str)
{
    //g_print("%s\n", __FUNCTION__);
    if (gau_state == GAU_DIAL) {
	dial_cancel();
    }
    phone_win_show();
    phone_check_by_name(str);
    dial_begin();
}

void 
update_bottom_menu_from_file(char *filename)
{
    GtkWidget *new_bottom_menu;

    if (filename && strcmp(filename, "main") == 0) {
	new_bottom_menu = main_bottom_menu;
    } else {
	if (filename == NULL || filename[0] == 0) {
	    new_bottom_menu = NULL;
	} else {
	    char *buf;
	    if (filename[0] != '/') {
		buf = g_strconcat (expand_path(gau_path), "/", filename, NULL);
	    } else {
		buf = g_strdup (filename);
	    }
	    new_bottom_menu = read_site_menu_from_file(buf);
	    g_free (buf);
	}
    }
    if (new_bottom_menu == NULL) {
	gtk_widget_set_sensitive(bottom_frame, FALSE);
	return;
    }
    if (!GTK_WIDGET_IS_SENSITIVE(bottom_frame))
	gtk_widget_set_sensitive(bottom_frame, TRUE);
    if (current_bottom_menu == new_bottom_menu)
	return;
    gtk_widget_ref(current_bottom_menu);
    gtk_container_remove(GTK_CONTAINER(bottom_frame), current_bottom_menu);
    gtk_widget_hide(current_bottom_menu);
    gtk_container_add(GTK_CONTAINER(bottom_frame), new_bottom_menu);
    gtk_widget_show(new_bottom_menu);
    current_bottom_menu = new_bottom_menu;
}

GtkWidget *
read_site_menu_from_file(char *filename)
{
    GList *list;
    GtkWidget *menu;
    BottomMenuInfo *menuitem;

    list = bottom_menu_list;
    while (list) {
	menuitem = list->data;
	if (strcmp(menuitem->filename, filename) == 0) {
	    return menuitem->menu;
	}
	list = list->next;
    }
    menu = real_read_site_menu_from_file(filename);
    if (menu == NULL)
	return NULL;

    gtk_widget_ref(menu);
    menuitem = g_new(BottomMenuInfo, 1);
    menuitem->filename = g_strdup(filename);
    menuitem->menu = menu;
    bottom_menu_list = g_list_append(bottom_menu_list, menuitem);
    return menu;
}
