
/* this file is a part of gau software, (C) Hwang chi-deok 1997-1999        */

#include "config.h"

#include <sys/types.h>
#include <sys/stat.h>

#ifdef HAVE_WAIT_H
#include <sys/wait.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif

#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif

#include <signal.h>

#include <gdk/gdkx.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "mymenubar.h"
#include "anipixmap.h"

#include "ansiterm.h"
#include "gau.h"

typedef struct _Command Command;
struct _Command {
    char *label;
    void (*func) (GtkWidget * w, gpointer data);
    gpointer data;
};

static pid_t editor_pid;
static pid_t shell_pid;
GtkWidget *taegeuk;
GtkWidget *quit_button, *call_button;
GtkWidget *capture_button, *disconnect_after_transfer_button;
GtkWidget *cancel_button, *chat_button;
GtkWidget *write_button;

void capture_cb(GtkWidget * w, gpointer data);
void exit_cb(GtkWidget * w, gpointer data);
void disconnect_after_transfer_toggle_cb(GtkWidget * w, gpointer data);
void modem_attr_cb(GtkWidget * w, gpointer data);
void screen_save_cb(GtkWidget * w, gpointer data);
void chat_cb(GtkWidget * w, gpointer data);
void cancel_cb(GtkWidget * w, gpointer data);
void etc_menu_create(GtkWidget * w);
void script_menu_create(GtkWidget * box);
void nohang_exit_cb(void);
void screen_reset(void);
void run_scriptfile(GtkWidget * w, char *filename);
void toggle_local_echo(void);
void toggle_auto_response(GtkWidget * w, gpointer index);
void toggle_remote_echo(void);
void give_shell(void);
static void write_cb(GtkWidget * w, gpointer data);
static gint write_fragment(gpointer data);
static void write_signal_child_handler(void);
static void query_script_command(void);
static void set_crlf(GtkWidget * w, gpointer data);


GtkWidget *
add_menu_item (GtkWidget *menu, char *label, GtkSignalFunc func, gpointer data)
{
    GtkWidget *subitem = gtk_menu_item_new_with_label (label);
    gtk_signal_connect (GTK_OBJECT (subitem), "activate", func, data);
    gtk_menu_append (GTK_MENU (menu), subitem);
    gtk_widget_show (subitem);
    return subitem;
}

GtkWidget *
add_check_menu_item (GtkWidget *menu, 
		     char *label, 
		     GtkSignalFunc func, 
		     gpointer data)
{
    GtkWidget *subitem = gtk_check_menu_item_new_with_label (label);
    gtk_signal_connect (GTK_OBJECT (subitem), "activate", func, data);
    gtk_menu_append (GTK_MENU (menu), subitem);
    gtk_widget_show (subitem);
    gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(subitem), *((gboolean *)data));
    return subitem;
}

static GtkWidget *
add_button(GtkWidget * box, char *label, GtkSignalFunc func, gpointer data)
{
    GtkWidget *button = gtk_button_new_with_label(label);
    GTK_WIDGET_UNSET_FLAGS(button, GTK_CAN_FOCUS);
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
		       func, data);
    gtk_box_pack_start(GTK_BOX(box), button, FALSE, FALSE, 0);
    gtk_widget_show(button);
    return button;
}

void
check_menu_cb(GtkWidget *widget, gpointer data)
{
    gboolean *boolp = data;
    *boolp = GTK_CHECK_MENU_ITEM (widget)->active;
}

gint
taegeuk_clicked (GtkWidget *widget, gpointer data)
{
    if (read_fd < 0) return TRUE;
    if (use_modem && !modem_connected()) return TRUE;
    taegeuk_toggle();
    return TRUE;
}

void control_bar(GtkWidget * box)
{
    GtkWidget *button;
    gtk_widget_set_name(box, "control");
    gtk_container_set_border_width(GTK_CONTAINER(box), 3);
    button = gtk_button_new();
    gtk_box_pack_start(GTK_BOX(box), button, FALSE, FALSE, 0);
    taegeuk = ani_pixmap_create(button);
    if (taegeuk) {
	GTK_WIDGET_UNSET_FLAGS(button, GTK_CAN_FOCUS);
	gtk_signal_connect (GTK_OBJECT(button), "clicked",
			    GTK_SIGNAL_FUNC(taegeuk_clicked), NULL);
	((AniPixmap *) taegeuk)->clear = FALSE;
	gtk_container_add(GTK_CONTAINER(button), taegeuk);
    } else {
	gtk_widget_destroy (button);
    }

    quit_button = add_button (box, "", GTK_SIGNAL_FUNC(exit_cb), NULL);
    if (use_modem) {
	if (modem_connected()) {
	    call_button = add_button (box, "ȭ", 
	    			      GTK_SIGNAL_FUNC(dial_cb), NULL);
	} else {
	    call_button = add_button (box, "ȭɱ", 
	                              GTK_SIGNAL_FUNC(dial_cb), NULL);
	}
    } else {
	call_button = add_button (box, "ڳ ", 
				  GTK_SIGNAL_FUNC(dial_cb), NULL);
    }

    capture_button = add_button (box, "", 
    				 GTK_SIGNAL_FUNC(capture_cb), NULL);
    disconnect_after_transfer_button =
	gtk_toggle_button_new_with_label(" ");
    GTK_WIDGET_UNSET_FLAGS(disconnect_after_transfer_button, GTK_CAN_FOCUS);
    gtk_box_pack_start(GTK_BOX(box), disconnect_after_transfer_button,
		       FALSE, FALSE, 0);
    gtk_signal_connect(GTK_OBJECT(disconnect_after_transfer_button), "toggled",
		       GTK_SIGNAL_FUNC(disconnect_after_transfer_toggle_cb), NULL);
    gtk_toggle_button_set_state(
		 GTK_TOGGLE_BUTTON(disconnect_after_transfer_button), FALSE);

    cancel_button = add_button (box, "", GTK_SIGNAL_FUNC(cancel_cb), NULL);
    chat_button = add_button (box, "̾߱⸶", 
    			      GTK_SIGNAL_FUNC(chat_cb), NULL);
    write_button = add_button (box, "۾", GTK_SIGNAL_FUNC(write_cb), NULL);
    script_menu_create(box);
    etc_menu_create(box);

    if ((!use_modem) || !modem_connected()) {
	gtk_widget_set_sensitive(disconnect_after_transfer_button, FALSE);
	gtk_widget_set_sensitive(write_button, FALSE);
    }
}


void capture_cb(GtkWidget * w, gpointer data)
{
    if (capture_fd > 0) {
	end_capture();
    } else {
	begin_capture(capture_file);
    }
}


void hangup_cb(GtkWidget * box, gpointer data)
{
    gau_hangup();
}

void disconnect_after_transfer_toggle_cb(GtkWidget * w, gpointer data)
{
    disconnect_after_transfer = GTK_TOGGLE_BUTTON(w)->active;
}


void exit_cb(GtkWidget * w, gpointer data)
{
    if (gau_state == GAU_DIAL) {
	dial_cancel();
    } else if (use_modem && modem_connected()) {
	modem_hangup();
	modem_check_connected(NULL);
    } else if (!use_modem && telnet_connected()) {
	telnet_hangup();
	telnet_time_report();
    }
    if (use_modem)
	modem_restore();
    gtk_main_quit();
}

void modem_attr_cb(GtkWidget * w, gpointer data)
{
    // FIXME!!
}

void cancel_cb(GtkWidget * w, gpointer data)
{
    switch (gau_state) {
    case GAU_SCRIPT:
	script_cancel();
	show_message("ȥڸ ҵǾϴ");
	break;
    case GAU_DIAL:
	dial_cancel();
	show_message("ȭɱⰡ ҵǾϴ");
	break;
    case GAU_TELNET_DIAL:
	show_message("ڳ  մϴ");
	kill(telnet_pid, SIGKILL);
	break;
    case GAU_DOWNLOAD:
	rz_cancel();
	show_message("ޱⰡ  ҵǾϴ");
	break;
    case GAU_UPLOAD:
	sz_cancel();
	show_message("øⰡ  ҵǾϴ");
	break;
    default:
	show_message("  ־µ");
	break;
    }
}

void screen_save_cb(GtkWidget * w, gpointer data)
{
    char buf[256];
    time_t timep = time(NULL);
    struct tm *lt = localtime(&timep);
    g_snprintf(buf, sizeof(buf), "%s/%02d%02d%02d.scap", expand_path(capture_path),
	    lt->tm_year, lt->tm_mon + 1, lt->tm_mday);
    scapture_fd = open(buf, O_WRONLY | O_CREAT | O_APPEND, 0660);
    if (scapture_fd == -1) {
	g_warning("can't open screen capture file %s", buf);
	return;
    }
    if (!data) screen_save();
    else whole_screen_save ();
}

void write_cb(GtkWidget * w, gpointer data)
{
    char buf[256];
    g_snprintf(buf, sizeof(buf), "%s /tmp/gau%d.txt", editor, getpid());
    editor_pid = fork();
    if (editor_pid == 0) {
	// child
	execlp("sh", "sh", "-c", buf, NULL);
	g_warning("fail to run %s", editor);
	_exit(1);
    }
    child_signal_add(editor_pid, write_signal_child_handler);
    //signal(SIGCHLD, write_signal_child_handler);
}

void write_signal_child_handler(void)
{
    int fd;
    char buf[256];
    g_snprintf(buf, sizeof(buf), "/tmp/gau%d.txt", getpid());
    fd = open(buf, O_RDONLY);
    if (fd < 0) {
	g_warning("fail to read %s", buf);
	return;
    }
    gtk_timeout_add(100, write_fragment, GINT_TO_POINTER(fd));
}

gint
write_fragment(gpointer data)
{
    int fd = GPOINTER_TO_INT(data);
    int size;
    char buf[36];
    size = read(fd, buf, 36);
    if (size > 0) {
	/* change \n to \r */
	if (crlf == 0) {
	    int i;
	    for (i = 0; i < size; i++)
		if (buf[i] == '\n')
		    buf[i] = '\r';
	}
	term->from_term(buf, size);
	return TRUE;
    }
    close(fd);
    show_message("ۺ⸦ ƽϴ");
    g_snprintf(buf, sizeof(buf), "/tmp/gau%d.txt", getpid());
    unlink(buf);
    return FALSE;
}


#include <glob.h>
void script_menu_create(GtkWidget * box)
{
    GtkWidget *menubar, *menu, *menuitem;
    char *filename;
    GtkWidget *menu_hbox, *label, *arrow;
    glob_t globd;
    char *buf;
    int i;

    menubar = my_menu_bar_new();
    gtk_box_pack_start(GTK_BOX(box), menubar, FALSE, TRUE, 0);
    gtk_container_set_border_width(GTK_CONTAINER(menubar), 0);
    gtk_widget_show(menubar);

    menu = gtk_menu_new();


    add_menu_item (menu, "ɾ", GTK_SIGNAL_FUNC(query_script_command), NULL);

    buf = g_strconcat (expand_path(script_path), "/*.scr", NULL);
    if (0 == glob(buf, 0, NULL, &globd)) {
	for (i = 0; i < globd.gl_pathc; i++) {
	    filename = g_strdup(g_basename(globd.gl_pathv[i]));
	    add_menu_item (menu, filename, GTK_SIGNAL_FUNC(run_scriptfile), filename);
	}
	globfree(&globd);
    }
    g_free (buf);
    menuitem = gtk_menu_item_new();
    menu_hbox = gtk_hbox_new(FALSE, 1);
    arrow = gtk_arrow_new(GTK_ARROW_DOWN, GTK_SHADOW_OUT);
    label = gtk_label_new("ȥڸ");
    gtk_box_pack_start(GTK_BOX(menu_hbox), arrow, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(menu_hbox), label, FALSE, FALSE, 4);
    gtk_widget_show(arrow);
    gtk_widget_show(label);
    gtk_widget_show(menu_hbox);
    gtk_container_add(GTK_CONTAINER(menuitem), menu_hbox);
    gtk_container_set_border_width(GTK_CONTAINER(menuitem), 0);
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem), menu);
    gtk_menu_bar_append(GTK_MENU_BAR(menubar), menuitem);
    gtk_widget_show(menuitem);
}


void
auto_rz_toggle_cb (GtkWidget *widget)
{
}


void etc_menu_create(GtkWidget * box)
{
    GtkWidget *menubar, *menu, *subitem, *menuitem;
    GtkWidget *scriptitem, *scriptitems;
    GtkWidget *arrow, *label, *menu_hbox;

    menubar = my_menu_bar_new();
    gtk_box_pack_start(GTK_BOX(box), menubar, FALSE, TRUE, 0);
    gtk_container_set_border_width(GTK_CONTAINER(menubar), 0);
    gtk_widget_show(menubar);


    menu = gtk_menu_new();

    if (n_inout) {
	subitem = gtk_menu_item_new_with_label("ڵ");
	gtk_menu_append(GTK_MENU(menu), subitem);
	gtk_signal_connect(GTK_OBJECT(subitem), "activate",
			   GTK_SIGNAL_FUNC(ar_setup_cb), NULL);
	gtk_widget_show(subitem);
#if 0
	scriptitems = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(subitem), scriptitems);

	for (i = 0; i < n_inout; i++) {
	    char *s = g_strdup(inouts[i].raw);
	    int max_len = 25;
	    if (strlen(s) > max_len) {
		if (is_first_han(s, max_len - 2)) {
		    s[max_len - 3] = '.';
		}
		s[max_len - 2] = '.';
		s[max_len - 1] = '.';
		s[max_len] = 0;
	    }
	    scriptitem = gtk_check_menu_item_new_with_label(s);
	    g_free(s);
	    gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(scriptitem), inouts[i].active);
	    gtk_signal_connect(GTK_OBJECT(scriptitem), "activate",
		    GTK_SIGNAL_FUNC(toggle_auto_response), (gpointer) i);
	    gtk_menu_append(GTK_MENU(scriptitems), scriptitem);
	    gtk_widget_show(scriptitem);
	}
#endif
    }
    subitem = add_check_menu_item (menu, "ǵ",
		       		   GTK_SIGNAL_FUNC(check_menu_cb), &term->auto_linefeed);

    add_menu_item (menu, "ȭ ", GTK_SIGNAL_FUNC(screen_save_cb), NULL);
    add_menu_item (menu, " ȭ ", GTK_SIGNAL_FUNC(screen_save_cb), (gpointer)1);
    add_menu_item (menu, "Ϻ", GTK_SIGNAL_FUNC(run_sz), NULL);
    add_menu_item (menu, "Ϲޱ", GTK_SIGNAL_FUNC(run_rz), NULL);
    add_menu_item (menu, "ȭ ", GTK_SIGNAL_FUNC(screen_reset), NULL);
    add_check_menu_item (menu, "ڵ ޱ", 
			 GTK_SIGNAL_FUNC(check_menu_cb), &auto_rz);
    add_check_menu_item (menu, "ڵ  ø", 
			 GTK_SIGNAL_FUNC(check_menu_cb), &auto_sz);

    add_check_menu_item (menu, " ^M ",
			 GTK_SIGNAL_FUNC(check_menu_cb),
			 &strip_linefeed);

#if 0
    if (use_modem) {
	subitem = gtk_menu_item_new_with_label("1:1 ");
	gtk_menu_append(GTK_MENU(menu), subitem);
	gtk_widget_show(subitem);

	scriptitems = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(subitem), scriptitems);

	// FIXME
	scriptitem = gtk_check_menu_item_new_with_label("ڱ");
	gtk_signal_connect(GTK_OBJECT(scriptitem), "activate",
			   GTK_SIGNAL_FUNC(toggle_local_echo), NULL);
	gtk_menu_append(GTK_MENU(scriptitems), scriptitem);
	gtk_widget_show(scriptitem);
	scriptitem = gtk_check_menu_item_new_with_label("remote echo");
	gtk_signal_connect(GTK_OBJECT(scriptitem), "activate",
			   GTK_SIGNAL_FUNC(toggle_remote_echo), NULL);
	gtk_menu_append(GTK_MENU(scriptitems), scriptitem);
	gtk_widget_show(scriptitem);

	scriptitem = gtk_menu_item_new_with_label("Shell");
	gtk_signal_connect(GTK_OBJECT(scriptitem), "activate",
			   GTK_SIGNAL_FUNC(give_shell), NULL);
	gtk_menu_append(GTK_MENU(scriptitems), scriptitem);
	gtk_widget_show(scriptitem);
    }
#endif
    if (use_modem) {
	add_menu_item (menu, "׳ ", GTK_SIGNAL_FUNC(nohang_exit_cb), NULL);
    }
    if (!use_modem) {
	GSList *group;
	int real_crlf;
	extern int crlf;

	subitem = gtk_menu_item_new_with_label("Enter Key");
	gtk_menu_append(GTK_MENU(menu), subitem);
	gtk_widget_show(subitem);

	scriptitems = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(subitem), scriptitems);

	group = NULL;
	real_crlf = crlf;
	scriptitem = gtk_radio_menu_item_new_with_label(group, "carriage-return");
	gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(scriptitem), (crlf == 0) ? TRUE : FALSE);
	gtk_signal_connect(GTK_OBJECT(scriptitem), "activate",
		       GTK_SIGNAL_FUNC(set_crlf), GINT_TO_POINTER(0));
	group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(scriptitem));
	gtk_menu_append(GTK_MENU(scriptitems), scriptitem);
	gtk_widget_show(scriptitem);

	crlf = real_crlf;
	scriptitem = gtk_radio_menu_item_new_with_label(group, "line-feed");
	gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(scriptitem), crlf == 2 ? TRUE : FALSE);
	gtk_signal_connect(GTK_OBJECT(scriptitem), "activate",
		       GTK_SIGNAL_FUNC(set_crlf), GINT_TO_POINTER(2));
	group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(scriptitem));
	gtk_menu_append(GTK_MENU(scriptitems), scriptitem);
	gtk_widget_show(scriptitem);

	crlf = real_crlf;
	scriptitem = gtk_radio_menu_item_new_with_label(group, "cr and lf");
	gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(scriptitem), crlf == 1 ? TRUE : FALSE);
	gtk_signal_connect(GTK_OBJECT(scriptitem), "activate",
		       GTK_SIGNAL_FUNC(set_crlf), GINT_TO_POINTER(1));
	gtk_menu_append(GTK_MENU(scriptitems), scriptitem);
	gtk_widget_show(scriptitem);
    }
    menuitem = gtk_menu_item_new();
    menu_hbox = gtk_hbox_new(FALSE, 1);
    arrow = gtk_arrow_new(GTK_ARROW_DOWN, GTK_SHADOW_OUT);
    label = gtk_label_new("⵿");
    gtk_box_pack_start(GTK_BOX(menu_hbox), arrow, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(menu_hbox), label, FALSE, FALSE, 2);
    gtk_widget_show(arrow);
    gtk_widget_show(label);
    gtk_widget_show(menu_hbox);
    gtk_container_add(GTK_CONTAINER(menuitem), menu_hbox);
    gtk_container_set_border_width(GTK_CONTAINER(menuitem), 0);
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem), menu);
    gtk_menu_bar_append(GTK_MENU_BAR(menubar), menuitem);
    gtk_widget_show(menuitem);
}


#if 0
void toggle_local_echo(void)
{
    local_echo = !local_echo;
}

void toggle_remote_echo(void)
{
    remote_echo = !remote_echo;
}
#endif

void nohang_exit_cb(void)
{
    extern int modem_sethup(int flag);
    modem_sethup(FALSE);
    _exit(0);
}

void screen_reset(void)
{
    ansi_term_reset(term);
}

void run_scriptfile(GtkWidget * w, char *filename)
{
    char *buf;
    g_return_if_fail(filename != NULL);
    g_return_if_fail(filename[0] != 0);
    if (filename[0] == '/') {
	buf = g_strdup (filename);
    } else {
	buf = g_strconcat (expand_path(script_path), "/", filename, NULL);
    }
    run_script_from_file(buf);
    g_free (buf);
}

static void script_command_ok(GtkWidget * w, GtkEntry *entry)
{
    char *command;
    command = gtk_entry_get_text(entry);
    run_script_from_command(command);
    destroy_top_level(w);
}

void query_script_command(void)
{
    GtkWidget *dialog, *vbox, *hbox, *hse, *button, *label, *entry;

    dialog = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
    vbox = gtk_vbox_new(FALSE, 5);
    gtk_container_add(GTK_CONTAINER(dialog), vbox);
    hbox = gtk_hbox_new(FALSE, 5);
    gtk_container_add(GTK_CONTAINER(vbox), hbox);
    label = gtk_label_new("ɾ:");
    gtk_container_add(GTK_CONTAINER(hbox), label);

    entry = gtk_entry_new();
    gtk_signal_connect(GTK_OBJECT(entry), "activate",
		       GTK_SIGNAL_FUNC(script_command_ok), entry);
    gtk_container_add(GTK_CONTAINER(hbox), entry);

    hse = gtk_hseparator_new();
    gtk_container_add(GTK_CONTAINER(vbox), hse);

    hbox = gtk_hbox_new(FALSE, 10);
    gtk_container_add(GTK_CONTAINER(vbox), hbox);

    button = gtk_button_new_with_label("");
    gtk_object_set_user_data(GTK_OBJECT(button), entry);
    gtk_container_add(GTK_CONTAINER(hbox), button);
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
		       GTK_SIGNAL_FUNC(script_command_ok), entry);

    button = gtk_button_new_with_label("");
    gtk_container_add(GTK_CONTAINER(hbox), button);
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
		       GTK_SIGNAL_FUNC(destroy_top_level), NULL);

    gtk_grab_add(dialog);
    gtk_widget_show_all(dialog);
}


void give_shell(void)
{
    // FIXME
    return;
    shell_pid = fork();
    if (shell_pid == 0) {
	// child
	dup2(read_fd, 0);
	dup2(read_fd, 1);
	dup2(read_fd, 2);
	close(read_fd);
	execlp("sh", "sh", "-c", sh_command, NULL);
	g_warning("fail to run %s", sh_command);
	_exit(1);
    }
}


static void set_crlf(GtkWidget * w, gpointer data)
{
    crlf = GPOINTER_TO_INT(data);
}
