#include <gtk/gtk.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include "config.h"

#include "ansiterm.h"
#include "gau.h"


int ntry = 0;
guint dial_timeout_tag = 0;
guint dial_next_tag = 0;
PhoneInfo pi;

static int current_dial_row = -1;

static gint wait_response_filter(char *buf, int bytes);
static int dial_timeout_cb(gpointer data);
static void dial_current_number(void);
static int dial_install_next_cb(void);
int dial_next(void);

gint
gau_sleep_cb(void)
{
    gtk_main_quit();
    /* remove this callback */
    return FALSE;
}

void
gau_sleep(int msec)
{
    gtk_timeout_add (msec, 
    		     (GtkFunction)gau_sleep_cb, NULL);
    gtk_main();
}

void
dial_cancel(void)
{
    // g_print("%s\n", __FUNCTION__);
    remove_input_filter(wait_response_filter);
    modem_write(cancel_string, strlen(cancel_string));
    if(dial_timeout_tag  > 0) gtk_timeout_remove(dial_timeout_tag);
    ntry = 0;
    dial_timeout_tag = 0;
    if(dial_next_tag > 0) gtk_timeout_remove(dial_next_tag);
    dial_next_tag = 0;
    current_dial_row = -1;
}

static void
monitor_response(void)
{
    // g_print("%s\n", __FUNCTION__);
    register_input_filter(wait_response_filter);
    // initialize the internal buffer used in wait_response_filter
    wait_response_filter(NULL, -1); 
}

gint
wait_response_filter(char *buf, int bytes)
{
    static char response[20];
    static char *p = response;
    int i=0;
    static int log = FALSE;

    if(bytes < 0) {
	// initialize 
	p = response;
	log = FALSE;
	return TRUE;
    }
    //g_print("%s\n", __FUNCTION__);
    for(i=0;i<bytes;i++) {
	// g_print("'%c' %d\n", buf[i], buf[i]);
	if(buf[i] == 10) {
	    if(log) {
		*p = 0;
		if(strstr(response, "BUSY") != 0) {
		    show_message("ȭ");
		    gau_sleep(1000);
		    install_dial_next();
		} else if(strstr(response, "NO CARRIER") != 0 ||
		   	  strstr(response, "NO DIALTONE") != 0 ||
		   	  strstr(response, "OK") != 0 ||
		   	  strstr(response, "VOICE") != 0) {
			/* failure */
			// g_print("fail %s\n", __FUNCTION__);
		    gau_sleep(1000);
		    install_dial_next();
		} else {
		    modem_check_connected(NULL);
		    phone_hide();
		}
		gtk_timeout_remove(dial_timeout_tag);
		dial_timeout_tag = 0;
		remove_input_filter (wait_response_filter); 
		p = response;
		log = FALSE;
		break;
	    } else {
		    log = TRUE;
	    }
	} else {
		if(log) *p++ = buf[i];
	}
    }
    //g_print("%s leave\n", __FUNCTION__);
    return 0;  
}

static int
dial_install_next_cb(void)
{
    dial_next();
    dial_next_tag = 0;
    return FALSE;
}

void
install_dial_next(void)
{
    gau_state = GAU_DIAL;
    if(ntry++ > MAX_TRY) {
	    show_message("ɸŭ ɾҽϴ");
	    return;
    }
    if (dial_next_tag > 0) {
	    gtk_timeout_remove (dial_next_tag);
    }
    dial_next_tag = gtk_timeout_add(5*1000, 
    				    (GtkFunction)dial_install_next_cb, NULL);
    show_message("5ʰ ٸϴ");
}

void
dial_begin(void)
{
    dial_cleanup();
    ntry = 1;
    dial_next();
}

int
dial_next(void)
{

	gau_state = GAU_DIAL;

	if(phone_row() == 0) {
		/* no selected number */
		show_message("ȭȣΰ  ׿");
		return FALSE;
	}

	current_dial_row = phone_get_next_checked_number (current_dial_row);

	if (current_dial_row < 0) { /* ȣ ϴµ ߴ */
		gdk_beep();
		show_message(" ȭȣ ϼ!!!");
		return FALSE;
	}

	phone_info_update (current_dial_row, &pi);
	dial_current_number();
	return TRUE;
}

static void
dial_current_number(void)
{
	guchar *number;

	if (pi.speed && pi.speed[0]) {
		modem_setbaud(read_fd, pi.speed);
	} else {
		modem_setbaud(read_fd, modem_speed);
	}
	number = pi.number;
	modem_write(call_prefix, strlen(call_prefix));
	while(*number) {
		if(isdigit(*number)) modem_write(number, 1);
		number++;
	}
	modem_write(call_suffix, strlen(call_suffix));

	show_message("%d° õ: %s(%s) ȭ ̴ϴ", ntry, pi.name, pi.number);
	if (dial_timeout_tag > 0) {
		gtk_timeout_remove (dial_timeout_tag);
	}
	dial_timeout_tag = 
		gtk_timeout_add(dial_waiting_interval, 
				(GtkFunction)dial_timeout_cb, NULL);
	monitor_response();
}

/* ȭɱ⸦ , ȭɱ⸦ Ҷ  */
void
dial_cleanup(void)
{
	ntry = 0;
	current_dial_row = -1;
	gau_state = GAU_NOTHING;
	pi.name = NULL;

	if (dial_timeout_tag > 0)
		gtk_timeout_remove (dial_timeout_tag);
	if (dial_next_tag > 0)
		gtk_timeout_remove (dial_next_tag);
	dial_timeout_tag = dial_next_tag = 0;
}

int
dial_timeout_cb(gpointer data)
{
	// g_print("%s\n", __FUNCTION__);

	show_message("ð ʰ߽ϴ.");
	modem_write(cancel_string, strlen(cancel_string));
	gau_sleep(1000);

	dial_timeout_tag = 0;
	return FALSE;
}


/* main control box ȭɱ ư   */
void
dial_cb(GtkWidget *w, gpointer data)
{
    if(use_modem) {
	if(modem_connected()) {
	    hangup_cb(w, data);
	} else 
	    phone_win_show();
    } else {
	if(read_fd > 0) {
	    gau_hangup();
	} else {
	    //telnet_win_show();
	}
    }
}

void
restore_main_bottom_menu(void)
{
	update_bottom_menu_from_file("main");
}
