/* this file is a part of gau software, (C) Hwang chi-deok 1997, 1998, 1999 */

/*

 *  α׷ ۱ Ȳġ ֽϴ.
 *  α׷ GNU GENERAL PUBLIC LICENSE ǰ ˴ϴ.
 *  α׷   ü, ,
 * ȸ س  ȭ  å ʽϴ.
 * 
 */
#include "config.h"

#include <gtk/gtk.h>
#include <unistd.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>

#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif

#include <signal.h>

#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif

#include <string.h>

#include "ansiterm.h"
#include "selection.h"
#include "gau.h"
#include "scw.h"

static void terminal_size_changed(AnsiTerm * term);
static void terminal_line_changed(AnsiTerm * term);
static void make_terminal_sane(void);
RETSIGTYPE on_signal (int signum);

AnsiTerm *term;


gboolean use_modem = 1;		/* internet or modem */

guint32 last_out_time = 0;

int gau_state = GAU_NOTHING;

GtkWidget *main_win;
GtkWidget *main_box, *control_box, *status_box;
GtkWidget *current_bottom_menu, *main_bottom_menu;
GtkWidget *bottom_frame;
GtkWidget *term_box;

int saved_lines = 400;
gint read_input_tag = -1;
int read_fd = -1;		/* in fact, this fd is for read-write */
int local_echo = FALSE;
int remote_echo = FALSE;
int col = 82, row = 26;
int normal_fg = 7;
int normal_bg = 4;
gboolean read_hack = TRUE;
gboolean can_block = TRUE;
gboolean auto_linefeed = TRUE;
char *terminal_font = NULL;
char *editor = NULL;
char *sh_command = NULL;


GList *input_filter_list = NULL;
GList *disconnected_function_list = NULL;
GList *connected_function_list = NULL;

int 
main(int argc, char *argv[])
{
    GtkWidget *hbox, *frame;
    GtkWidget *sc;
    GtkWidget *separator;
    int i;

    check_personal_rc();

    gtk_set_locale();
    gtk_init(&argc, &argv);
    if (strcmp(g_basename(argv[0]), "gaui") == 0) {
	extern int crlf;
	use_modem = FALSE;
	crlf = 2;
    } else {
	use_modem = TRUE;
    }
    for (i = 1; i < argc; i++) {
	if (strcmp(argv[i], "-v") == 0) {
	    printf("%s\n", GAU_VER);
	    exit(0);
	}
	else if (strcmp(argv[i], "--modem") == 0 && argv[i+1]) {
	    modem_device = g_strdup(argv[i + 1]);
	    i++;
	}
	else if (argv[i][0] != '-') {
	    if (!use_modem)
		gtk_timeout_add(2000, (GtkFunction) connect_host_by_name, g_strdup(argv[i]));
	}
    }

    signal (SIGSEGV, on_signal);

    gau_config();

    if (use_modem) {		/* communication through modem */
	modem_init();
	if (read_hack) {
	    read_input_tag = gdk_input_add(read_fd, GDK_INPUT_READ,
				 fast_input_handler, NULL);
	} else {
	    read_input_tag = gdk_input_add(read_fd, GDK_INPUT_READ,
				      input_handler, NULL);
	}
    }

    {
	char *logfilename = 
		g_strconcat (expand_path(gau_path), "/gau.log", NULL);
	log_file = fopen(logfilename, "a");
	g_free (logfilename);
    }
    auto_response_prepare();
    input_filter_list = g_list_append(input_filter_list, zmodem_input_filter);
    connected_function_list = g_list_append(
			      connected_function_list, run_login_script);

    main_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_policy(GTK_WINDOW(main_win), TRUE, TRUE, TRUE);
    gtk_window_set_position(GTK_WINDOW(main_win), GTK_WIN_POS_CENTER);
    gtk_signal_connect(GTK_OBJECT(main_win), "destroy",
		       GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
    gau_set_title(NULL);
    gtk_widget_set_name(main_win, "main");
    gtk_container_set_border_width(GTK_CONTAINER(main_win), 5);

    main_box = gtk_vbox_new(FALSE, 3);
    gtk_container_add(GTK_CONTAINER(main_win), main_box);

    hbox = gtk_hbox_new(FALSE, 5);
    gtk_container_add(GTK_CONTAINER(main_box), hbox);

    frame = gtk_frame_new(NULL);
    gtk_container_set_border_width(GTK_CONTAINER(frame), 3);
    gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
    gtk_container_add(GTK_CONTAINER(hbox), frame);

    term_box = gtk_vbox_new (FALSE, 0);
    gtk_container_add(GTK_CONTAINER(frame), term_box);

    sc = scw_new ();
    gtk_container_add(GTK_CONTAINER(term_box), sc);


    if (!use_modem)
	term = (AnsiTerm *) ansi_term_new(terminal_font, col, row, saved_lines, NULL, dumb);
    else
	term = (AnsiTerm *) ansi_term_new(terminal_font, col, row, saved_lines, NULL, modem_write);

    gtk_container_add(GTK_CONTAINER(sc), GTK_WIDGET(term));

    /* geometry setup */
    {
      GdkGeometry geometry;
      GdkWindowHints geometry_mask;
      geometry_mask = GDK_HINT_MIN_SIZE | 
	               GDK_HINT_BASE_SIZE | 
	               GDK_HINT_RESIZE_INC;

      geometry.min_width = term->font_width*30;
      geometry.min_height = term->font_height*10;
      geometry.base_width = 0;
      geometry.base_height = 0;
      geometry.width_inc = term->font_width;
      geometry.height_inc = term->font_height;
      
      gtk_window_set_geometry_hints (GTK_WINDOW (main_win),
			       (GtkWidget *)term, &geometry, geometry_mask);
    }


    /* terminal setup */

#if TELNET_MODE
    if (!use_modem)
	putenv("TERM=vt100");
#endif

    {
	static GtkTargetEntry targets[] = {
	    { "STRING", 0 }
	};
	gtk_selection_add_targets(GTK_WIDGET(term), GDK_SELECTION_PRIMARY,
		       targets, 1);
    }
    gtk_signal_connect(GTK_OBJECT(term), "received",
		       GTK_SIGNAL_FUNC(check_in_selection), NULL);
    gtk_signal_connect(GTK_OBJECT(term), "selection_get",
    		       GTK_SIGNAL_FUNC(ansi_term_selection_handler), NULL);
    gtk_signal_connect(GTK_OBJECT(term), "button_press_event",
		       GTK_SIGNAL_FUNC(term_button_press_callback), NULL);
    gtk_signal_connect(GTK_OBJECT(term), "button_release_event",
		       GTK_SIGNAL_FUNC(term_button_release_callback), NULL);
    gtk_signal_connect(GTK_OBJECT(term), "motion_notify_event",
		       GTK_SIGNAL_FUNC(term_motion_callback), NULL);
    gtk_signal_connect(GTK_OBJECT(term), "size_changed",
		       GTK_SIGNAL_FUNC(terminal_size_changed), NULL);
    gtk_signal_connect(GTK_OBJECT(term), "selection_clear_event",
		       GTK_SIGNAL_FUNC(ansi_term_selection_clear), NULL);
    if (n_inout)
	gtk_signal_connect(GTK_OBJECT(term), "line_changed",
			   GTK_SIGNAL_FUNC(terminal_line_changed), NULL);

    term->normal_fg = normal_fg;
    term->normal_bg = normal_bg;
    term->silent = silent;
    term->auto_linefeed = auto_linefeed;
    term->use_bold = use_bold;
    term->use_under = use_under;
    term->can_block = can_block;
    keymap_init(term);
    i_select_init();

    gtk_widget_grab_focus(GTK_WIDGET(term));
#if 0
    gtk_signal_connect(GTK_OBJECT(term->adjustment), "value_changed",
		       GTK_SIGNAL_FUNC(term_scrollbar_move_callback), term);
    term->scrollbar = gtk_vscrollbar_new(term->adjustment);
    GTK_WIDGET_UNSET_FLAGS(term->scrollbar, GTK_CAN_FOCUS);
    gtk_box_pack_end(GTK_BOX(box), term->scrollbar, FALSE, FALSE, 0);
#endif


    control_box = gtk_vbox_new(FALSE, 5);
    gtk_box_pack_end(GTK_BOX(hbox), control_box, FALSE, FALSE, 0);
    control_bar(control_box);

    status_box = gtk_hbox_new(FALSE, 5);
    gtk_box_pack_end(GTK_BOX(main_box), status_box, FALSE, FALSE, 0);
    status_bar(status_box);

    separator = gtk_hseparator_new();
    gtk_box_pack_end(GTK_BOX(main_box), separator, FALSE, FALSE, 0);

    bottom_frame = frame = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_end(GTK_BOX(main_box), frame, FALSE, FALSE, 0);

    if (use_modem) {
	main_bottom_menu = current_bottom_menu =
	    main_bottom_menu_create(expand_path(MAIN_BOTTOM_MENU_FILE));
    } else {
	main_bottom_menu = current_bottom_menu =
	    main_bottom_menu_create(expand_path(TCP_MAIN_BOTTOM_MENU_FILE));
    }

    if (current_bottom_menu != NULL)
	gtk_container_add(GTK_CONTAINER(frame), current_bottom_menu);

    /*
       if(use_modem)
       connected_function_list = g_list_append(connected_function_list,
       update_bottom_menu);
       else
       connected_function_list = g_list_append(connected_function_list,
       update_telnet_bottom_menu);
     */

    if (sound_flag)
	connected_function_list = g_list_append(connected_function_list,
						play_connect);
    if (taegeuk) {
	connected_function_list = g_list_append(connected_function_list,
						taegeuk_start);
    }
    disconnected_function_list = g_list_append(
		   disconnected_function_list, restore_main_bottom_menu);
    disconnected_function_list = g_list_append(
			 disconnected_function_list, make_terminal_sane);
    if (sound_flag)
	disconnected_function_list = g_list_append(
			    disconnected_function_list, play_disconnect);
    if (taegeuk) {
	disconnected_function_list = g_list_append(
			       disconnected_function_list, taegeuk_stop);
    }
    signal(SIGCHLD, child_signal_handler);

    gtk_widget_show_all(main_win);

    gtk_main();

    if (sound_flag)
	play_exit();
    if (use_modem && do_lock)
	modem_unlock(NULL);
    fclose(log_file);
    return 0;
}

static void terminal_size_changed(AnsiTerm * term)
{
    if (read_fd > 0 && !use_modem)
	pty_setwinsize(read_fd, term->col, term->row);
}

static void terminal_line_changed(AnsiTerm * term)
{
    if (term->cu_x == 0)
	return;
    auto_response_check(term->buf + term->col * linenumber(term->cu_y), term->cu_x);
}

static void make_terminal_sane(void)
{
    ansi_term_sane(term);
}

RETSIGTYPE
on_signal (int signum)
{
    fprintf (stderr, "SIGSEG caught\n");
    g_on_error_query (NULL);
    gdk_exit(1);
}
