#ifndef __GAU_H__
#define __GAU_H__
#include <stdio.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#include "ansiterm.h"
#include "scrolledchat.h"

enum { 
	GAU_SCRIPT, 
	GAU_DIAL, 
	GAU_DOWNLOAD, 
	GAU_UPLOAD, 
	GAU_NOTHING, 
	GAU_CONNECTED, 
	GAU_TELNET, 
	GAU_TELNET_DIAL
};

typedef struct 
{ 
	char *name, *host, *port, *script_file;
} TelnetInfo;

typedef struct 
{ 
	char *name, *number, *speed, *script; 
} PhoneInfo;

typedef struct { 
	guchar *lpattern; 
	int jm[256]; 
	int llen;
	GList *ilist, *olist; 
	guchar *raw; 
	int type; 
	gboolean active;
} Auto;

extern FILE *log_file;
extern int gau_state;
extern GtkWidget *taegeuk;
extern char *editor;
extern char *sh_command;
extern GList *disconnected_function_list;
extern GList *connected_function_list;
extern int local_echo, remote_echo;
extern gboolean strip_linefeed;
extern gboolean auto_linefeed;
extern gboolean can_block;
extern gboolean vi_esc_hack;
extern int crlf;
extern char *p_string;
extern GdkColor *color_table[8];
extern GtkWidget *control_box;
extern GtkWidget *main_bottom_menu, *bottom_frame;
extern GtkWidget *current_bottom_menu;
extern GtkWidget *disconnect_after_transfer_button;
extern GtkWidget *call_button, *upload_button;
extern GtkWidget *capture_button;
extern GtkWidget *write_button;
extern GtkWidget *main_win;
extern GtkWidget *term_box;
extern GauScrolledChat *schat; 
extern char *terminal_font;
extern GList *input_filter_list;
extern gint read_input_tag;
extern int read_fd;
extern pid_t telnet_pid;
extern char *telnet_command;
extern char *initialize_string;
extern int capture_fd;
extern int scapture_fd;
extern char *script_path;
extern char *gau_path;
extern char *capture_path;
extern char *down_path;
extern char *up_path;
extern char *capture_file;
extern gboolean do_lock;
extern TelnetInfo *telnetinfo;
extern guint32 last_out_time;
extern guint32 last_incoming_time;
extern GdkColor *black, *red, *green, *yellow, *blue, *magenta, *cyan, *white;
extern GdkColor *cursor_fg, *cursor_bg;
extern int normal_fg, normal_bg;
extern int idle_guard_interval;
extern char *idle_guard_string;
extern gboolean use_under;
extern gboolean chat_append;
extern char *chat_prefix1;
extern char *chat_prefix2;
extern char *chat_suffix;
extern int saved_lines;
extern int col, row;
extern GList *telnetinfo_list;
extern int dial_waiting_interval;
/* signal.c */
void child_signal_add(int, void (*func)(void));
void child_signal_handler(int signum);

/* control.c */
void control_bar(GtkWidget *w);
GtkWidget * add_menu_item (GtkWidget *menu, char *label, GtkSignalFunc func, gpointer data);
void hangup_cb(GtkWidget *w, gpointer data);
void screen_save_cb(GtkWidget * w, gpointer data);

/* i_select.c */
void i_select_init(void);
int i_select_begin(AnsiTerm * term, int x, int y);
void i_select_motion(AnsiTerm * term, int x, int y);
void i_select_end(AnsiTerm * term, int x, int y);

/* si.c */
void si_cb(GtkWidget *w, gpointer foo);
void script_cancel(void);
char *get_line(FILE *fp);
void destroy_script(void);
void update_bottom_menu_from_file(char *filename);

/* modem.c */
extern gboolean modem_use_hwf, modem_use_swf;
extern char *modem_device;
extern char *modem_speed;
extern char *modem_parity;
extern char *modem_bits;

int modem_init(void);
int modem_connected(void);
int modem_check_connected(gpointer );
int modem_lock(char *device);
int modem_unlock(char *device);
void modem_hangup(void);
int modem_restore(void);
void modem_setbaud(int modemfd, char *);
int modem_write(char *str, int size);


/* bottom-menu.c */
GtkWidget * main_bottom_menu_create(char *filename);

/* gau.c */
extern gboolean use_modem;
extern gboolean read_hack;
extern AnsiTerm *term;

/* selection.c */
void check_in_selection(AnsiTerm *term);



/* pty.c */
void pty_setwinsize(int fd, int col, int row);
int pty_open(char *command, pid_t *childpid, int col, int row);

/* script.c */
void delayed_transmit(char *buf , int size, int msec);
void prepare_telnet_script(char *script_file);
void run_login_script(void);
void run_script_from_file(char *filename);
void run_script_from_string(char *str);
void run_script_from_command(char *command);

/* tcp.c */
gint connect_host_by_name(char *host);
int dumb(char *buf, int byte);
int telnet_time_report(void);
int telnet_connected(void);
void telnet_connect(char *host, char *port, char *script);
void telnet_hangup(void);

/* misc.c */
extern gboolean use_bold, sound_flag, use_beep, silent, use_ztelnet;
extern char *sz_command, *rz_command;

int is_first_han(char *buf, int x);
int is_second_han(char *buf, int x);
void gau_config(void);
void gau_hangup(void);
char *expand_path(char *);
void delayed_run(guint32 msec, void (*func)(void));
int capture_input_filter(char *str, int bytes);
void screen_save(void);
void whole_screen_save(void);
void begin_capture(const char *filename);
void end_capture(void);
void play_connect(void);
void play_disconnect(void);
void play_click(void);
void play_transfer_end(void);
void play_exit(void);
void play(char *);
void taegeuk_start(void);
void taegeuk_stop(void);
void taegeuk_toggle (void);
GtkWidget * ani_pixmap_create(GtkWidget *);
void fast_input_handler(gpointer data, 
				      int source, 
				      GdkInputCondition con);
void input_handler(gpointer data, 
				 int source, 
				 GdkInputCondition con);

/* status.c */
void append_message(const char *format, ...);
void show_message(const gchar *format, ...);
void show_time(int);
void status_bar(GtkWidget *w);
void show_incoming(gboolean flag);
void show_outgoing(gboolean flag);

/* zmodem.c */
extern gboolean auto_rz, auto_sz, disconnect_after_transfer;
void run_rz(void);
void run_sz(void);
void rz_cancel(void);
void sz_cancel(void);
void zmodem_init(void);
int zmodem_input_filter(char *str, int bytes);

/* autores.c */
extern Auto *inouts;
extern int n_inout;
void ar_setup_cb(GtkWidget *w);
void auto_response_prepare(void);
int auto_response_check(guchar *str, int size);

/* dial.c */
void dial_cleanup(void);
void dial_cb(GtkWidget *w, gpointer data);
void install_dial_next(void);
void dial_begin(void);
void dial_cancel(void);
void restore_main_bottom_menu(void);

/* cphone.c */
extern PhoneInfo pi;
gint phone_row (void);
void phone_hide (void);
void phone_win_show (void);
gint phone_win(char *phonelist);
gint phone_info_update(int row, PhoneInfo *pi);
gint phone_get_next_checked_number(int current_row);
void phone_check_by_name(char *name);

/* util.c */
void 	gau_set_title (char *title);
void 	remove_input_filter (gpointer filter);
void 	register_input_filter (gpointer filter);
char   *replace_ctl_char (char *buf);
guchar *eat_space(guchar *buf);
void 	destroy_top_level (GtkWidget *widget);
void 	hide_top_level (GtkWidget *widget);
void 	check_personal_rc (void);
char   *get_string_from_user(char *label_text);

#endif /* __GAU_H__ */
