
#ifndef _GAU_CHAT_H__
#define _GAU_CHAT_H__

#include <gdk/gdk.h>
#include <gtk/gtkdrawingarea.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GAU_CHAT(obj)	GTK_CHECK_CAST(obj, gau_chat_get_type(), GauChat)
#define GAU_CHAT_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, gau_chat_get_type(), GauChatClass)
#define GAU_IS_CHAT(obj) GTK_CHECK_TYPE(obj, gau_chat_get_type())

typedef struct _GauChat	GauChat;
typedef struct _GauChatClass GauChatClass;

typedef struct _PreeditBuf PreeditBuf;

struct _PreeditBuf {
    char *string;
    int *feedback;
    int caret, len, alloc_len;
};

struct _GauChat {
	GtkDrawingArea drawing_area;
	GdkFont *font;
	GdkGC *gc;
	gchar **buf;
	GtkAdjustment *adj;
	gint *buf_alloc;
	gint font_width;
	gint font_height;
	gint font_ascent;
	gint current_x;
	gint current_y;
	gint col;
	gint row;
	gint vrow;
	gint offset;
	gboolean overwrite;
	gint add;
        GdkIC     *ic;
        GdkICAttr *ic_attr;
	PreeditBuf *ebuf;
	gchar *prefix1;
	gchar *prefix2;
	gchar *suffix;
	gchar *fbinding[20];
};

struct _GauChatClass {
	GtkDrawingAreaClass parent_class;
	void (*send) (GauChat *chat,
		gchar *text,
		gint length);
	void (*line_changed) (GauChat *chat);
	void (*set_scroll_adjustments) (GauChat *chat, 
		GtkAdjustment *hadj, GtkAdjustment *vadj);
};

guint gau_chat_get_type(void);
GtkWidget *gau_chat_new(GdkFont *font, int font_height, int font_width,
	int col, int row, int vrow);
void gau_chat_insert_text(GauChat *chat, gchar *buf, int len);
void gau_chat_insert_char(GauChat *chat, gchar c);
void gau_chat_prefix_set(GauChat *chat, gchar *s, gint flag);
void gau_chat_suffix_set(GauChat *chat, gchar *s);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GAU_CHAT_H__ */


