#include <ctype.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
int is_second_han(char *buf, int);

typedef unsigned char guchar;
typedef int (*ISelectSearch) (guchar *buf, int x, int *vs, int *ve);
typedef void (*ISelectAction) (void);
typedef void (*ISelectCancel) (void);

typedef struct 
{
	ISelectSearch search;
	ISelectAction action;
	ISelectAction cancel;
} PatternMatcher;


#define TRUE 1
#define FALSE 0

static void (*send_from_term)(char *buf);
static char send_buf[1024];
static char *eat_space(guchar *buf);
static int send_end, send_start;

static void
push_send_string(guchar *buf)
{
	memcpy(send_buf, buf + send_start, send_end - send_start);
	send_buf[send_end - send_start] = 0;
}

static void
set_send_buf(guchar *buf)
{
	strcpy(send_buf, buf);
}

static void
default_action(void)
{
	send_from_term(send_buf);
	send_buf[0] = 0;
}

static void
default_cancel(void)
{
	send_buf[0] = 0;
}

static char *
eat_space(guchar *s)
{
	while (isspace(*s)) s++;
	return s;
}


/* ȣ/(H,F,B,P,T,M,N,A,W,DD,AP,UD,PR,DN,S,GO,PF,ME,MM,SAY,Z,X)  
ȣ/(H. P.ȭ GO.̵ J.ش缭 NO.ü) */
static int 
command_search(guchar *buf, int x, int *vs, int *ve)
{
	guchar *s;

	if (strstr(buf, "ȣ/") == NULL)
	    return FALSE;
	s = buf + x;
	while (buf <= s && *s != '.' && *s != ',' && !isspace(*s)) s--;
	if (isspace(*s)) {
		while(*s != '.' && *s != ',') s++;
	} else if(*s == ',') {
		if((buf + x) != s) {
			s++;
			while(*s != ',' && *s != ')') s++;
		}
	}
	send_end = s - buf;
	s--;
	while (isalpha(*s)) s--;
	s++;
	send_start = s - buf;
	*vs = s - buf;
	s = buf + send_end;
	*ve = send_end;
	if (*s == '.') {
		s = strchr(s + 1, '.');
		if (s != NULL) {
			s--;
			while (isalpha(*s)) s--;
			while (isspace(*s)) s--;
			*ve = s - buf + 1;
		} else {
			s = buf + send_end;
			if ((s = strchr(s, ')')) != NULL) {
				*ve = s - buf;
			}
		}
	}
	push_send_string(buf);
	return TRUE;
}


/* go linux  , go linux12 */
static int
go_search(guchar *buf, int x, int *vs, int *ve)
{
	guchar *s;

	s = buf + x;
	if (isalnum(*s)) 
	    while(isalnum(*s)) s--;
	s++;
	if ((s[0] == 'g' || s[0] == 'G') && (s[1] == 'o' || s[1] == 'O')) {
		send_start = s - buf;
		*vs = s - buf;
		s += 3;
		while (isalpha(*s) || isdigit(*s)) 
		    s++;
		send_end = s - buf;
		*ve = s - buf;
		push_send_string(buf);
		return TRUE;
	} else {
		s--;
		while (isspace(*s)) 
		    s--;
		if ((s[-1] == 'g' || s[-1] == 'G') && (s[0] == 'o' || s[0] == 'O')) {
			s--;
			send_start = s - buf;
			*vs = s - buf;
			s += 3;
			while(isalnum(*s)) s++;
			send_end = s - buf;
			*ve = s - buf;
			push_send_string(buf);
			return TRUE;
		}
	}
	return FALSE;
}

static guchar *
backstrchr(guchar *s, guchar c)
{
	while (*s && *s != c) s--;
	if (*s) return s;
	return NULL;
}

/*          1. HiTEL INFOSHOP                 10. HiNET-P */
/*          F1. ȣƮ ڷ               F2. ڷ Խ */

static int
room_search(guchar *buf, int x, int *vs, int *ve)
{
	guchar *s;

	s = buf + x;
	while (s != buf && *s != '.')  s--;
	if (s == buf || !isdigit(s[-1])) return FALSE;
	while (isdigit(*--s)) ; 
	if (*s == '.' || *s == '/') return FALSE;
	if (!isspace(s[0]) && ((s[0] & 0x80) == 0) && *s != '|') {
		if(s[0] == '%' || s[0] == '@' || s[0] == '#' || s[0] == '*') {
			send_start = s - buf + 1;
		} else {
			send_start = s - buf;
		}
		s--;
	} else {
		send_start = s - buf + 1;
	}
	s++;
	*vs = s - buf;

	while (isdigit(*++s)) ;
	send_end = s - buf;
	while (1) {
		while ((!isdigit(*s)) && (*s != 0) 
		        && (*s != (guchar )0xa6) && (*s != '|')) {
			if (*s & 0x80) s++;
			s++;
		}
		if (*s == 0 || *s == (guchar)0xa6 || *s == '|') {
			s--;
			break;
		}
		while (isdigit(*s)) s++;
		if (*s == '.') {
			s--;
			while (isdigit(*s)) s--;
			if (!isspace(*s) && ((*s & 0x80) == 0)) s--;
			// == '*' || *s == '@' || *s == '#') s--;
			break;
		}
	}
	while (isspace(*s)) s--;
	s++;
	*ve = s - buf;
	push_send_string(buf);
	return TRUE;
}

//ã(FIND) ̵(GO) ʱ޴(T) ޴(M) (X,BYE) Ÿ(Z) 
static int 
ch_command_search(guchar *buf, int x, int *vs, int *ve)
{
	guchar *e, *b, *s, *m;
	s = buf + x;
	e = strchr(s, ')');
	if (e == NULL) 
	    return FALSE;
	b = backstrchr(s, ')');
	if (b == NULL) b = buf;
	else b++;
	b = eat_space(b);
	*vs = b - buf;
	m = strchr(b, '(');
	if (m == NULL || m > e - 2) return FALSE;
	send_start = m - buf + 1;
	s = m + 1;
	while (s != e && *s != ')' && *s != ',') s++;
	if ((s != e && *s == ',') || (*s == ')' && s == e)) {
		send_end = s - buf;
	} else 
		return FALSE;
	*ve = e - buf + 1;
	push_send_string(buf);
	return TRUE;
}

static char *http_command = "netscape";
static char *ftp_command = "netscape";
static char *telnet_command = "gaui";
static char *url_command = NULL;

static int
url_search(guchar *buf, int x, int *vs, int *ve)
{
    guchar *b, *e, *s;
    guchar *h, *f, *t;
    guchar class[256];
    int i;
    b = e = s = NULL;
    h = f = t = NULL;
    for(i=0;i<256;i++) class[i] = 0;
    for(i='a';i<='z';i++) class[i] = 1;
    for(i='A';i<='Z';i++) class[i] = 1;
    for(i='0'; i <= '9'; i++) class[i] = 1;
    class['.']=class['-']=class['/']=class['~']=class['_'] 
	= class[':'] = 1;

    s = buf + x;
    while (*s) {
	if(strncmp(s, "http://", 7) == 0) {
	    b = s;
	    h = s;
	    break;
	} else if(strncmp(s, "ftp://", 6) == 0) {
	    b = s;
	    f = s;
	    break;
	} else if(strncmp(s, "telnet://", 9) == 0) {
	    b = s;
	    t = s;
	    break;
	} else
	s--;
    }
    if (*s == 0) {
	s = buf + x + 1;
	while (*s) {
	    if (strncmp(s, "http://", 7) == 0) {
		b = s;
		h = s;
		break;
	    } else if (strncmp(s, "ftp://", 6) == 0) {
		b = s;
		f = s;
		break;
	    } else if (strncmp(s, "telnet://", 9) == 0) {
		b = s;
		t = s;
		break;
	    } else
		s++;
	}
    }
    if (*s == 0) return FALSE;

    if (b == h){
	*vs = b - buf;
	e = b + 7;
	while (class[*e]) e++;
	*e = 0;
	*ve = e - buf;
	url_command = http_command;
	send_start = b - buf;
	send_end = e - buf;
	push_send_string(buf);
	return TRUE;
    } else if (b == f) {
	*vs = b - buf;
	e = b + 6;
	while (class[*e]) e++;
	*e = 0;
	*ve = e - buf;
	url_command = ftp_command;
	send_start = b - buf;
	send_end = e - buf;
	push_send_string(buf);
	return TRUE;
    } else if (b == t) {
	*vs = b - buf;
	e = b + 9;
	while(class[*e]) e++;
	*e = 0;
	*ve = e - buf;
	send_start = b + 9 - buf;
	send_end = e - buf;

	push_send_string(buf);
	url_command = telnet_command;
	return TRUE; 
    }
    return FALSE;
}

static void
url_cancel(void)
{
	url_command = NULL;
	send_buf[0] = 0;
}

static void
run_command(guchar * command)
{
    if (fork() > 0) return;
    setsid();
    execlp("sh", "sh", "-c", command, NULL);
    fprintf(stderr, "**WARNING**: fail to run '%s'\n", command);
    _exit(1);
}

static void
url_action(void)
{
    char buf[1024];
    if (url_command) {
	sprintf(buf, "%s %s", url_command, send_buf);
	run_command(buf);
	url_command = NULL;
    }
    send_buf[0] = 0;
}



//  M1 [//ȸ]      M2 [̹PC]  M3 [/Ʈ]     M4 [õԽù] 
static int 
hitel_M(guchar *buf, int x, int *vs, int *ve)
{
    guchar *b;
    guchar *e;

    if (strstr(buf, "M1") == NULL || strstr(buf, " M2") == NULL) 
	return FALSE;

    b = backstrchr(buf + x, 'M');
    if (b == NULL) {
	b = strchr(buf, 'M');
    }
    *vs = b - buf;
    send_start = b - buf;
    send_end = b - buf + 2;
    e = strchr(b, ']');
    if (e == NULL) 
	return FALSE;
    *ve = e - buf;
    push_send_string(buf);
    return TRUE;
}

/*   9  k2linux     97/11/12 TXT   2K  11  ̳ .*/ 
static int
subject_search(guchar *buf, int x, int *vs, int *ve)
{
    guchar *s;
    
    s = buf;
    if (*s == '&')
	s++;
    s = eat_space(s);
    if (((s - buf) > 10) || !isdigit(*s)) 
	return FALSE;
    *vs = send_start =  s - buf;
    while (isdigit(*s)) s++;
    if (*s != ' ')
	return FALSE;
    while (!isspace(*s)) s--;
    send_end = s - buf + 1;
    push_send_string(buf);

    s = s + strlen(s) - 1;
    while (isspace(*s)) s--;
    *ve = s - buf + 1;
    return TRUE;
}

/* 
 ȣ  øID           ¥                           0:
*/
static int
now_acro_motivation(guchar *buf, int x, int *vs, int *ve)
{
    guchar *s;

    s = buf + x;
    while (*s != '0' && *s != 0) s--;
    if (*s == 0) return FALSE;
    if (strncmp(s, "0:", 10) != 0) return FALSE;
    *vs = s - buf;
    *ve = *vs + 10;
    set_send_buf("0");
    return TRUE;
}

/* 
 ø : izcandg (ĳ嵿  )    97/12/18 12:58     :  21  ڷ (TL) 
*/
static int
now_thread(guchar *buf, int x, int *vs, int *ve)
{
    guchar *s;
    s = buf + x;
    while (*s && !isdigit(*s)) s--; 
    if (*s == 0) return FALSE;
    s = eat_space(s + 1);
    if (strncmp(s, "ڷ (TL)", 17) != 0) return FALSE;
    *vs = s - buf;
    *ve = *vs + 17;
    set_send_buf("TL");
    return TRUE;
}

/*
 1   1
 4 ܦۦܡۦۦ  4
19  19
 */
/*  ̱  , õ, 쿡 콺
ٵ   ֽϴ. :  (98. 5. 16) */

static int
baduk_mode(guchar *buf, int x, int *vs, int *ve)
{
  int bx, by;
  guchar *s;
  
  by = atoi(buf);
  if (by < 1 || by > 19)
    return FALSE;

  if (is_second_han(buf, x))
    s = buf + x - 1;
  else
    s = buf + x;

  if (!((*s == 166 && *(s + 1) >= 163 && *(s + 1) <= 171) ||
  	(*s == 163 && *(s + 1) == 171)))
    return FALSE;

  bx = (x - 3) / 2;

  if (bx < 0 || bx > 18)
    return FALSE;

  *vs = s - buf;
  *ve = *vs + 2;
  
  sprintf(send_buf, "%d,%c", by, 'a' + bx);  
  return TRUE;
}

static PatternMatcher patterns [] =
{
    {now_thread, default_action, default_cancel},
    {url_search, url_action, url_cancel},
    {go_search, default_action, default_cancel},
    {baduk_mode, default_action, default_cancel},
    {subject_search, default_action, default_cancel},
    {room_search, default_action, default_cancel},
    {command_search, default_action, default_cancel},
    {ch_command_search, default_action, default_cancel},
    {hitel_M, default_action, default_cancel},
    {now_acro_motivation, default_action, default_cancel},
};

int
register_patterns(PatternMatcher **ret_patterns, void (*fn)(char *))
{
    *ret_patterns = patterns;
    send_from_term = fn;
    return sizeof(patterns) / sizeof(patterns[0]);
}
