
/* this file is a part of gau software, (C) Hwang chi-duck 1997,1999      */

#include <gtk/gtk.h>
#include <sys/stat.h>
#include <stdio.h>
#include <sys/types.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>
#include <fnmatch.h>
#include "gzillaimgsink.h"
#include "gzillabytesink.h"
#include "gzillaimage.h"
#include "gzillagif.h"
#include <jpeglib.h>
#include "gzillajpeg.h"

void input_handler(GzillaByteSink *bytesink, int source, GdkInputCondition con);
void abort_callback(void);
void enlarge_callback(GtkWidget *w, GtkScrolledWindow *scr);

enum { JPG, GIF, DATA};

int input_tag;
GtkWidget *win;
GtkWidget *grim;
char *filename;
pid_t parent_pid;
int fd;
GtkWidget *vbox, *scr, *hbox;
GzillaImgSink *imgsink;
GtkWidget *quit_button;

int
main(int argc, char *argv[])
{

	GzillaByteSink *bytesink;
	struct stat st;
	char *title;
	int type;
	int resume = FALSE;
	if(argc < 2) return 1;
	filename = g_strdup(argv[1]);

	if(fnmatch("*.jpg", argv[1], 0) == 0 || fnmatch("*.JPG", argv[1], 0) == 0) {
		type = JPG;
	} else if(fnmatch("*.gif", argv[1], 0) == 0 ||
				fnmatch("*.GIF", argv[1], 0) == 0) {
		type = GIF;
	} else {
		return 1;
	}
	parent_pid = getppid();
	if(stat(argv[1], &st) != 0) {
		fd = open(argv[1], O_WRONLY|O_CREAT, 0660);
	} else {
		// old file
		fd = open(argv[1], O_RDWR);
		st.st_size = st.st_size & ~(1024);
		resume = TRUE;
	}

	if(fd < 0) {
		g_warning("fail to open for writing %s\n", argv[1]);
	}
	gtk_init(&argc, &argv);

	win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_policy(GTK_WINDOW(win), TRUE, TRUE, TRUE);
	gtk_signal_connect(GTK_OBJECT(win), "destroy",
		GTK_SIGNAL_FUNC(abort_callback), NULL);

	title = g_strconcat(" ׸ޱ: ", filename, NULL);
	gtk_window_set_title(GTK_WINDOW(win), title);
	g_free(title);

	gtk_window_position(GTK_WINDOW(win), GTK_WIN_POS_CENTER);
	gtk_container_set_border_width(GTK_CONTAINER(win), 5);

	vbox = gtk_vbox_new(FALSE, 3);
	gtk_container_add(GTK_CONTAINER(win), vbox);

	scr = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scr), 
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(vbox), scr, TRUE, TRUE, 5);
	imgsink = gzilla_image_new (0, 0, "", 0xd6d6d6);
	grim = gzilla_image_widget (imgsink);

	if(type == GIF) bytesink = gzilla_gif_new (imgsink);
	else bytesink = gzilla_jpeg_new(imgsink);
	input_tag = gdk_input_add(0, GDK_INPUT_READ, (GdkInputFunction)input_handler, bytesink);

	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scr), grim);

	hbox = gtk_hbox_new(FALSE, 2);
	gtk_box_pack_end(GTK_BOX(vbox), hbox, TRUE, TRUE, 0); 

	if(resume) {
		int len;
		char *buf = g_new(char, st.st_size);
		len = read(fd, buf, st.st_size);
		gzilla_bytesink_write (bytesink, buf, len);
		g_free(buf);
	}

	quit_button = gtk_button_new_with_label(" ߴ");
	gtk_signal_connect(GTK_OBJECT(quit_button), "clicked",
		GTK_SIGNAL_FUNC(abort_callback), NULL);
	gtk_box_pack_end(GTK_BOX(hbox), quit_button, FALSE, FALSE, 0); 
	gtk_main();
	return 0;
}

void
image_set(int width, int height)
{
	width += 25;
	height += 25;
	if(width > 600) width = 600;
	if(height > 500) height = 500;
	gtk_widget_set_usize(scr, width, height);
	gtk_widget_show_all(win);
}

void
erase_callback(GtkWidget *w)
{
	unlink(filename);
	gtk_widget_set_sensitive(w, FALSE);
}

void
erase_exit_callback(GtkWidget *w)
{
	unlink(filename);
	gtk_main_quit();
}

void
transfer_end(void)
{
	GtkWidget *button;
	gtk_label_set(GTK_LABEL(GTK_BIN(quit_button)->child), "");
	if(fd < 0) return;
	close(fd);
	gtk_widget_show(quit_button);
	button = gtk_button_new_with_label(" ");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
		GTK_SIGNAL_FUNC(erase_callback), NULL);
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 5);
	gtk_widget_show(button);
	button = gtk_button_new_with_label("  ");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
		GTK_SIGNAL_FUNC(erase_exit_callback), NULL);
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 5);
	gtk_widget_show(button);
}

void
abort_callback(void)
{
	if(getppid() == parent_pid) {
		// transfer is under way.
		kill(parent_pid, SIGTERM);
		parent_pid = -1;
		return;
	}
	gtk_main_quit();
}

void
input_handler(GzillaByteSink *bytesink, int source, GdkInputCondition con)
{
	char buf[256];
	int size;
	static int tot_size = 0;
	size = read(source, buf, 256);
	tot_size += size;
	if(size > 0) {
		gzilla_bytesink_write (bytesink, buf, size);
		if(fd > 0) write(fd, buf, size);
	} else {
		gzilla_bytesink_close(bytesink);
		gdk_input_remove(input_tag);
		transfer_end();
		if(fork()>0) _exit(0);
	}
}
