/* this file is a part of gau software, (C) Hwang chi-deok 1997 - 1999       */

#include "config.h"

#include "gnome-login-support.h"

#include	<sys/types.h>
#include	<sys/stat.h>

#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif

#ifdef HAVE_UNISTD_H
# include    <unistd.h>
#endif

#include	<stdio.h>
#include	<signal.h>

#ifdef HAVE_SYS_IOCTL_H
#ifndef sun
# include    <sys/ioctl.h>
#endif
#endif

#ifdef HAVE_UTMP_H
#include <utmp.h>
#endif

#include    <string.h>

#ifdef HAVE_TERMIOS_H
# include <termios.h>
#endif


/*
 * Initialize a pty, fork a command running under it, and then 
 * return the master file descriptor
 */


int tty_reset(int fd);
int tty_raw(int fd);
void pty_setwinsize(int fd, int col,int  row);


int 
pty_open(char *command, pid_t *childpid, int col, int row)
{
	int slave_fd;
	int master_fd;
	if (openpty(&master_fd, &slave_fd, NULL, NULL, NULL) == -1) return -1;

	*childpid = fork();
	if (*childpid < 0)
		return(-1);
	else if ( (*childpid) == 0 ) {
		close(master_fd);
		login_tty(slave_fd);

		/* Set the lines and columns on the new tty */
		pty_setwinsize(0, col, row);

		signal(SIGINT, SIG_DFL);
		signal(SIGQUIT, SIG_DFL);
		signal(SIGCHLD, SIG_DFL);
		signal(SIGPIPE, SIG_DFL);

		signal(SIGTSTP, SIG_IGN);
		signal(SIGTTIN, SIG_IGN);
		signal(SIGTTOU, SIG_IGN);

		/* Run the requested program, with possible leading dash. */
		/* Yes, it's csh. I don't know why sh failed sometimes */
		/* At least, csh seems to work at linux and solaris */
		execlp("csh", "csh", "-c", command, NULL);
		_exit(1);
	}
	close(slave_fd);
	return(master_fd);
}



/* Set a terminal in raw mode */

int
tty_raw(int fd)
{
	struct termios tty;
	if (!isatty(fd)) return 0;
	tcgetattr(fd, &tty);

#ifdef HAVE_CFMAKERAW
	cfmakeraw(&tty);
#else
	tty.c_iflag = IGNBRK;
	tty.c_oflag = 0;
	tty.c_lflag = 0;
	tty.c_cflag |= CLOCAL | CREAD;
	tty.c_iflag &= ~(IXON|IXOFF|IXANY);
	tty.c_cc[VMIN] = 1;
	tty.c_cc[VTIME] = 1;
#endif

	tcsetattr(fd, TCSANOW, &tty);
	return 0;
}

/* Set the pty window size to the size of the virtual window */

void pty_setwinsize(fd, col, row)
int fd;			/* The pty file descriptor */
int col, row;   // size of this terminal
{
#ifdef TIOCSWINSZ
	static struct winsize mywinz;
	mywinz.ws_row=row;
	mywinz.ws_col=col;
	mywinz.ws_xpixel=0;
	mywinz.ws_ypixel=0;
	(void) ioctl(fd, TIOCSWINSZ, &mywinz);
#endif
}
