#include "scw.h"

static void scw_class_init (ScwClass *klass);
static void scw_init (Scw *scw);
static void scw_size_request (GtkWidget *widget, GtkRequisition *requisition);

GtkType
scw_get_type (void)
{
    static GtkType scw_type = 0;
    if (!scw_type) {
	static const GtkTypeInfo scw_info =
	{
	    "Scw", sizeof(Scw), sizeof(ScwClass),
	    (GtkClassInitFunc) scw_class_init,
	    (GtkObjectInitFunc) scw_init,
	    NULL, NULL, NULL,
	};
	scw_type = gtk_type_unique (GTK_TYPE_SCROLLED_WINDOW, &scw_info);
    }
    return scw_type;
}

static void
scw_class_init (ScwClass *klass)
{
    GtkWidgetClass *widget_class;
    GtkScrolledWindowClass *scrolled_window_class;

    widget_class = (GtkWidgetClass *)klass;
    scrolled_window_class = (GtkScrolledWindowClass *)klass;
    widget_class->size_request = scw_size_request;
    //scrolled_window_class->scrollbar_spacing = 2;
}

static void
scw_init (Scw *scw)
{
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(scw), 
		GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
}

GtkWidget *
scw_new (void)
{
    GtkWidget *w;

    w = gtk_widget_new (scw_get_type(), "hadjustment", NULL, "vadjustment", NULL, NULL);
    return w;
}

static void
scw_size_request (GtkWidget *widget, GtkRequisition *requisition)
{
    GtkBin *bin;
    GtkScrolledWindow *scrolled_window;
    GtkRequisition child_req, vscroll_req;
    bin = GTK_BIN (widget);
    scrolled_window = GTK_SCROLLED_WINDOW (widget);
    gtk_widget_size_request (bin->child, &child_req);
    gtk_widget_size_request (scrolled_window->vscrollbar, &vscroll_req);
    requisition->width = vscroll_req.width +
    	GTK_SCROLLED_WINDOW_CLASS (GTK_OBJECT(widget)->klass)->scrollbar_spacing
	+ GTK_CONTAINER(widget)->border_width * 2 
	+ child_req.width;
    requisition->height = child_req.height +
    	GTK_CONTAINER(widget)->border_width * 2;
	//g_print("scw bin:%d %d\n", bin->child->requisition.width, bin->child->requisition.height);
	//g_print("scw:%d %d\n", requisition->width, requisition->height);
}

