/* this file is a part of gau software, (C) Hwang chi-deok 1997, 1998         */

#include "config.h"

#include <gtk/gtk.h>
#include <sys/types.h>
#include <signal.h>

#ifdef HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif

typedef struct {
	pid_t pid;
	void (*func)(void);
} Signal;

static GList *signal_cb_list = NULL;

void
child_signal_add(pid_t pid, void (*func)(void))
{
	Signal *s_handler = g_new(Signal, 1);
	s_handler->pid = pid;
	s_handler->func = func;
	signal_cb_list = g_list_append(signal_cb_list, s_handler);
}

static gint
run_child_handler (void (*func)(void))
{
    (*func)();
    return FALSE;
}

void
child_signal_handler(int signum)
{
	GList *list = signal_cb_list;
	Signal *s_handler;
	pid_t pid = wait(NULL);
	while(list) {
		s_handler = list->data;
		if(pid == s_handler->pid) {
		    /* we cannot run handler immediately */
		    /* current glib handler's poll routine didn't consider to be interrupted by signal */
			gtk_timeout_add(1, (GtkFunction) run_child_handler, s_handler->func);
			signal_cb_list = g_list_remove (signal_cb_list, 
							s_handler);
			g_free(s_handler);
			break;
		}
		list = list->next;
	}
	signal(SIGCHLD, child_signal_handler);
}

