
/* this file is a part of gau software, (C) Hwang chi-deok 1997, 1998         */

#include <gtk/gtk.h>
#include <stdarg.h>
#include "gau.h"
#include <gdk/gdkprivate.h>

extern void hangul_input_toggle(gpointer foo);
extern char *g_vsprintf (const gchar *fmt, va_list *args, va_list *args2);
static GtkWidget *status_label;
static GtkWidget *time_label;
static GtkWidget *han_input_label = NULL;

int
gau_status_draw(XIC ic, gpointer user_data, XIMStatusDrawCallbackStruct *st)
{
    if (ic == NULL) {
	if (han_input_label) {
	    gtk_widget_destroy(han_input_label->parent);
	    han_input_label = NULL;
	}
    }
    if (han_input_label)
	gtk_label_set_text(GTK_LABEL(han_input_label), st->data.text->string.multi_byte);
    return TRUE;
}

void 
status_bar(GtkWidget * box)
{
    GtkWidget *frame;
    GtkWidget *hbox;

    status_label = gtk_label_new("");
    gtk_box_pack_start(GTK_BOX(box), status_label, FALSE, FALSE, 2);
    gtk_misc_set_alignment(GTK_MISC(status_label), 0.0, 0.5);

    // time
    frame = gtk_frame_new(NULL);
    gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_IN);
    gtk_box_pack_end(GTK_BOX(box), frame, FALSE, FALSE, 5);
    time_label = gtk_label_new(" 00:00 ");
    gtk_widget_set_name(time_label, "time-label");
    gtk_container_add(GTK_CONTAINER(frame), time_label);

    // han input state
    frame = gtk_frame_new(NULL);
    gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_IN);
    gtk_box_pack_end(GTK_BOX(box), frame, FALSE, FALSE, 5);

    hbox = gtk_hbox_new(FALSE, 2);
    gtk_container_add(GTK_CONTAINER(frame), hbox);

    han_input_label = gtk_label_new(" [] ");
    gtk_container_add(GTK_CONTAINER(hbox), han_input_label);

    // in & out status report
#if 0
    in_pixmap[0] =;
    in_pixmap[1] =;
    out_pixmap[0] =;
    out_pixmap[1] =;
#endif
}

void append_message(const gchar *format, ...)
{
    gchar *orig, *new_str;
    va_list args;
    char *work_buf;

    gtk_label_get(GTK_LABEL(status_label), &orig);

    va_start (args, format);
    work_buf = g_strdup_vprintf (format, args);
    va_end (args);

    gtk_label_set_text (GTK_LABEL (status_label), 
    		   new_str = g_strconcat (orig, work_buf, NULL));
    g_free (new_str);
    g_free (work_buf);
}

void show_message(const gchar *format, ...)
{
    va_list args;
    char *buf;

    va_start (args, format);
    buf = g_strdup_vprintf (format, args);
    va_end (args);
    gtk_label_set_text (GTK_LABEL (status_label), buf);
    g_free (buf);
}

void show_time(int second)
{
    char buf[10];
    g_snprintf(buf, sizeof(buf), " %02d:%02d ", second / 60, second % 60);
    gtk_label_set_text (GTK_LABEL(time_label), buf);
}

void show_incoming(gboolean flag)
{
}

void show_outgoing(gboolean flag)
{
}
